/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.SimpleCqlDataType;

public class CustomCqlDataType
extends SimpleCqlDataType {
    private final String customClassName;

    public CustomCqlDataType(String customClassName) {
        this.customClassName = customClassName;
    }

    public String getCustomClassName() {
        return this.customClassName;
    }

    @Override
    public boolean isCustom() {
        return true;
    }

    @Override
    public boolean validate(String value) {
        return true;
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value termValue, Schema schema, Keyspace ks) {
        return null;
    }

    @Override
    public CqlDataType deepCopy(Keyspace keyspace) {
        return new CustomCqlDataType(this.customClassName);
    }

    @Override
    public final Type toGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        type.setCustomType(this.customClassName);
        return type;
    }

    @Override
    public String toCanonicalString() {
        return String.format("'%s'", this.customClassName);
    }

    @Override
    public int hashCode() {
        int result = 1;
        result = 31 * result + this.customClassName.hashCode();
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomCqlDataType)) {
            return false;
        }
        CustomCqlDataType other = (CustomCqlDataType)obj;
        return !(this.customClassName == null ? other.customClassName != null : !this.customClassName.equals(other.customClassName));
    }
}

