/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public final class DateCqlDataType
extends NativeCqlDataType {
    public static final DateCqlDataType INSTANCE = new DateCqlDataType();
    private static final Pattern patternIntTime = Pattern.compile("^-?\\d+$");
    private static final long maxSupportedDays = (long)Math.pow(2.0, 32.0) - 1L;
    private static final DateTimeFormatter formatter = DateTimeFormat.forPattern((String)"yyyy-MM-dd").withZone(DateTimeZone.UTC);
    private static final long minSupportedDateMillis = TimeUnit.DAYS.toMillis(Integer.MIN_VALUE);
    private static final long maxSupportedDateMillis = TimeUnit.DAYS.toMillis(Integer.MAX_VALUE);

    private DateCqlDataType() {
        super("date");
    }

    @Override
    public boolean validate(String value) {
        Matcher matcherIntTime;
        if (super.validate(value)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1).replace("''", "'");
        }
        if ((matcherIntTime = patternIntTime.matcher(value)).matches()) {
            try {
                long result = Long.parseLong(value);
                return result >= 0L && result <= maxSupportedDays;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        try {
            DateTime parsed = formatter.parseDateTime(value);
            long millis = parsed.getMillis();
            return millis >= minSupportedDateMillis && millis <= maxSupportedDateMillis;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || VARINT.equals(other);
    }
}

