/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class InetCqlDataType
extends NativeCqlDataType {
    private static final Pattern patternInet = Pattern.compile("^'(\\d+)\\.(\\d+)\\.(\\d+)\\.(\\d+)'$");
    public static final InetCqlDataType INSTANCE = new InetCqlDataType();

    private InetCqlDataType() {
        super("inet");
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            return true;
        }
        Matcher matcherInet = patternInet.matcher(value);
        if (matcherInet.matches()) {
            String s1 = matcherInet.group(1);
            String s2 = matcherInet.group(2);
            String s3 = matcherInet.group(3);
            String s4 = matcherInet.group(4);
            int n1 = Integer.parseInt(s1);
            int n2 = Integer.parseInt(s2);
            int n3 = Integer.parseInt(s3);
            int n4 = Integer.parseInt(s4);
            return n1 >= 0 && n1 <= 255 && n2 >= 0 && n2 <= 255 && n3 >= 0 && n3 <= 255 && n4 >= 0 && n4 <= 255;
        }
        return false;
    }
}

