/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CollectionLiteral;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.ListLiteral;
import com.datastax.devcenter.cql.cql.ListType;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;

public final class ListCqlDataType
extends CollectionCqlDataType {
    public ListCqlDataType(CqlDataType elementType) {
        super(elementType);
    }

    @Override
    public boolean isList() {
        return true;
    }

    @Override
    public ListCqlDataType deepCopy(Keyspace keyspace) {
        ListCqlDataType copy = new ListCqlDataType(this.elementType.deepCopy(keyspace));
        copy.setFrozen(this.frozen);
        return copy;
    }

    @Override
    public Type toCanonicalGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        ListType listType = CqlFactory.eINSTANCE.createListType();
        listType.setT(this.elementType.toGrammarType());
        type.setCollectionType(listType);
        return type;
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value value, Schema schema, Keyspace ks) {
        if (value == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null || !(collectionLiteral instanceof ListLiteral)) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        ListLiteral listLiteral = (ListLiteral)collectionLiteral;
        EList<Term> terms = listLiteral.getValues();
        if (terms == null) {
            return AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        return this.testAssignabilityOfElements((Collection<Term>)terms, this.getElementType(), schema, ks);
    }

    @Override
    public boolean validate(Term term) {
        if (term == null) {
            return false;
        }
        if (super.validate(term)) {
            return true;
        }
        Value value = term.getValue();
        if (value == null) {
            return false;
        }
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null || !(collectionLiteral instanceof ListLiteral)) {
            return false;
        }
        ListLiteral listLiteral = (ListLiteral)collectionLiteral;
        EList<Term> terms = listLiteral.getValues();
        if (terms == null) {
            return false;
        }
        for (Term t : terms) {
            if (this.elementType.validate(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toCanonicalString() {
        return String.format("list<%s>", this.elementType.toCanonicalString());
    }
}

