/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CollectionLiteral;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.JsonUserTypeLiteral;
import com.datastax.devcenter.cql.cql.MapEntry;
import com.datastax.devcenter.cql.cql.MapLiteral;
import com.datastax.devcenter.cql.cql.MapType;
import com.datastax.devcenter.cql.cql.SetLiteral;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import org.eclipse.emf.common.util.EList;

public final class MapCqlDataType
extends CollectionCqlDataType {
    private final CqlDataType keyType;

    public MapCqlDataType(CqlDataType keyType, CqlDataType elementType) {
        super(elementType);
        this.keyType = keyType;
    }

    public CqlDataType getKeyType() {
        return this.keyType;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    @Override
    public boolean isReachableFrom(UserType targetUserType) {
        return super.isReachableFrom(targetUserType) || this.keyType.isReachableFrom(targetUserType);
    }

    @Override
    public MapCqlDataType deepCopy(Keyspace keyspace) {
        MapCqlDataType copy = new MapCqlDataType(this.keyType.deepCopy(keyspace), this.elementType.deepCopy(keyspace));
        copy.setFrozen(this.frozen);
        return copy;
    }

    @Override
    public Type toCanonicalGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        MapType mapType = CqlFactory.eINSTANCE.createMapType();
        mapType.setT1(this.keyType.toGrammarType());
        mapType.setT2(this.elementType.toGrammarType());
        type.setCollectionType(mapType);
        return type;
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value value, Schema schema, Keyspace ks) {
        if (value == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null && value.getUserType() != null && value.getUserType() instanceof JsonUserTypeLiteral) {
            collectionLiteral = ((JsonUserTypeLiteral)value.getUserType()).getMapVersion();
            value.setUserType(null);
            value.setCollection(collectionLiteral);
        }
        if (collectionLiteral == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        if (collectionLiteral instanceof SetLiteral) {
            SetLiteral set = (SetLiteral)collectionLiteral;
            if (set.getValues() == null || set.getValues().isEmpty()) {
                return AssignabilityType.WEAKLY_ASSIGNABLE;
            }
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        if (!(collectionLiteral instanceof MapLiteral)) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        MapLiteral mapLiteral = (MapLiteral)collectionLiteral;
        EList<MapEntry> entries = mapLiteral.getEntries();
        if (entries == null) {
            return AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        AssignabilityType assignability = AssignabilityType.EXACT_MATCH;
        for (MapEntry entry : entries) {
            AssignabilityType keysTest = this.getKeyType().testAssignment(entry.getKey(), schema, ks);
            AssignabilityType elementTest = this.getElementType().testAssignment(entry.getValue(), schema, ks);
            if (assignability.isNotAssignable()) continue;
            if (keysTest.isNotAssignable() || elementTest.isNotAssignable()) {
                assignability = AssignabilityType.NOT_ASSIGNABLE;
                continue;
            }
            if (!keysTest.isWeaklyAssignable() && !elementTest.isWeaklyAssignable()) continue;
            assignability = AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        return assignability;
    }

    @Override
    public boolean validate(Term term) {
        if (term == null) {
            return false;
        }
        if (super.validate(term)) {
            return true;
        }
        Value value = term.getValue();
        if (value == null) {
            return false;
        }
        if (term.getAlternateValue() == null) {
            return this.validateValue(value);
        }
        return this.validateValue(value) | this.validateValue(term.getAlternateValue());
    }

    private boolean validateValue(Value value) {
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null || !(collectionLiteral instanceof MapLiteral)) {
            return false;
        }
        MapLiteral mapLiteral = (MapLiteral)collectionLiteral;
        EList<MapEntry> entries = mapLiteral.getEntries();
        if (entries == null) {
            return false;
        }
        for (MapEntry entry : entries) {
            if (this.keyType.validate(entry.getKey()) && this.elementType.validate(entry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toCanonicalString() {
        return String.format("map<%s, %s>", this.keyType.toCanonicalString(), this.elementType.toCanonicalString());
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.keyType == null ? 0 : this.keyType.hashCode());
        result = 31 * result + (this.elementType == null ? 0 : this.elementType.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof MapCqlDataType)) {
            return false;
        }
        MapCqlDataType other = (MapCqlDataType)obj;
        return !(this.keyType == null ? other.keyType != null : !this.keyType.equals(other.keyType));
    }
}

