/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.cql.validation.assignment.AssignmentTester;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.types.AsciiTextCqlTextDataType;
import com.datastax.devcenter.schema.types.BigIntCqlDataType;
import com.datastax.devcenter.schema.types.BlobCqlDataType;
import com.datastax.devcenter.schema.types.BooleanCqlDataType;
import com.datastax.devcenter.schema.types.CounterCqlDataType;
import com.datastax.devcenter.schema.types.DateCqlDataType;
import com.datastax.devcenter.schema.types.DecimalCqlDataType;
import com.datastax.devcenter.schema.types.DoubleCqlDataType;
import com.datastax.devcenter.schema.types.FloatCqlDataType;
import com.datastax.devcenter.schema.types.ImmutableCqlDataType;
import com.datastax.devcenter.schema.types.InetCqlDataType;
import com.datastax.devcenter.schema.types.IntCqlDataType;
import com.datastax.devcenter.schema.types.SmallIntCqlDataType;
import com.datastax.devcenter.schema.types.TextCqlDataType;
import com.datastax.devcenter.schema.types.TimeCqlDataType;
import com.datastax.devcenter.schema.types.TimeUuidCqlDataType;
import com.datastax.devcenter.schema.types.TimestampCqlDataType;
import com.datastax.devcenter.schema.types.TinyIntCqlDataType;
import com.datastax.devcenter.schema.types.UuidCqlDataType;
import com.datastax.devcenter.schema.types.VarIntCqlDataType;
import com.google.common.collect.ImmutableMap;
import java.util.Collection;
import java.util.Map;

public abstract class NativeCqlDataType
extends ImmutableCqlDataType {
    public static final AsciiTextCqlTextDataType ASCII = AsciiTextCqlTextDataType.INSTANCE;
    public static final BigIntCqlDataType BIGINT = BigIntCqlDataType.INSTANCE;
    public static final BlobCqlDataType BLOB = BlobCqlDataType.INSTANCE;
    public static final BooleanCqlDataType BOOLEAN = BooleanCqlDataType.INSTANCE;
    public static final CounterCqlDataType COUNTER = CounterCqlDataType.INSTANCE;
    public static final DecimalCqlDataType DECIMAL = DecimalCqlDataType.INSTANCE;
    public static final DoubleCqlDataType DOUBLE = DoubleCqlDataType.INSTANCE;
    public static final FloatCqlDataType FLOAT = FloatCqlDataType.INSTANCE;
    public static final InetCqlDataType INET = InetCqlDataType.INSTANCE;
    public static final IntCqlDataType INT = IntCqlDataType.INSTANCE;
    public static final SmallIntCqlDataType SMALLINT = SmallIntCqlDataType.INSTANCE;
    public static final TinyIntCqlDataType TINYINT = TinyIntCqlDataType.INSTANCE;
    public static final TextCqlDataType TEXT = TextCqlDataType.TEXT_INSTANCE;
    public static final TimestampCqlDataType TIMESTAMP = TimestampCqlDataType.INSTANCE;
    public static final TimeCqlDataType TIME = TimeCqlDataType.INSTANCE;
    public static final DateCqlDataType DATE = DateCqlDataType.INSTANCE;
    public static final TimeUuidCqlDataType TIMEUUID = TimeUuidCqlDataType.INSTANCE;
    public static final UuidCqlDataType UUID = UuidCqlDataType.INSTANCE;
    public static final TextCqlDataType VARCHAR = TextCqlDataType.VARCHAR_INSTANCE;
    public static final VarIntCqlDataType VARINT = VarIntCqlDataType.INSTANCE;
    private static final Map<String, NativeCqlDataType> nativeTypes = ImmutableMap.builder().put((Object)ASCII.toCanonicalString(), (Object)ASCII).put((Object)BIGINT.toCanonicalString(), (Object)BIGINT).put((Object)BLOB.toCanonicalString(), (Object)BLOB).put((Object)BOOLEAN.toCanonicalString(), (Object)BOOLEAN).put((Object)COUNTER.toCanonicalString(), (Object)COUNTER).put((Object)DECIMAL.toCanonicalString(), (Object)DECIMAL).put((Object)DOUBLE.toCanonicalString(), (Object)DOUBLE).put((Object)FLOAT.toCanonicalString(), (Object)FLOAT).put((Object)INET.toCanonicalString(), (Object)INET).put((Object)INT.toCanonicalString(), (Object)INT).put((Object)SMALLINT.toCanonicalString(), (Object)SMALLINT).put((Object)TINYINT.toCanonicalString(), (Object)TINYINT).put((Object)TEXT.toCanonicalString(), (Object)TEXT).put((Object)TIMESTAMP.toCanonicalString(), (Object)TIMESTAMP).put((Object)TIME.toCanonicalString(), (Object)TIME).put((Object)DATE.toCanonicalString(), (Object)DATE).put((Object)UUID.toCanonicalString(), (Object)UUID).put((Object)VARCHAR.toCanonicalString(), (Object)VARCHAR).put((Object)VARINT.toCanonicalString(), (Object)VARINT).put((Object)TIMEUUID.toCanonicalString(), (Object)TIMEUUID).build();
    private final String canonicalString;

    public static NativeCqlDataType getByCanonicalString(String canonical) {
        return nativeTypes.get(canonical.toLowerCase());
    }

    public static Collection<NativeCqlDataType> getNativeTypes() {
        return nativeTypes.values();
    }

    NativeCqlDataType(String canonicalString) {
        this.canonicalString = canonicalString;
    }

    @Override
    public final String toCanonicalString() {
        return this.canonicalString;
    }

    @Override
    public final Type toGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        type.setNativeType(this.toString());
        return type;
    }

    public boolean matches(Type type) {
        if (type == null || type.getNativeType() == null) {
            return false;
        }
        return this.toCanonicalString().equalsIgnoreCase(type.getNativeType());
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value termValue, Schema schema, Keyspace ks) {
        if (termValue != null && termValue.getConstant() != null) {
            return AssignmentTester.testAssignmentWithConstantLiteral(termValue.getConstant(), this);
        }
        return AssignabilityType.NOT_ASSIGNABLE;
    }
}

