/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CollectionLiteral;
import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.JsonArrayLiteral;
import com.datastax.devcenter.cql.cql.SetLiteral;
import com.datastax.devcenter.cql.cql.SetType;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.types.CollectionCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.util.Collection;
import org.eclipse.emf.common.util.EList;

public final class SetCqlDataType
extends CollectionCqlDataType {
    public SetCqlDataType(CqlDataType elementType) {
        super(elementType);
    }

    @Override
    public boolean isSet() {
        return true;
    }

    @Override
    public SetCqlDataType deepCopy(Keyspace keyspace) {
        SetCqlDataType copy = new SetCqlDataType(this.elementType.deepCopy(keyspace));
        copy.setFrozen(this.frozen);
        return copy;
    }

    @Override
    public Type toCanonicalGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        SetType setType = CqlFactory.eINSTANCE.createSetType();
        setType.setT(this.elementType.toGrammarType());
        type.setCollectionType(setType);
        return type;
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value value, Schema schema, Keyspace ks) {
        if (value == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null || !(collectionLiteral instanceof SetLiteral) && !(collectionLiteral instanceof JsonArrayLiteral)) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        EList<Term> terms = null;
        SetLiteral setLiteral = null;
        if (collectionLiteral instanceof SetLiteral) {
            setLiteral = (SetLiteral)collectionLiteral;
        } else if (collectionLiteral instanceof JsonArrayLiteral) {
            setLiteral = ((JsonArrayLiteral)collectionLiteral).getSetVersion();
            value.setCollection(setLiteral);
        }
        terms = setLiteral.getValues();
        if (terms == null) {
            return AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        return this.testAssignabilityOfElements((Collection<Term>)terms, this.getElementType(), schema, ks);
    }

    @Override
    public boolean validate(Term term) {
        if (term == null) {
            return false;
        }
        if (super.validate(term)) {
            return true;
        }
        Value value = term.getValue();
        if (value == null) {
            return false;
        }
        CollectionLiteral collectionLiteral = value.getCollection();
        if (collectionLiteral == null || !(collectionLiteral instanceof SetLiteral)) {
            return false;
        }
        SetLiteral setLiteral = (SetLiteral)collectionLiteral;
        EList<Term> terms = setLiteral.getValues();
        if (terms == null) {
            return false;
        }
        for (Term t : terms) {
            if (this.elementType.validate(t)) continue;
            return false;
        }
        return true;
    }

    @Override
    public String toCanonicalString() {
        return String.format("set<%s>", this.elementType.toCanonicalString());
    }
}

