/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;

public class TextCqlDataType
extends NativeCqlDataType {
    public static final TextCqlDataType TEXT_INSTANCE = new TextCqlDataType("text");
    public static final TextCqlDataType VARCHAR_INSTANCE = new TextCqlDataType("varchar");

    private TextCqlDataType(String canonicalString) {
        super(canonicalString);
    }

    @Override
    public boolean isText() {
        return true;
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            return true;
        }
        return value.startsWith("'") && value.endsWith("'") || value.startsWith("$$") && value.endsWith("$$");
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || ASCII.equals(other) || TEXT.equals(other) || VARCHAR.equals(other);
    }
}

