/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class TimeCqlDataType
extends NativeCqlDataType {
    public static final TimeCqlDataType INSTANCE = new TimeCqlDataType();
    private static final Pattern patternIntTime = Pattern.compile("^-?\\d+$");

    private TimeCqlDataType() {
        super("time");
    }

    @Override
    public boolean validate(String value) {
        Matcher matcherIntTime;
        if (super.validate(value)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1).replace("''", "'");
        }
        if ((matcherIntTime = patternIntTime.matcher(value)).matches()) {
            try {
                long result = Long.parseLong(value);
                return result >= 0L && result <= TimeUnit.DAYS.toNanos(1L);
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return this.parseTimeStrictly(value);
    }

    private boolean parseTimeStrictly(String s) {
        try {
            TimeCqlDataType.cassandraParseTimeStrictly(s);
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
    }

    private static Long cassandraParseTimeStrictly(String s) throws IllegalArgumentException {
        long second;
        long minute;
        long hour;
        long a_nanos = 0L;
        String formatError = "Timestamp format must be hh:mm:ss[.fffffffff]";
        String zeros = "000000000";
        if (s == null) {
            throw new IllegalArgumentException(formatError);
        }
        s = s.trim();
        int firstColon = s.indexOf(58);
        int secondColon = s.indexOf(58, firstColon + 1);
        if (firstColon > 0 && secondColon > 0 && secondColon < s.length() - 1) {
            int period = s.indexOf(46, secondColon + 1);
            hour = Integer.parseInt(s.substring(0, firstColon));
            if (hour < 0L || hour >= 24L) {
                throw new IllegalArgumentException("Hour out of bounds.");
            }
            minute = Integer.parseInt(s.substring(firstColon + 1, secondColon));
            if (minute < 0L || minute >= 60L) {
                throw new IllegalArgumentException("Minute out of bounds.");
            }
            if (period > 0 && period < s.length() - 1) {
                second = Integer.parseInt(s.substring(secondColon + 1, period));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
                String nanos_s = s.substring(period + 1);
                if (nanos_s.length() > 9) {
                    throw new IllegalArgumentException(formatError);
                }
                if (!Character.isDigit(nanos_s.charAt(0))) {
                    throw new IllegalArgumentException(formatError);
                }
                nanos_s = String.valueOf(nanos_s) + zeros.substring(0, 9 - nanos_s.length());
                a_nanos = Integer.parseInt(nanos_s);
            } else {
                if (period > 0) {
                    throw new IllegalArgumentException(formatError);
                }
                second = Integer.parseInt(s.substring(secondColon + 1));
                if (second < 0L || second >= 60L) {
                    throw new IllegalArgumentException("Second out of bounds.");
                }
            }
        } else {
            throw new IllegalArgumentException(formatError);
        }
        long rawTime = 0L;
        rawTime += TimeUnit.HOURS.toNanos(hour);
        rawTime += TimeUnit.MINUTES.toNanos(minute);
        rawTime += TimeUnit.SECONDS.toNanos(second);
        return rawTime += a_nanos;
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || BIGINT.equals(other);
    }
}

