/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.CqlDataType;
import com.datastax.devcenter.schema.types.NativeCqlDataType;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.lang.time.DateUtils;

public final class TimestampCqlDataType
extends NativeCqlDataType {
    public static final TimestampCqlDataType INSTANCE = new TimestampCqlDataType();
    private static final Pattern patternIntTime = Pattern.compile("^-?\\d+$");
    private static final String[] dateStringPatterns = new String[]{"yyyy-MM-dd HH:mm", "yyyy-MM-dd HH:mmZ", "yyyy-MM-dd HH:mmZZ", "yyyy-MM-dd HH:mmZZZ", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm:ssZ", "yyyy-MM-dd HH:mm:ssZZ", "yyyy-MM-dd HH:mm:ssZZZ", "yyyy-MM-dd HH:mm:ss.SSS", "yyyy-MM-dd HH:mm:ss.SSSZ", "yyyy-MM-dd HH:mm:ss.SSSZZ", "yyyy-MM-dd HH:mm:ss.SSSZZZ", "yyyy-MM-dd'T'HH:mm", "yyyy-MM-dd'T'HH:mmZ", "yyyy-MM-dd'T'HH:mmZZ", "yyyy-MM-dd'T'HH:mmZZZ", "yyyy-MM-dd'T'HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssZZ", "yyyy-MM-dd'T'HH:mm:ssZZZ", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ss.SSSZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZZ", "yyyy-MM-dd'T'HH:mm:ss.SSSZZZ", "yyyy-MM-dd", "yyyy-MM-ddZ", "yyyy-MM-ddZZ", "yyyy-MM-ddZZZ"};

    private TimestampCqlDataType() {
        super("timestamp");
    }

    @Override
    public boolean validate(String value) {
        Matcher matcherIntTime;
        if (super.validate(value)) {
            return true;
        }
        if (value == null) {
            return false;
        }
        if ("'now'".equalsIgnoreCase(value)) {
            return true;
        }
        if (value.startsWith("'") && value.endsWith("'")) {
            value = value.substring(1, value.length() - 1).replace("''", "'");
        }
        if ((matcherIntTime = patternIntTime.matcher(value)).matches()) {
            try {
                Long.parseLong(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return this.parseTimestampString(value);
    }

    private boolean parseTimestampString(String value) {
        try {
            DatatypeConverter.parseDateTime((String)value).getTimeInMillis();
            return true;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            value = value.replaceFirst("(?<=[+-]\\d{2})$", "00");
            Matcher matcherISOTimezone = Pattern.compile(".*[+-]\\d{2}:?(\\d{2})?Z").matcher(value);
            if (value.endsWith("Z") && !matcherISOTimezone.matches()) {
                value = value.substring(0, value.length() - 1);
            }
            try {
                DateUtils.parseDateStrictly((String)value, (String[])dateStringPatterns).getTime();
                return true;
            }
            catch (ParseException parseException) {
                return false;
            }
        }
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || BIGINT.equals(other);
    }
}

