/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.JsonArrayLiteral;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.TupleLiteral;
import com.datastax.devcenter.cql.cql.TupleType;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.ComplexCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class TupleCqlDataType
extends ComplexCqlDataType {
    private final List<CqlDataType> innerTypes;

    protected TupleCqlDataType(UserType userType) {
        ArrayList<CqlDataType> innerTypes = new ArrayList<CqlDataType>();
        for (UserTypeField field : userType.getFields()) {
            innerTypes.add(field.getType());
        }
        this.innerTypes = ImmutableList.copyOf(innerTypes);
        this.frozen = true;
    }

    public TupleCqlDataType(List<CqlDataType> innerTypes) {
        this.innerTypes = ImmutableList.copyOf(innerTypes);
        this.frozen = true;
    }

    public List<CqlDataType> getInnerTypes() {
        return this.innerTypes;
    }

    @Override
    public boolean isTuple() {
        return true;
    }

    @Override
    public void setFrozen(boolean frozen) {
    }

    @Override
    public boolean isReachableFrom(UserType targetUserType) {
        for (CqlDataType innerType : this.innerTypes) {
            if (!innerType.isReachableFrom(targetUserType)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean validate(Term term) {
        if (term == null) {
            return false;
        }
        if (super.validate(term)) {
            return true;
        }
        Value value = term.getValue();
        if (value == null) {
            return false;
        }
        EList<Term> terms = null;
        if (value.getTupleLiteral() != null) {
            TupleLiteral tupleLiteral = value.getTupleLiteral();
            terms = tupleLiteral.getValues();
        }
        if (terms == null) {
            return false;
        }
        if (terms.size() > this.innerTypes.size()) {
            return false;
        }
        int i = 0;
        while (i < terms.size()) {
            Term tupleLiteralValue;
            CqlDataType innerType = this.innerTypes.get(i);
            if (!innerType.validate(tupleLiteralValue = (Term)terms.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    protected AssignabilityType testAssignmentInternal(Value value, Schema schema, Keyspace ks) {
        if (value == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        TupleLiteral tupleLiteral = value.getTupleLiteral();
        if (tupleLiteral == null && value.getCollection() != null && value.getCollection() instanceof JsonArrayLiteral && (tupleLiteral = ((JsonArrayLiteral)value.getCollection()).getTupleVersion()) != null) {
            value.setTupleLiteral(tupleLiteral);
            value.setCollection(null);
        }
        if (tupleLiteral == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        EList<Term> tupleLiteralValues = tupleLiteral.getValues();
        if (tupleLiteralValues.size() > this.innerTypes.size()) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        AssignabilityType assignabilityType = AssignabilityType.EXACT_MATCH;
        int i = 0;
        while (i < tupleLiteralValues.size()) {
            CqlDataType innerType = this.innerTypes.get(i);
            Term tupleLiteralValue = (Term)tupleLiteralValues.get(i);
            AssignabilityType tupleValueAssignability = innerType.testAssignment(tupleLiteralValue, schema, ks);
            if (!assignabilityType.isNotAssignable()) {
                if (tupleValueAssignability.isNotAssignable()) {
                    assignabilityType = AssignabilityType.NOT_ASSIGNABLE;
                } else if (tupleValueAssignability.isWeaklyAssignable()) {
                    assignabilityType = AssignabilityType.WEAKLY_ASSIGNABLE;
                }
            }
            ++i;
        }
        return assignabilityType;
    }

    @Override
    public TupleCqlDataType deepCopy(Keyspace keyspace) {
        return new TupleCqlDataType(Lists.transform(this.innerTypes, (Function)new CqlDataType.DeepCopy(keyspace)));
    }

    @Override
    public Type toCanonicalGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        TupleType tupleType = CqlFactory.eINSTANCE.createTupleType();
        tupleType.getTupleTypes().addAll((Collection)Lists.transform(this.innerTypes, (Function)TO_GRAMMAR_TYPE));
        type.setTuple(tupleType);
        return type;
    }

    @Override
    public String toCanonicalString() {
        return String.format("tuple<%s>", Joiner.on((String)", ").join((Iterable)Lists.transform(this.innerTypes, (Function)TO_CANONICAL_STRING)));
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode((Object[])new Object[]{this.getInnerTypes()});
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof TupleCqlDataType)) {
            return false;
        }
        TupleCqlDataType other = (TupleCqlDataType)obj;
        return !(this.innerTypes == null ? other.innerTypes != null : !this.innerTypes.equals(other.innerTypes));
    }
}

