/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.cql.cql.CqlFactory;
import com.datastax.devcenter.cql.cql.JsonMapLiteral;
import com.datastax.devcenter.cql.cql.Term;
import com.datastax.devcenter.cql.cql.Type;
import com.datastax.devcenter.cql.cql.TypeEntity;
import com.datastax.devcenter.cql.cql.UserTypeEntry;
import com.datastax.devcenter.cql.cql.UserTypeLiteral;
import com.datastax.devcenter.cql.cql.Value;
import com.datastax.devcenter.cql.util.ModelUtil;
import com.datastax.devcenter.cql.validation.assignment.AssignabilityType;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.types.TupleCqlDataType;
import java.util.Iterator;
import java.util.List;

public class UserDefinedTypeCqlDataType
extends TupleCqlDataType {
    private final UserType userType;

    public UserDefinedTypeCqlDataType(UserType userType) {
        super(userType);
        this.userType = userType;
    }

    public UserType getUserType() {
        return this.userType;
    }

    @Override
    public boolean isTuple() {
        return false;
    }

    @Override
    public boolean isUserDefinedType() {
        return true;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean isReachableFrom(UserType targetUserType) {
        List<UserTypeField> fields;
        if (this.userType == null) return false;
        if (this.userType.getKeyspace() == null) return false;
        if (targetUserType == null) return false;
        if (targetUserType.getKeyspace() == null) return false;
        if (!this.userType.getKeyspace().equals(targetUserType.getKeyspace())) {
            return false;
        }
        if (this.userType.equals(targetUserType)) {
            return true;
        }
        List<UserTypeField> list = fields = this.userType.getFields();
        synchronized (list) {
            UserTypeField field;
            Iterator<UserTypeField> iterator = fields.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!(field = iterator.next()).getType().isReachableFrom(targetUserType));
            return true;
        }
    }

    @Override
    public AssignabilityType testAssignmentInternal(Value value, Schema schema, Keyspace ks) {
        if (value == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        if (this.userType == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        if (value.getUserType() != null || value.getCollection() != null && value.getCollection() instanceof JsonMapLiteral) {
            return this.testAssignmentAsUDT(schema, ks, value);
        }
        if (value.getTupleLiteral() != null) {
            return super.testAssignmentInternal(value, schema, ks);
        }
        return AssignabilityType.NOT_ASSIGNABLE;
    }

    private AssignabilityType testAssignmentAsUDT(Schema schema, Keyspace ks, Value value) {
        AssignabilityType assignabilityType = AssignabilityType.EXACT_MATCH;
        UserTypeLiteral userTypeLiteral = value.getUserType();
        if (userTypeLiteral == null) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        List<UserTypeField> userTypeFields = this.userType.getFields();
        if (userTypeLiteral.getEntries().size() > (userTypeFields != null ? userTypeFields.size() : 0)) {
            return AssignabilityType.NOT_ASSIGNABLE;
        }
        for (UserTypeEntry userTypeEntry : userTypeLiteral.getEntries()) {
            String fieldName = ModelUtil.stripName(userTypeEntry.getUserTypeField().getName());
            if (fieldName == null) {
                return AssignabilityType.NOT_ASSIGNABLE;
            }
            UserTypeField field = this.userType.getField(fieldName);
            if (field == null) {
                return AssignabilityType.NOT_ASSIGNABLE;
            }
            AssignabilityType fieldAssignability = field.getType().testAssignment(userTypeEntry.getValue(), schema, ks);
            if (fieldAssignability.isNotAssignable()) {
                return AssignabilityType.NOT_ASSIGNABLE;
            }
            if (!fieldAssignability.isWeaklyAssignable()) continue;
            assignabilityType = AssignabilityType.WEAKLY_ASSIGNABLE;
        }
        return assignabilityType;
    }

    @Override
    public boolean validate(Term term) {
        if (term == null) {
            return false;
        }
        if (super.validate(term)) {
            return true;
        }
        Value value = term.getValue();
        if (value == null) {
            return false;
        }
        if (this.userType == null) {
            return false;
        }
        UserTypeLiteral userTypeLiteral = value.getUserType();
        if (userTypeLiteral == null) {
            return false;
        }
        List<UserTypeField> userTypeFields = this.userType.getFields();
        if (userTypeLiteral.getEntries().size() > userTypeFields.size()) {
            return false;
        }
        for (UserTypeEntry userTypeEntry : userTypeLiteral.getEntries()) {
            String fieldName = ModelUtil.stripName(userTypeEntry.getUserTypeField().getName());
            if (fieldName == null) {
                return false;
            }
            UserTypeField field = this.userType.getField(fieldName);
            if (field == null) {
                return false;
            }
            if (field.getType().validate(userTypeEntry.getValue())) continue;
            return false;
        }
        return true;
    }

    @Override
    public UserDefinedTypeCqlDataType deepCopy(Keyspace keyspace) {
        return new UserDefinedTypeCqlDataType(this.userType.deepCopy(keyspace));
    }

    @Override
    public Type toCanonicalGrammarType() {
        Type type = CqlFactory.eINSTANCE.createType();
        TypeEntity typeEntity = CqlFactory.eINSTANCE.createTypeEntity();
        typeEntity.setName(this.userType.getName());
        type.setUserType(typeEntity);
        return type;
    }

    @Override
    public String toCanonicalString() {
        return this.userType.getName();
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj);
    }
}

