/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.types;

import com.datastax.devcenter.schema.types.AbstractIntegerCqlDataType;
import com.datastax.devcenter.schema.types.CqlDataType;
import java.math.BigInteger;

public class VarIntCqlDataType
extends AbstractIntegerCqlDataType {
    public static final VarIntCqlDataType INSTANCE = new VarIntCqlDataType();

    private VarIntCqlDataType() {
        super("varint");
    }

    @Override
    public boolean validate(String value) {
        if (super.validate(value)) {
            try {
                new BigInteger(value);
                return true;
            }
            catch (NumberFormatException numberFormatException) {
                return false;
            }
        }
        return false;
    }

    @Override
    public boolean isCompatibleWith(CqlDataType other) {
        return super.isCompatibleWith(other) || BIGINT.equals(other) || INT.equals(other) || TIMESTAMP.equals(other);
    }
}

