/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.interfaces.DevCenterConstants;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class ConnectionsActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.datastax.devcenter.connections";
    public static final String CONNECTIONS_PROJECT = "connections";
    public static final String CONNECTIONS_FILE_NAME = "connectionList.xml";
    private static ConnectionsActivator plugin;
    private static BundleContext connectionsBundleContext;
    private IWorkspaceRoot workspaceRoot;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
        connectionsBundleContext = context;
        this.workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        this.loadConnections();
    }

    public void stop(BundleContext context) throws Exception {
        this.persistConnectionsList();
        plugin = null;
        super.stop(context);
    }

    public static ConnectionsActivator getDefault() {
        return plugin;
    }

    public static BundleContext getConnectionsBundleContext() {
        return connectionsBundleContext;
    }

    private void loadConnections() {
        try {
            String connectionListFileName;
            File connectionListFile;
            String rootLocationString = this.workspaceRoot.getLocation().toOSString();
            String connectionsFolderString = String.valueOf(rootLocationString) + DevCenterConstants.FILE_SEPARATOR + CONNECTIONS_PROJECT;
            File connectionsFolderFile = new File(connectionsFolderString);
            if (!connectionsFolderFile.exists()) {
                FileUtils.forceMkdir((File)connectionsFolderFile);
            }
            if ((connectionListFile = new File(connectionListFileName = connectionsFolderFile + DevCenterConstants.FILE_SEPARATOR + CONNECTIONS_FILE_NAME)).exists()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConnectionList.class});
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                FileInputStream connectionListInputStream = new FileInputStream(connectionListFileName);
                Object object = unmarshaller.unmarshal((InputStream)connectionListInputStream);
                ConnectionList loadedConnectionsList = (ConnectionList)object;
                for (Connection connection : loadedConnectionsList.getConnections()) {
                    ConnectionList.getInstance().addConnection(connection);
                }
            }
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }

    private void persistConnectionsList() {
        try {
            String rootLocationString = this.workspaceRoot.getLocation().toOSString();
            String connectionsFolderString = String.valueOf(rootLocationString) + DevCenterConstants.FILE_SEPARATOR + CONNECTIONS_PROJECT;
            File connectionsFolderFile = new File(connectionsFolderString);
            String connectionListFileName = connectionsFolderFile + DevCenterConstants.FILE_SEPARATOR + CONNECTIONS_FILE_NAME;
            JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ConnectionList.class});
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            FileOutputStream xmlOutputStream = new FileOutputStream(connectionListFileName);
            marshaller.marshal((Object)ConnectionList.getInstance(), (OutputStream)xmlOutputStream);
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
    }
}

