/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.models;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.utils.PasswordEncrypter;
import com.datastax.devcenter.connections.models.Compression;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.util.IMetadataStatement;
import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.Host;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.ResultSet;
import com.datastax.driver.core.ResultSetFuture;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.SchemaChangeListener;
import com.datastax.driver.core.Session;
import com.datastax.driver.core.SimpleStatement;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.VersionNumber;
import com.datastax.driver.core.exceptions.TraceRetrievalException;
import com.datastax.driver.core.policies.DCAwareRoundRobinPolicy;
import com.datastax.driver.core.policies.LoadBalancingPolicy;
import com.datastax.driver.core.policies.TokenAwarePolicy;
import com.datastax.driver.core.policies.WhiteListPolicy;
import com.google.common.collect.ImmutableList;
import java.io.FileInputStream;
import java.net.InetSocketAddress;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.runtime.PlatformObject;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class Connection
extends PlatformObject
implements Cloneable {
    private static final ConsistencyLevel DEFAULT_CONSISTENCY_LEVEL = ConsistencyLevel.ONE;
    private static final int DEFAULT_CQL_NATIVE_PORT = 9042;
    private static final String[] cipherSuites = new String[]{"TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA"};
    private String name = "";
    private List<String> hosts;
    private int port = 9042;
    private Compression compression;
    @Deprecated
    private boolean storePassword;
    private boolean requiresCredentials;
    private String login = "";
    private byte[] encryptedPassword = "".getBytes();
    private boolean ssl;
    private String truststorePath = "";
    private byte[] encryptedTruststorePassword;
    private boolean requiresClientAuthentication;
    private String keystorePath = "";
    private byte[] encryptedKeystorePassword;
    @XmlTransient
    private Cluster cluster;
    @XmlTransient
    private Session session;
    @XmlTransient
    private boolean canAutomaticallyOpen = true;
    @XmlTransient
    private final List<Listener> listeners;
    @XmlTransient
    private final PasswordEncrypter encrypter;
    @XmlTransient
    private final DriverListener driverListener;

    public Connection() {
        this.compression = Compression.SNAPPY;
        this.hosts = new ArrayList<String>();
        this.listeners = Collections.synchronizedList(new ArrayList());
        this.encrypter = new PasswordEncrypter();
        this.driverListener = new DriverListener();
        this.encryptedTruststorePassword = "".getBytes();
        this.encryptedKeystorePassword = "".getBytes();
    }

    public Connection clone() {
        Connection clonedConnection = new Connection();
        clonedConnection.name = this.name;
        clonedConnection.hosts = new ArrayList<String>(this.hosts);
        clonedConnection.login = this.login;
        clonedConnection.encryptedPassword = this.encryptedPassword;
        clonedConnection.port = this.port;
        clonedConnection.requiresCredentials = this.requiresCredentials;
        clonedConnection.ssl = this.ssl;
        clonedConnection.storePassword = this.storePassword;
        clonedConnection.compression = this.compression;
        clonedConnection.truststorePath = this.truststorePath;
        clonedConnection.encryptedTruststorePassword = this.encryptedTruststorePassword;
        clonedConnection.requiresClientAuthentication = this.requiresClientAuthentication;
        clonedConnection.keystorePath = this.keystorePath;
        clonedConnection.encryptedKeystorePassword = this.encryptedKeystorePassword;
        return clonedConnection;
    }

    public void replace(Connection newConnection) {
        this.name = newConnection.name;
        this.hosts = new ArrayList<String>(newConnection.hosts);
        this.port = newConnection.port;
        this.requiresCredentials = newConnection.requiresCredentials;
        this.login = newConnection.login;
        this.encryptedPassword = newConnection.encryptedPassword;
        this.ssl = newConnection.ssl;
        this.truststorePath = newConnection.truststorePath;
        this.encryptedTruststorePassword = newConnection.encryptedTruststorePassword;
        this.requiresClientAuthentication = newConnection.requiresClientAuthentication;
        this.keystorePath = newConnection.keystorePath;
        this.encryptedKeystorePassword = newConnection.encryptedKeystorePassword;
        this.compression = newConnection.compression;
        if (this.isOpen()) {
            try {
                this.disconnect();
                this.connect(newConnection.buildCluster());
            }
            catch (Exception e) {
                DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)"Connection", (String)new Object(){}.getClass().getEnclosingMethod().getName());
            }
        }
        this.fireConnectionChanged();
    }

    public void open() throws Exception {
        if (this.isOpen()) {
            return;
        }
        try {
            try {
                this.connect(this.buildCluster());
            }
            catch (Exception e) {
                DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)"Connection", (String)new Object(){}.getClass().getEnclosingMethod().getName());
                throw e;
            }
        }
        finally {
            this.canAutomaticallyOpen = false;
            this.fireConnectionChanged();
        }
    }

    public void close() {
        if (this.isClosed()) {
            return;
        }
        try {
            this.disconnect();
        }
        finally {
            this.fireConnectionChanged();
        }
    }

    public void test() throws Exception {
        try {
            Cluster cluster = this.buildCluster();
            Session session = cluster.connect();
            session.close();
        }
        catch (Exception e) {
            DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)"Connection", (String)new Object(){}.getClass().getEnclosingMethod().getName());
            throw e;
        }
    }

    @XmlTransient
    public boolean isOpen() {
        return this.cluster != null;
    }

    @XmlTransient
    public boolean isClosed() {
        return this.cluster == null;
    }

    @XmlTransient
    public Collection<Host> getConnectedHosts() {
        if (this.isOpen()) {
            return this.session.getState().getConnectedHosts();
        }
        return Collections.emptySet();
    }

    public ResultSet execute(Collection<String> queries, String defaultKeySpaceName, boolean tracingEnabled) throws Exception {
        return this.execute(queries, defaultKeySpaceName, tracingEnabled, DEFAULT_CONSISTENCY_LEVEL);
    }

    public ResultSet execute(Collection<String> queries, String defaultKeySpaceName, boolean tracingEnabled, ConsistencyLevel consistencyLevel) throws Exception {
        Session session = null;
        ResultSet resultSet = null;
        String query = "";
        try {
            session = this.getSession(defaultKeySpaceName);
            Iterator<String> iterator = queries.iterator();
            while (iterator.hasNext()) {
                query = iterator.next();
                SimpleStatement stmt = new SimpleStatement(query);
                stmt.setConsistencyLevel(consistencyLevel);
                if (tracingEnabled && !iterator.hasNext()) {
                    stmt.enableTracing();
                }
                resultSet = session.execute((Statement)stmt);
                if (!tracingEnabled || iterator.hasNext()) continue;
                try {
                    resultSet.getExecutionInfo().getQueryTrace().getEvents();
                }
                catch (TraceRetrievalException tre) {
                    DevCenterLogger.error((String)tre.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                    if (tre.getCause() == null) continue;
                    DevCenterLogger.error((String)tre.getCause().toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
            }
            ResultSet resultSet2 = resultSet;
            return resultSet2;
        }
        catch (Exception e) {
            DevCenterLogger.error((String)String.format("%s\n%s", query, e.toString()), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    public List<ResultSet> execute(Collection<String> serialQueries, String selectStmt, IMetadataStatement metadataSelectStmt, String defaultKeySpaceName, boolean tracingEnabled, ConsistencyLevel consistencyLevel) throws Exception {
        Session session = null;
        String query2 = "";
        try {
            ResultSet metaSelectResultSet;
            ResultSet selectResultSet;
            block19: {
                block18: {
                    String metadataStmtString;
                    session = this.getSession(defaultKeySpaceName);
                    if (serialQueries != null) {
                        for (String query2 : serialQueries) {
                            SimpleStatement stmt = new SimpleStatement(query2);
                            stmt.setConsistencyLevel(consistencyLevel);
                            session.execute((Statement)stmt);
                        }
                    }
                    query2 = selectStmt;
                    SimpleStatement stmt = new SimpleStatement(query2);
                    stmt.setConsistencyLevel(consistencyLevel);
                    if (tracingEnabled) {
                        stmt.enableTracing();
                    }
                    ResultSetFuture selectResultSetFuture = session.executeAsync((Statement)stmt);
                    metadataSelectStmt.injectSelectors(this);
                    Set<String> injectedSelectors = metadataSelectStmt.getInjectedSelectors();
                    ResultSetFuture metadataResultSetFuture = null;
                    if (injectedSelectors != null && !injectedSelectors.isEmpty() && (metadataStmtString = metadataSelectStmt.getMetadataStatement()) != null) {
                        SimpleStatement metaStmt = new SimpleStatement(metadataStmtString);
                        metaStmt.setConsistencyLevel(DEFAULT_CONSISTENCY_LEVEL);
                        metadataResultSetFuture = session.executeAsync((Statement)metaStmt);
                    }
                    selectResultSet = (ResultSet)selectResultSetFuture.get();
                    metaSelectResultSet = null;
                    try {
                        if (metadataResultSetFuture != null) {
                            metaSelectResultSet = (ResultSet)metadataResultSetFuture.get();
                        }
                    }
                    catch (Exception e) {
                        DevCenterLogger.error((String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                        if (e.getCause() == null) break block18;
                        DevCenterLogger.error((String)e.getCause().toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                    }
                }
                if (tracingEnabled) {
                    try {
                        selectResultSet.getExecutionInfo().getQueryTrace().getEvents();
                    }
                    catch (TraceRetrievalException tre) {
                        DevCenterLogger.error((String)tre.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                        if (tre.getCause() == null) break block19;
                        DevCenterLogger.error((String)tre.getCause().toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                    }
                }
            }
            if (metaSelectResultSet == null) {
                ImmutableList immutableList = ImmutableList.of((Object)selectResultSet);
                return immutableList;
            }
            ImmutableList immutableList = ImmutableList.of((Object)selectResultSet, (Object)metaSelectResultSet);
            return immutableList;
        }
        catch (Exception e) {
            DevCenterLogger.error((String)String.format("%s\n%s", query2, e.toString()), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
    }

    private Session getSession(String defaultKeySpaceName) throws Exception {
        Session session = null;
        if (this.isClosed()) {
            this.open();
        }
        session = StringUtils.isNotEmpty((String)defaultKeySpaceName) ? this.cluster.connect(defaultKeySpaceName) : this.cluster.connect();
        return session;
    }

    @XmlTransient
    public synchronized Metadata getMetadata() {
        Metadata metadata = null;
        try {
            if (this.isClosed() && this.canAutomaticallyOpen) {
                this.open();
            }
            metadata = this.cluster == null ? null : this.cluster.getMetadata();
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)"Connection", (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
        return metadata;
    }

    public VersionNumber getCassandraVersion() {
        Metadata metadata = this.getMetadata();
        if (metadata != null) {
            VersionNumber minCassandraVersion = VersionNumber.parse((String)"9999.9999.9999");
            for (Host host : metadata.getAllHosts()) {
                VersionNumber hostCassandraVersion = host.getCassandraVersion();
                if (hostCassandraVersion.compareTo(minCassandraVersion) >= 0) continue;
                minCassandraVersion = hostCassandraVersion;
            }
            return minCassandraVersion;
        }
        return null;
    }

    private void connect(Cluster cluster) {
        this.session = cluster.connect();
        this.cluster = cluster;
        this.cluster.register((Host.StateListener)this.driverListener);
        this.cluster.register((SchemaChangeListener)this.driverListener);
    }

    private void disconnect() {
        try {
            if (this.isOpen()) {
                this.cluster.unregister((Host.StateListener)this.driverListener);
                this.cluster.unregister((SchemaChangeListener)this.driverListener);
                this.session.close();
                this.cluster.close();
            }
        }
        finally {
            this.cluster = null;
            this.session = null;
        }
    }

    private Cluster buildCluster() throws Exception {
        ArrayList<InetSocketAddress> whiteList = new ArrayList<InetSocketAddress>();
        for (String host : this.hosts) {
            whiteList.add(new InetSocketAddress(host, this.port));
        }
        Cluster.Builder clusterBuilder = Cluster.builder().addContactPoints(this.hosts.toArray(new String[this.hosts.size()])).withPort(this.port).withLoadBalancingPolicy((LoadBalancingPolicy)new WhiteListPolicy((LoadBalancingPolicy)new TokenAwarePolicy((LoadBalancingPolicy)new DCAwareRoundRobinPolicy()), whiteList));
        switch (this.compression) {
            case SNAPPY: {
                clusterBuilder.withCompression(ProtocolOptions.Compression.SNAPPY);
                break;
            }
            case LZ4: {
                clusterBuilder.withCompression(ProtocolOptions.Compression.LZ4);
                break;
            }
            default: {
                clusterBuilder.withCompression(ProtocolOptions.Compression.NONE);
            }
        }
        if (this.ssl) {
            if (StringUtils.isEmpty((String)this.truststorePath)) {
                throw new Exception("SSL Truststore path is empty");
            }
            if (StringUtils.isEmpty((String)this.getTruststorePassword())) {
                throw new Exception("SSL Truststore password is empty");
            }
            if (this.requiresClientAuthentication) {
                if (StringUtils.isEmpty((String)this.keystorePath)) {
                    throw new Exception("SSL Keystore path is empty");
                }
                if (StringUtils.isEmpty((String)this.getKeystorePassword())) {
                    throw new Exception("SSL Keystore password is empty");
                }
            }
            SSLContext context = Connection.getSSLContext(this.truststorePath, this.getTruststorePassword(), this.requiresClientAuthentication, this.keystorePath, this.getKeystorePassword());
            clusterBuilder.withSSL(new SSLOptions(context, cipherSuites));
        }
        if (this.requiresCredentials) {
            if (StringUtils.isEmpty((String)this.login)) {
                throw new Exception("User login is empty");
            }
            if (StringUtils.isEmpty((String)this.getPassword())) {
                throw new Exception("User password is empty");
            }
            clusterBuilder.withCredentials(this.login, this.getPassword());
        }
        return clusterBuilder.build();
    }

    private static SSLContext getSSLContext(String truststorePath, String truststorePassword, boolean useKeystore, String keystorePath, String keystorePassword) throws Exception {
        SSLContext ctx = SSLContext.getInstance("SSL");
        FileInputStream tsf = new FileInputStream(truststorePath);
        KeyStore ts = KeyStore.getInstance("JKS");
        ts.load(tsf, truststorePassword.toCharArray());
        TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        tmf.init(ts);
        KeyManager[] keyManagers = null;
        if (useKeystore) {
            FileInputStream ksf = new FileInputStream(keystorePath);
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(ksf, keystorePassword.toCharArray());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            kmf.init(ks, keystorePassword.toCharArray());
            keyManagers = kmf.getKeyManagers();
        }
        ctx.init(keyManagers, tmf.getTrustManagers(), new SecureRandom());
        return ctx;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Compression getCompression() {
        return this.compression;
    }

    public void setCompression(Compression compression) {
        this.compression = compression;
    }

    public boolean isRequiresCredentials() {
        return this.requiresCredentials;
    }

    public void setRequiresCredentials(boolean requiresCredentials) {
        this.requiresCredentials = requiresCredentials;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public boolean isStorePassword() {
        return this.storePassword;
    }

    public void setStorePassword(boolean storePassword) {
        this.storePassword = storePassword;
    }

    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public String getPassword() {
        return this.encrypter.decrypt(this.encryptedPassword);
    }

    public void setPassword(String password) {
        this.encryptedPassword = this.encrypter.encrypt(password);
    }

    public byte[] getEncryptedPassword() {
        return this.encryptedPassword;
    }

    public void setEncryptedPassword(byte[] encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
    }

    public String getTruststoreFile() {
        return this.truststorePath;
    }

    public void setTruststoreFile(String path) {
        this.truststorePath = path;
    }

    public String getTruststorePassword() {
        return this.encrypter.decrypt(this.encryptedTruststorePassword);
    }

    public void setTruststorePassword(String password) {
        this.encryptedTruststorePassword = this.encrypter.encrypt(password);
    }

    public byte[] getEncryptedTruststorePassword() {
        return this.encryptedTruststorePassword;
    }

    public void setEncryptedTruststorePassword(byte[] password) {
        this.encryptedTruststorePassword = password;
    }

    public boolean isRequiresClientAuthentication() {
        return this.requiresClientAuthentication;
    }

    public void setRequiresClientAuthentication(boolean keystoreEnabled) {
        this.requiresClientAuthentication = keystoreEnabled;
    }

    public String getKeystoreFile() {
        return this.keystorePath;
    }

    public void setKeystoreFile(String path) {
        this.keystorePath = path;
    }

    public String getKeystorePassword() {
        return this.encrypter.decrypt(this.encryptedKeystorePassword);
    }

    public void setKeystorePassword(String password) {
        this.encryptedKeystorePassword = this.encrypter.encrypt(password);
    }

    public byte[] getEncryptedKeystorePassword() {
        return this.encryptedKeystorePassword;
    }

    public void setEncryptedKeystorePassword(byte[] password) {
        this.encryptedKeystorePassword = password;
    }

    public List<String> getHosts() {
        return this.hosts;
    }

    public void setHosts(List<String> hosts) {
        this.hosts = hosts;
    }

    public String toString() {
        return "Connection [name=" + this.name + "]";
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener() {
        this.listeners.remove(this.listeners);
    }

    public synchronized void fireConnectionChanged() {
        for (Listener listener : this.listeners) {
            listener.connectionChanged();
        }
        ConnectionList.getInstance().fireConnectionsListChanged();
    }

    private class DriverListener
    implements Host.StateListener,
    SchemaChangeListener {
        private DriverListener() {
        }

        public void onAdd(Host host) {
            Connection.this.fireConnectionChanged();
        }

        public void onRemove(Host host) {
            Connection.this.fireConnectionChanged();
        }

        public void onUp(Host host) {
            Connection.this.fireConnectionChanged();
        }

        public void onDown(Host host) {
            Connection.this.fireConnectionChanged();
        }

        public void onRegister(Cluster arg0) {
            Connection.this.fireConnectionChanged();
        }

        public void onUnregister(Cluster arg0) {
            Connection.this.fireConnectionChanged();
        }

        public void onKeyspaceCreated(String keyspace) {
            Connection.this.fireConnectionChanged();
        }

        public void onKeyspaceDropped(String keyspace) {
            Connection.this.fireConnectionChanged();
        }

        public void onKeyspaceUpdated(String keyspace) {
            Connection.this.fireConnectionChanged();
        }

        public void onTableCreated(String keyspace, String table) {
            Connection.this.fireConnectionChanged();
        }

        public void onTableDropped(String keyspace, String table) {
            Connection.this.fireConnectionChanged();
        }

        public void onTableUpdated(String keyspace, String table) {
            Connection.this.fireConnectionChanged();
        }

        public void onUdtCreated(String keyspace, String udt) {
            Connection.this.fireConnectionChanged();
        }

        public void onUdtDropped(String keyspace, String udt) {
            Connection.this.fireConnectionChanged();
        }

        public void onUdtUpdated(String keyspace, String udt) {
            Connection.this.fireConnectionChanged();
        }

        public void onAggregateCreated(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }

        public void onAggregateDropped(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }

        public void onAggregateUpdated(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }

        public void onFunctionCreated(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }

        public void onFunctionDropped(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }

        public void onFunctionUpdated(String arg0, String arg1, List<String> arg2) {
            Connection.this.fireConnectionChanged();
        }
    }

    public static abstract class Listener {
        public void connectionOpened() {
        }

        public void connectionClosed() {
        }

        public void connectionChanged() {
        }

        public void connectionRemoved() {
        }
    }
}

