/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.models;

import com.datastax.devcenter.common.metrics.Metrics;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.util.ConnectionNameUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;

@XmlRootElement
public class ConnectionList {
    private static final ConnectionList instance = new ConnectionList();
    @XmlElement
    private final List<Connection> connections = new ArrayList<Connection>();
    @XmlTransient
    private final List<Listener> listeners = Collections.synchronizedList(new ArrayList());

    public ConnectionList() {
        this.listeners.add(new Listener(){

            @Override
            public void connectionListUpdated() {
                Collections.sort(ConnectionList.this.connections, ConnectionNameUtils.connectionNameComparator());
                Metrics.setGaugeValue((String)"connection_count", (int)ConnectionList.this.connections.size());
            }
        });
    }

    public List<Connection> getConnections() {
        return this.connections;
    }

    public void addConnection(Connection connection) {
        this.connections.add(connection);
        this.fireConnectionsListChanged();
    }

    public void removeConnection(Connection connection) {
        this.connections.remove(connection);
        this.fireConnectionsListChanged();
    }

    public static ConnectionList getInstance() {
        return instance;
    }

    public void addListener(Listener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(Listener listener) {
        this.listeners.remove(listener);
    }

    public void fireConnectionsListChanged() {
        for (Listener listener : this.listeners) {
            listener.connectionListUpdated();
        }
    }

    public static interface Listener {
        public void connectionListUpdated();
    }
}

