/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.handlers;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.handlers.HandlerUtil;

public class DeleteConnectionHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        boolean delete;
        IStructuredSelection activeMenuSelection = (IStructuredSelection)HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (activeMenuSelection.size() == 1) {
            Connection connection = (Connection)activeMenuSelection.getFirstElement();
            delete = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Connection", (String)("Are you sure you want to delete connection " + connection.getName() + "?"));
        } else {
            delete = MessageDialog.openQuestion((Shell)Display.getCurrent().getActiveShell(), (String)"Delete Connection", (String)"Are you sure you want to delete the selected connections?");
        }
        if (delete) {
            for (Connection connection : activeMenuSelection) {
                ConnectionList.getInstance().removeConnection(connection);
            }
        }
        return null;
    }
}

