/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.handlers;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.jobs.OpenConnectionWorkspaceJob;
import com.datastax.devcenter.connections.ui.properties.ConnectionBasicSettingsPropertyPage;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class EditConnectionHandler
extends AbstractHandler {
    private static final String INITIAL_PAGE_ID = ConnectionBasicSettingsPropertyPage.class.getName();

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection currentSelection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (currentSelection instanceof IStructuredSelection) {
            Shell shell;
            PreferenceDialog dialog;
            Connection connection = (Connection)((IStructuredSelection)currentSelection).getFirstElement();
            Connection backup = connection.clone();
            IWorkbenchWindow activeWorkbenchWindow = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
            if (activeWorkbenchWindow != null && (dialog = PreferencesUtil.createPropertyDialogOn((Shell)(shell = activeWorkbenchWindow.getShell()), (IAdaptable)connection, (String)INITIAL_PAGE_ID, null, null)) != null) {
                if (dialog.open() == 0) {
                    if (connection.isOpen()) {
                        connection.close();
                        new OpenConnectionWorkspaceJob(connection).schedule();
                    } else {
                        connection.fireConnectionChanged();
                    }
                } else {
                    connection.replace(backup);
                }
            }
        }
        return null;
    }
}

