/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.jobs;

import com.datastax.devcenter.common.utils.AsyncJobHelper;
import com.datastax.driver.core.exceptions.AuthenticationException;
import com.datastax.driver.core.exceptions.NoHostAvailableException;
import com.datastax.driver.core.exceptions.UnauthorizedException;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class ConnectionJobHelper
extends AsyncJobHelper {
    public ConnectionJobHelper() {
        super(new AsyncJobHelper.ExceptionTranslator[]{new NoHostAvailableExceptionTranslator(), new AsyncJobHelper.SimpleExceptionTranslator(AuthenticationException.class, "Invalid credentials supplied."), new AsyncJobHelper.SimpleExceptionTranslator(UnauthorizedException.class, "Not enough privileges."), new AsyncJobHelper.SimpleExceptionTranslator(IllegalArgumentException.class, "Invalid connection settings.")});
    }

    private static final class NoHostAvailableExceptionTranslator
    implements AsyncJobHelper.ExceptionTranslator {
        private NoHostAvailableExceptionTranslator() {
        }

        public boolean canTranslate(Throwable throwable) {
            return throwable instanceof NoHostAvailableException;
        }

        public IStatus translate(Throwable throwable) {
            NoHostAvailableException nhae = (NoHostAvailableException)throwable;
            Map errors = nhae.getErrors();
            MultiStatus status = new MultiStatus("com.datastax.devcenter.connections", 1, "The specified host(s) could not be reached.", (Throwable)nhae);
            for (Map.Entry entry : errors.entrySet()) {
                Status subStatus = new Status(4, "com.datastax.devcenter.connections", ((Throwable)entry.getValue()).getMessage(), null);
                status.add((IStatus)subStatus);
            }
            return status;
        }
    }
}

