/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.views;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionsViewContentProvider;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionsViewStyledCellLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;

public class ConnectionsTreeViewPart
extends ViewPart
implements ConnectionList.Listener {
    public static final String ID = "com.datastax.devcenter.connections.ui.views.ConnectionsTreeViewPart";
    private static final String CONNECTIONS_CONTEXT_ID = "com.datastax.devcenter.connections.ui.views";
    private static final String OPEN_CONNECTION_COMMAND_ID = "com.datastax.devcenter.connections.ui.commands.OpenConnection";
    private TreeViewer treeViewer;

    public void createPartControl(Composite parentComposite) {
        this.activateConnectionsContext();
        this.createTreeViewer(parentComposite);
        this.hookContextMenu();
        ConnectionList.getInstance().addListener(this);
    }

    public void dispose() {
        ConnectionList.getInstance().removeListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    @Override
    public void connectionListUpdated() {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (ConnectionsTreeViewPart.this.treeViewer != null && !ConnectionsTreeViewPart.this.treeViewer.getTree().isDisposed()) {
                    ConnectionsTreeViewPart.this.treeViewer.refresh(true);
                    ConnectionsTreeViewPart.this.getViewSite().getActionBars().updateActionBars();
                }
            }
        });
    }

    private void activateConnectionsContext() {
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        service.activateContext(CONNECTIONS_CONTEXT_ID);
    }

    private void createTreeViewer(Composite parentComposite) {
        this.treeViewer = new TreeViewer(parentComposite, 514);
        this.treeViewer.setContentProvider((IContentProvider)new ConnectionsViewContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new ConnectionsViewStyledCellLabelProvider());
        this.treeViewer.setInput((Object)ConnectionList.getInstance());
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                IHandlerService handlerService = (IHandlerService)ConnectionsTreeViewPart.this.getSite().getService(IHandlerService.class);
                try {
                    handlerService.executeCommand(ConnectionsTreeViewPart.OPEN_CONNECTION_COMMAND_ID, null);
                }
                catch (Exception e) {
                    DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)this.getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
                }
                ConnectionsTreeViewPart.this.treeViewer.refresh();
            }
        });
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }
}

