/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.views.providers;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.connections.ConnectionsActivator;
import com.datastax.devcenter.connections.models.Connection;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;

public class ConnectionsViewStyledCellLabelProvider
extends StyledCellLabelProvider {
    private final StyledString.Styler suffixStyler = new StyledString.Styler(){

        public void applyStyles(TextStyle textstyle) {
            textstyle.foreground = Display.getCurrent().getSystemColor(15);
        }
    };
    private final Image connected;
    private final Image disconnected;
    private final Image connectedWarning;
    private final Image connectedError;

    public ConnectionsViewStyledCellLabelProvider() {
        Image connected = null;
        try {
            connected = IconUtility.getImageDescriptor((Plugin)ConnectionsActivator.getDefault(), (String)"icons/conn_connect.gif").createImage();
        }
        catch (Exception e) {
            DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)"ConnectionsViewStyledCellLabelProvider", (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
        this.connected = connected;
        Image disconnected = null;
        try {
            disconnected = IconUtility.getImageDescriptor((Plugin)ConnectionsActivator.getDefault(), (String)"icons/conn_disconnect.gif").createImage();
        }
        catch (Exception e) {
            DevCenterLogger.error((Throwable)e, (String)e.toString(), (String)"ConnectionsViewStyledCellLabelProvider", (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
        this.disconnected = disconnected;
        ImageDescriptor warning = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_WARNING");
        ImageDescriptor error = PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_DEC_FIELD_ERROR");
        this.connectedWarning = new DecorationOverlayIcon(connected, warning, 0).createImage();
        this.connectedError = new DecorationOverlayIcon(connected, error, 0).createImage();
    }

    public void update(ViewerCell viewerCell) {
        Object element = viewerCell.getElement();
        if (!(element instanceof Connection)) {
            return;
        }
        Connection connection = (Connection)element;
        String text = connection.getName();
        StyledString labelStyledString = new StyledString();
        labelStyledString.append(text);
        if (connection.isOpen()) {
            int sizeConnected = connection.getConnectedHosts().size();
            int sizeDeclared = connection.getHosts().size();
            labelStyledString.append(String.format(" [%s/%s Connected]", sizeConnected, sizeDeclared), this.suffixStyler);
            if (sizeConnected == sizeDeclared) {
                viewerCell.setImage(this.connected);
            } else if (sizeConnected == 0) {
                viewerCell.setImage(this.connectedError);
            } else {
                viewerCell.setImage(this.connectedWarning);
            }
        } else {
            viewerCell.setImage(this.disconnected);
        }
        viewerCell.setText(labelStyledString.toString());
        viewerCell.setStyleRanges(labelStyledString.getStyleRanges());
        super.update(viewerCell);
    }
}

