/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.jobs.CheckConnectionJob;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.databinding.AggregateValidationStatus;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.IObservableCollection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractConnectionWizardPage
extends WizardPage {
    protected final Connection connection;
    protected Link testLink;
    private AggregateValidationStatus globalValidationStatus;

    public AbstractConnectionWizardPage(String pageName, String title, ImageDescriptor image, Connection connection) {
        super(pageName, title, image);
        this.connection = connection;
    }

    public void dispose() {
        if (this.globalValidationStatus != null) {
            this.globalValidationStatus.dispose();
        }
        super.dispose();
    }

    protected void bindTestLink(DataBindingContext ctx) {
        this.globalValidationStatus = new AggregateValidationStatus((IObservableCollection)ctx.getValidationStatusProviders(), 2);
        this.globalValidationStatus.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                IStatus status = (IStatus)AbstractConnectionWizardPage.this.globalValidationStatus.getValue();
                AbstractConnectionWizardPage.this.testLink.setEnabled(status.isOK());
            }
        });
    }

    protected void checkConnection() {
        CheckConnectionJob check = new CheckConnectionJob(this.connection);
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)check);
        }
        catch (InvocationTargetException invocationTargetException) {
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
        }
        if (check.getStatus().isOK()) {
            MessageDialog.openInformation((Shell)this.getContainer().getShell(), (String)"Test Connection", (String)"Connection successful.");
        } else if (check.getStatus().getSeverity() == 4) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)"Test Connection", (String)"Unable to establish connection.", (IStatus)check.getStatus());
        }
    }
}

