/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.wizard.AbstractConnectionWizardPage;
import com.datastax.devcenter.connections.ui.wizard.filters.BlankSpaceTextFilter;
import com.datastax.devcenter.connections.ui.wizard.filters.NewLineTextFilter;
import com.datastax.devcenter.connections.ui.wizard.validators.KeystoreFileValidator;
import com.datastax.devcenter.connections.ui.wizard.validators.KeystorePasswordValidator;
import com.datastax.devcenter.connections.ui.wizard.validators.ValidationMessages;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConnectionAdvancedSettingsWizardPage
extends AbstractConnectionWizardPage {
    private Button requiresCredentialButton;
    private Group credentialsGroup;
    private Label loginNameLabel;
    private Text loginText;
    private Label passwordNameLabel;
    private Text passwordText;
    private Button enableSslButton;
    private Group sslGroup;
    private Label truststoreFileNameLabel;
    private Text truststoreFileText;
    private Button truststoreFileButton;
    private Label truststorePasswordLabel;
    private Text truststorePasswordText;
    private Button enableKeystoreButton;
    private Group keystoreGroup;
    private Label keystoreFileNameLabel;
    private Text keystoreFileText;
    private Button keystoreFileButton;
    private Label keystorePasswordLabel;
    private Text keystorePasswordText;

    public ConnectionAdvancedSettingsWizardPage(Connection connection, ImageDescriptor image) {
        super("Advanced Settings", "Advanced Settings", image, connection);
        this.setDescription("Enter security information, if required by this cluster.");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout());
        this.addCredentialsButton(container);
        this.addCredentialsGroup(container);
        this.addEmptyLine(container, 1);
        this.addEnableSSLButton(container);
        this.addSslGroup(container);
        this.addTestLink(container);
        this.setControl((Control)container);
        this.setPageComplete(false);
        DataBindingContext ctx = new DataBindingContext();
        this.bindRequiresCredentials(ctx);
        this.bindLogin(ctx);
        this.bindPassword(ctx);
        this.bindEnableSSL(ctx);
        this.bindTruststoreFile(ctx);
        this.bindTruststorePassword(ctx);
        this.bindEnableKeystore(ctx);
        this.bindKeystoreFile(ctx);
        this.bindKeystorePassword(ctx);
        this.bindTestLink(ctx);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)ctx);
        this.updateWidgetsState();
    }

    private void addCredentialsGroup(Composite container) {
        this.credentialsGroup = new Group(container, 16);
        GridData data = new GridData(4, 0x1000000, true, false);
        this.credentialsGroup.setLayoutData((Object)data);
        this.credentialsGroup.setLayout((Layout)new GridLayout(3, false));
        this.addLoginName((Composite)this.credentialsGroup);
        this.addLoginPassword((Composite)this.credentialsGroup);
    }

    private void addSslGroup(Composite container) {
        this.sslGroup = new Group(container, 16);
        this.sslGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.sslGroup.setLayout((Layout)new GridLayout(3, false));
        this.setupTruststore((Composite)this.sslGroup);
        this.addEmptyLine((Composite)this.sslGroup, 4);
        this.addEnableKeystoreButton((Composite)this.sslGroup);
        this.addKeystoreGroup((Composite)this.sslGroup);
    }

    private void addKeystoreGroup(Composite container) {
        this.keystoreGroup = new Group(container, 16);
        this.keystoreGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 3, 1));
        this.keystoreGroup.setLayout((Layout)new GridLayout(3, false));
        this.setupKeystore((Composite)this.keystoreGroup);
    }

    private void addCredentialsButton(Composite container) {
        this.requiresCredentialButton = new Button(container, 32);
        this.requiresCredentialButton.setText("This cluster requires credentials");
        this.requiresCredentialButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.requiresCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAdvancedSettingsWizardPage.this.updateWidgetsState();
            }
        });
    }

    private void addLoginName(Composite container) {
        this.loginNameLabel = new Label(container, 0);
        this.loginNameLabel.setText("Login: ");
        this.loginNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.loginText = new Text(container, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.loginText.setLayoutData((Object)data);
        this.loginText.addModifyListener((ModifyListener)new BlankSpaceTextFilter());
        this.addEmptyCell(container);
    }

    private void addLoginPassword(Composite container) {
        this.passwordNameLabel = new Label(container, 0);
        this.passwordNameLabel.setText("Password: ");
        this.passwordNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.passwordText = new Text(container, 0x400800);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.passwordText.setLayoutData((Object)data);
        this.passwordText.addModifyListener((ModifyListener)new NewLineTextFilter());
        this.addEmptyCell(container);
    }

    private void addEnableSSLButton(Composite container) {
        this.enableSslButton = new Button(container, 32);
        this.enableSslButton.setText("This cluster requires SSL");
        this.enableSslButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.enableSslButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAdvancedSettingsWizardPage.this.updateWidgetsState();
            }
        });
    }

    private void setupTruststore(Composite container) {
        this.truststoreFileNameLabel = new Label(container, 0);
        this.truststoreFileNameLabel.setText("Truststore file: ");
        this.truststoreFileNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.truststoreFileText = new Text(container, 2048);
        GridData truststoreFileTextGridData = new GridData(4, 0x1000000, true, false);
        truststoreFileTextGridData.horizontalIndent = 10;
        truststoreFileTextGridData.widthHint = 200;
        this.truststoreFileText.setLayoutData((Object)truststoreFileTextGridData);
        this.truststoreFileButton = new Button(container, 0);
        this.truststoreFileButton.setText("...");
        this.truststoreFileButton.setToolTipText("Browse to select the truststore file");
        this.truststoreFileButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.truststorePasswordLabel = new Label(container, 0);
        this.truststorePasswordLabel.setText("Truststore password: ");
        this.truststorePasswordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.truststorePasswordText = new Text(container, 0x400800);
        GridData truststorePasswordTextGridData = new GridData(4, 0x1000000, true, false);
        truststorePasswordTextGridData.horizontalIndent = 10;
        this.truststorePasswordText.setLayoutData((Object)truststorePasswordTextGridData);
        this.truststorePasswordText.addModifyListener((ModifyListener)new NewLineTextFilter());
        this.addEmptyCell(container);
        this.setupFileDialog(this.truststoreFileButton, this.truststoreFileText);
    }

    private void addEnableKeystoreButton(Composite container) {
        this.enableKeystoreButton = new Button(container, 32);
        this.enableKeystoreButton.setText("Client authentication required");
        this.enableKeystoreButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
        this.enableKeystoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConnectionAdvancedSettingsWizardPage.this.updateWidgetsState();
            }
        });
    }

    private void setupKeystore(Composite container) {
        this.keystoreFileNameLabel = new Label(container, 0);
        this.keystoreFileNameLabel.setText("Keystore file: ");
        this.keystoreFileNameLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.keystoreFileText = new Text(container, 2048);
        GridData keystoreFileTextGridData = new GridData(4, 0x1000000, true, false);
        keystoreFileTextGridData.horizontalIndent = 10;
        keystoreFileTextGridData.widthHint = 200;
        this.keystoreFileText.setLayoutData((Object)keystoreFileTextGridData);
        this.keystoreFileButton = new Button(container, 0);
        this.keystoreFileButton.setText("...");
        this.keystoreFileButton.setToolTipText("Browse to select the keystore file");
        this.keystoreFileButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.keystorePasswordLabel = new Label(container, 0);
        this.keystorePasswordLabel.setText("Keystore password: ");
        this.keystorePasswordLabel.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.keystorePasswordText = new Text(container, 0x400800);
        GridData keystorePasswordTextGridData = new GridData(4, 0x1000000, true, false);
        keystorePasswordTextGridData.horizontalIndent = 10;
        this.keystorePasswordText.setLayoutData((Object)keystorePasswordTextGridData);
        this.keystorePasswordText.addModifyListener((ModifyListener)new NewLineTextFilter());
        this.addEmptyCell(container);
        this.setupFileDialog(this.keystoreFileButton, this.keystoreFileText);
    }

    private void addTestLink(Composite container) {
        this.testLink = new Link(container, 0);
        this.testLink.setText("<a>Try to establish a connection</a> using these settings.");
        this.testLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.testLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionAdvancedSettingsWizardPage.this.checkConnection();
            }
        });
    }

    private void addEmptyLine(Composite container, int horizontalSpan) {
        Label empty = new Label(container, 0);
        empty.setLayoutData((Object)new GridData(4, 0x1000000, false, false, horizontalSpan, 1));
    }

    private void addEmptyCell(Composite container) {
        Button empty = new Button(container, 0);
        empty.setVisible(false);
        empty.setEnabled(false);
        empty.setLayoutData((Object)new GridData(0, -1));
    }

    private void updateWidgetsState() {
        boolean requiresCredential = this.isCredentialsRequired();
        boolean sslRequired = this.isSslRequired();
        boolean clientAuthenticationRequired = this.isClientAuthenticationRequired();
        this.credentialsGroup.setEnabled(requiresCredential);
        this.loginNameLabel.setEnabled(requiresCredential);
        this.loginText.setEnabled(requiresCredential);
        this.passwordNameLabel.setEnabled(requiresCredential);
        this.passwordText.setEnabled(requiresCredential);
        this.sslGroup.setEnabled(sslRequired);
        this.truststoreFileNameLabel.setEnabled(sslRequired);
        this.truststoreFileText.setEnabled(sslRequired);
        this.truststoreFileButton.setEnabled(sslRequired);
        this.truststorePasswordLabel.setEnabled(sslRequired);
        this.truststorePasswordText.setEnabled(sslRequired);
        this.enableKeystoreButton.setEnabled(sslRequired);
        this.keystoreGroup.setEnabled(sslRequired && clientAuthenticationRequired);
        this.keystoreFileNameLabel.setEnabled(sslRequired && clientAuthenticationRequired);
        this.keystoreFileText.setEnabled(sslRequired && clientAuthenticationRequired);
        this.keystoreFileButton.setEnabled(sslRequired && clientAuthenticationRequired);
        this.keystorePasswordLabel.setEnabled(sslRequired && clientAuthenticationRequired);
        this.keystorePasswordText.setEnabled(sslRequired && clientAuthenticationRequired);
    }

    private void setupFileDialog(final Button button, final Text textField) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dlg = new FileDialog(button.getShell(), 4096);
                dlg.setText("Open");
                String path = dlg.open();
                if (path == null) {
                    return;
                }
                textField.setText(path);
            }
        });
    }

    private void bindRequiresCredentials(DataBindingContext ctx) {
        ISWTObservableValue target = SWTObservables.observeSelection((Control)this.requiresCredentialButton);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"requiresCredentials");
        ctx.bindValue((IObservableValue)target, model);
    }

    private void bindLogin(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.loginText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"login");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                if (ConnectionAdvancedSettingsWizardPage.this.isCredentialsRequired() && ConnectionAdvancedSettingsWizardPage.this.loginText.getText().isEmpty()) {
                    return ValidationStatus.error((String)"Login cannot be empty");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.requiresCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindPassword(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.passwordText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"password");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                if (ConnectionAdvancedSettingsWizardPage.this.isCredentialsRequired() && ConnectionAdvancedSettingsWizardPage.this.passwordText.getText().isEmpty()) {
                    return ValidationStatus.error((String)"Password cannot be empty");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.requiresCredentialButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindEnableSSL(DataBindingContext ctx) {
        ISWTObservableValue target = SWTObservables.observeSelection((Control)this.enableSslButton);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"ssl");
        ctx.bindValue((IObservableValue)target, model);
    }

    private void bindTruststoreFile(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.truststoreFileText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"truststoreFile");
        KeystoreFileValidator validator = new KeystoreFileValidator(this.truststoreFileText, this.truststorePasswordText){

            @Override
            protected boolean isEnabled() {
                return ConnectionAdvancedSettingsWizardPage.this.isSslRequired();
            }

            @Override
            protected String getKeystoreType() {
                return ValidationMessages.KeystoreType_Truststore;
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.enableSslButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindTruststorePassword(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.truststorePasswordText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"truststorePassword");
        KeystorePasswordValidator validator = new KeystorePasswordValidator(this.truststoreFileText, this.truststorePasswordText){

            @Override
            protected boolean isEnabled() {
                return ConnectionAdvancedSettingsWizardPage.this.isSslRequired();
            }

            @Override
            protected String getKeystoreType() {
                return ValidationMessages.KeystoreType_Truststore;
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.enableSslButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        this.truststoreFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindEnableKeystore(DataBindingContext ctx) {
        ISWTObservableValue target = SWTObservables.observeSelection((Control)this.enableKeystoreButton);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"requiresClientAuthentication");
        ctx.bindValue((IObservableValue)target, model);
    }

    private void bindKeystoreFile(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.keystoreFileText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"keystoreFile");
        KeystoreFileValidator validator = new KeystoreFileValidator(this.keystoreFileText, this.keystorePasswordText){

            @Override
            protected boolean isEnabled() {
                return ConnectionAdvancedSettingsWizardPage.this.isSslRequired() && ConnectionAdvancedSettingsWizardPage.this.isClientAuthenticationRequired();
            }

            @Override
            protected String getKeystoreType() {
                return ValidationMessages.KeystoreType_Keystore;
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.enableSslButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        this.enableKeystoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindKeystorePassword(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.keystorePasswordText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"keystorePassword");
        KeystorePasswordValidator validator = new KeystorePasswordValidator(this.keystoreFileText, this.keystorePasswordText){

            @Override
            protected boolean isEnabled() {
                return ConnectionAdvancedSettingsWizardPage.this.isSslRequired() && ConnectionAdvancedSettingsWizardPage.this.isClientAuthenticationRequired();
            }

            @Override
            protected String getKeystoreType() {
                return ValidationMessages.KeystoreType_Keystore;
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator((IValidator)validator);
        final Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        this.enableSslButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        this.enableKeystoreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        this.keystoreFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                bindValue.updateTargetToModel();
            }
        });
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private boolean isCredentialsRequired() {
        return this.requiresCredentialButton.getSelection();
    }

    private boolean isSslRequired() {
        return this.enableSslButton.getSelection();
    }

    private boolean isClientAuthenticationRequired() {
        return this.enableKeystoreButton.getSelection();
    }
}

