/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard;

import com.datastax.devcenter.connections.models.Compression;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.ui.wizard.AbstractConnectionWizardPage;
import com.datastax.devcenter.connections.ui.wizard.validators.HostListValidator;
import com.datastax.devcenter.connections.util.ConnectionNameUtils;
import com.ibm.icu.text.NumberFormat;
import org.apache.commons.lang.ArrayUtils;
import org.eclipse.core.databinding.Binding;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.UpdateValueStrategy;
import org.eclipse.core.databinding.ValidationStatusProvider;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.core.databinding.conversion.NumberToStringConverter;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.SelectObservableValue;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.databinding.fieldassist.ControlDecorationSupport;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.wizard.WizardPageSupport;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class ConnectionBasicSettingsWizardPage
extends AbstractConnectionWizardPage {
    private Text connectionNameText;
    private Text hostText;
    private Text portText;
    private Button addButton;
    private Button removeButton;
    private List hostList;
    private Button noCompressionRadioButton;
    private Button snappyCompressionRadioButton;
    private Button lz4CompressionRadioButton;
    private HostListValidator hostListValidator;
    private final String oldName;

    public ConnectionBasicSettingsWizardPage(Connection connection, ImageDescriptor image) {
        super("Basic Settings", "Basic Settings", image, connection);
        this.setDescription("Enter information about the cluster to connect to.");
        this.oldName = connection.getName();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayout((Layout)new GridLayout(3, false));
        this.addConnectionName(container);
        this.addAddHost(container);
        this.addHostsList(container);
        this.addConnectionPort(container);
        this.addCompression(container);
        this.addTestLink(container);
        this.createEventListeners();
        DataBindingContext ctx = new DataBindingContext();
        this.bindConnectionName(ctx);
        this.bindPort(ctx);
        this.bindHosts(ctx);
        this.bindCompression(ctx);
        this.bindTestLink(ctx);
        this.setControl((Control)container);
        this.setPageComplete(false);
        WizardPageSupport.create((WizardPage)this, (DataBindingContext)ctx);
    }

    private void addConnectionName(Composite container) {
        new Label(container, 0).setText("Connection name:");
        this.connectionNameText = new Text(container, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.connectionNameText.setLayoutData((Object)data);
        this.addEmptyCell(container);
    }

    private void addAddHost(Composite container) {
        new Label(container, 0).setText("Contact hosts:");
        this.hostText = new Text(container, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.hostText.setLayoutData((Object)data);
        this.addButton = new Button(container, 8);
        this.addButton.setText("Add");
        this.addButton.setEnabled(false);
        this.addButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
    }

    private void addHostsList(Composite container) {
        this.addEmptyCell(container);
        this.hostList = new List(container, 2562);
        GridData data = new GridData(4, 4, true, true);
        data.horizontalIndent = 10;
        this.hostList.setLayoutData((Object)data);
        this.removeButton = new Button(container, 8);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        this.removeButton.setLayoutData((Object)new GridData(4, 128, false, false));
    }

    private void addConnectionPort(Composite container) {
        new Label(container, 0).setText("Native Protocol port:");
        this.portText = new Text(container, 2048);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        this.portText.setLayoutData((Object)data);
        this.addEmptyCell(container);
    }

    private void addCompression(Composite container) {
        new Label(container, 0).setText("Use compression:");
        Composite radioGroup = new Composite(container, 0);
        GridData data = new GridData(4, 0x1000000, true, false);
        data.horizontalIndent = 10;
        radioGroup.setLayoutData((Object)data);
        radioGroup.setLayout((Layout)new GridLayout(3, true));
        this.noCompressionRadioButton = new Button(radioGroup, 16);
        this.noCompressionRadioButton.setText("None");
        this.noCompressionRadioButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.snappyCompressionRadioButton = new Button(radioGroup, 16);
        this.snappyCompressionRadioButton.setText("Snappy");
        this.snappyCompressionRadioButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lz4CompressionRadioButton = new Button(radioGroup, 16);
        this.lz4CompressionRadioButton.setText("LZ4");
        this.lz4CompressionRadioButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.addEmptyCell(container);
    }

    private void addTestLink(Composite container) {
        this.testLink = new Link(container, 0);
        this.testLink.setText("<a>Try to establish a connection</a> using these settings.");
        this.testLink.setEnabled(!this.connection.getHosts().isEmpty());
        this.testLink.setLayoutData((Object)new GridData(4, 0x1000000, false, false, 3, 1));
    }

    private void addEmptyCell(Composite container) {
        new Label(container, 0);
    }

    private void createEventListeners() {
        this.hostText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ConnectionBasicSettingsWizardPage.this.addButton.setEnabled(!ConnectionBasicSettingsWizardPage.this.hostText.getText().isEmpty());
            }
        });
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String ip = ConnectionBasicSettingsWizardPage.this.hostText.getText();
                if (!ArrayUtils.contains((Object[])ConnectionBasicSettingsWizardPage.this.hostList.getItems(), (Object)ip)) {
                    ConnectionBasicSettingsWizardPage.this.hostList.add(ip);
                    ConnectionBasicSettingsWizardPage.this.connection.getHosts().add(ip);
                }
                ConnectionBasicSettingsWizardPage.this.testLink.setEnabled(ConnectionBasicSettingsWizardPage.this.hostList.getItemCount() > 0);
                ConnectionBasicSettingsWizardPage.this.hostList.redraw();
                ConnectionBasicSettingsWizardPage.this.hostText.setText("");
                ConnectionBasicSettingsWizardPage.this.hostListValidator.forceRevalidate();
            }
        });
        this.hostList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionBasicSettingsWizardPage.this.removeButton.setEnabled(ConnectionBasicSettingsWizardPage.this.hostList.getSelectionCount() > 0);
            }
        });
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionBasicSettingsWizardPage.this.hostList.remove(ConnectionBasicSettingsWizardPage.this.hostList.getSelectionIndices());
                ConnectionBasicSettingsWizardPage.this.connection.getHosts().clear();
                String[] stringArray = ConnectionBasicSettingsWizardPage.this.hostList.getItems();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String ip = stringArray[n2];
                    ConnectionBasicSettingsWizardPage.this.connection.getHosts().add(ip);
                    ++n2;
                }
                ConnectionBasicSettingsWizardPage.this.hostList.redraw();
                ConnectionBasicSettingsWizardPage.this.removeButton.setEnabled(false);
                ConnectionBasicSettingsWizardPage.this.hostListValidator.forceRevalidate();
            }
        });
        this.testLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ConnectionBasicSettingsWizardPage.this.checkConnection();
            }
        });
    }

    private void bindConnectionName(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.connectionNameText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"name");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                if (value == null || value.toString().isEmpty()) {
                    return ValidationStatus.error((String)"Connection name cannot be empty");
                }
                if (ConnectionNameUtils.nameExists(value.toString()) && !value.equals(ConnectionBasicSettingsWizardPage.this.oldName)) {
                    return ValidationStatus.error((String)"Connection name already exists");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy strategy = new UpdateValueStrategy();
        strategy.setBeforeSetValidator(validator);
        Binding bindValue = ctx.bindValue((IObservableValue)target, model, strategy, null);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindPort(DataBindingContext ctx) {
        ISWTObservableValue target = WidgetProperties.text((int)24).observe((Widget)this.portText);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"port");
        IValidator validator = new IValidator(){

            public IStatus validate(Object value) {
                int port;
                if (value == null || value.toString().isEmpty()) {
                    return ValidationStatus.error((String)"Native Protocol port cannot be empty");
                }
                try {
                    port = Integer.parseInt(value.toString());
                }
                catch (NumberFormatException numberFormatException) {
                    return ValidationStatus.error((String)"Native Protocol port must be an integer");
                }
                if (port < 1 || port > 65535) {
                    return ValidationStatus.error((String)"Native Protocol port must be comprised between 1 and 65535");
                }
                return ValidationStatus.ok();
            }
        };
        UpdateValueStrategy targetToModelStrategy = new UpdateValueStrategy();
        targetToModelStrategy.setAfterGetValidator(validator);
        NumberFormat numberFormat = NumberFormat.getIntegerInstance();
        numberFormat.setGroupingUsed(false);
        UpdateValueStrategy modelToTargetStrategy = new UpdateValueStrategy();
        modelToTargetStrategy.setConverter((IConverter)NumberToStringConverter.fromInteger((NumberFormat)numberFormat, (boolean)false));
        Binding bindValue = ctx.bindValue((IObservableValue)target, model, targetToModelStrategy, modelToTargetStrategy);
        ControlDecorationSupport.create((ValidationStatusProvider)bindValue, (int)16512);
    }

    private void bindHosts(DataBindingContext ctx) {
        IObservableList target = SWTObservables.observeItems((Control)this.hostList);
        IObservableList model = PojoObservables.observeList((Object)this.connection, (String)"hosts");
        this.hostListValidator = new HostListValidator(target);
        ctx.bindList(target, model);
        ctx.addValidationStatusProvider((ValidationStatusProvider)this.hostListValidator);
        ControlDecorationSupport.create((ValidationStatusProvider)this.hostListValidator, (int)16512);
    }

    private void bindCompression(DataBindingContext ctx) {
        ISWTObservableValue none = SWTObservables.observeSelection((Control)this.noCompressionRadioButton);
        ISWTObservableValue snappy = SWTObservables.observeSelection((Control)this.snappyCompressionRadioButton);
        ISWTObservableValue lz4 = SWTObservables.observeSelection((Control)this.lz4CompressionRadioButton);
        SelectObservableValue target = new SelectObservableValue(Compression.class);
        target.addOption((Object)Compression.NONE, (IObservableValue)none);
        target.addOption((Object)Compression.SNAPPY, (IObservableValue)snappy);
        target.addOption((Object)Compression.LZ4, (IObservableValue)lz4);
        IObservableValue model = PojoObservables.observeValue((Object)this.connection, (String)"compression");
        ctx.bindValue((IObservableValue)target, model);
    }
}

