/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard;

import com.datastax.devcenter.common.DevCenterLogger;
import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.connections.ConnectionsActivator;
import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.ui.wizard.ConnectionAdvancedSettingsWizardPage;
import com.datastax.devcenter.connections.ui.wizard.ConnectionBasicSettingsWizardPage;
import com.datastax.devcenter.connections.util.ConnectionNameUtils;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConnectionWizard
extends Wizard
implements INewWizard {
    protected final Connection connection;
    private final ConnectionBasicSettingsWizardPage basicSettingsPage;
    private final ConnectionAdvancedSettingsWizardPage advancedSettingsPage;

    public ConnectionWizard() {
        this(ConnectionWizard.newConnection());
    }

    private static Connection newConnection() {
        Connection connection = new Connection();
        connection.setName(ConnectionNameUtils.pickUpAvailableName("connection1"));
        return connection;
    }

    public ConnectionWizard(Connection connection) {
        this.connection = connection;
        ImageDescriptor image = null;
        try {
            image = IconUtility.getImageDescriptor((Plugin)ConnectionsActivator.getDefault(), (String)"icons/conn_new_wiz.png");
        }
        catch (Exception e) {
            DevCenterLogger.error((String)e.toString(), (String)((Object)((Object)this)).getClass().getCanonicalName(), (String)new Object(){}.getClass().getEnclosingMethod().getName());
        }
        this.basicSettingsPage = new ConnectionBasicSettingsWizardPage(connection, image);
        this.advancedSettingsPage = new ConnectionAdvancedSettingsWizardPage(connection, image);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle("New Connection");
    }

    public ConnectionBasicSettingsWizardPage getBasicSettingsPage() {
        return this.basicSettingsPage;
    }

    public ConnectionAdvancedSettingsWizardPage getAdvancedSettingsPage() {
        return this.advancedSettingsPage;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        this.addPage((IWizardPage)this.getBasicSettingsPage());
        this.addPage((IWizardPage)this.getAdvancedSettingsPage());
    }

    public boolean performFinish() {
        ConnectionList.getInstance().addConnection(this.connection);
        return true;
    }

    public Connection getConnection() {
        return this.connection;
    }
}

