/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard.filters;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.widgets.Text;

public abstract class AbstractTextFilter
implements ModifyListener {
    public void modifyText(ModifyEvent event) {
        if (event == null || event.getSource() == null || !(event.getSource() instanceof Text)) {
            return;
        }
        Text field = (Text)event.getSource();
        String text = field.getText();
        if (text == null) {
            return;
        }
        int currentCaretPosition = field.getCaretPosition();
        Matcher matcher = this.getFilterPattern().matcher(text);
        if (matcher.find()) {
            String replacedText = matcher.replaceAll("");
            field.setText(replacedText);
            if (currentCaretPosition == 0) {
                field.setSelection(replacedText.length());
            } else {
                field.setSelection(currentCaretPosition - 1);
            }
        }
    }

    protected abstract Pattern getFilterPattern();
}

