/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard.validators;

import com.datastax.devcenter.connections.ui.wizard.validators.KeystoreValidator;
import com.datastax.devcenter.connections.ui.wizard.validators.ValidationMessages;
import java.io.File;
import java.io.IOException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import org.eclipse.core.databinding.validation.ValidationStatus;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Text;

public abstract class KeystoreFileValidator
extends KeystoreValidator {
    public KeystoreFileValidator(Text fileText, Text passwordText) {
        super(fileText, passwordText);
    }

    public IStatus validate(Object value) {
        block10: {
            String filePath = (String)value;
            if (this.isEnabled()) {
                if (filePath.isEmpty()) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_empty, (Object)this.getKeystoreType()));
                }
                File file = new File(filePath);
                if (!file.exists()) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_not_exists, (Object)this.getKeystoreType()));
                }
                if (!file.isFile()) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_not_file, (Object)this.getKeystoreType()));
                }
                if (!file.canRead()) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_cannot_read, (Object)this.getKeystoreType()));
                }
                try {
                    this.loadKeyStore();
                }
                catch (KeyStoreException keyStoreException) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_KeyStoreException, (Object)this.getKeystoreType()));
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_NoSuchAlgorithmException, (Object)this.getKeystoreType()));
                }
                catch (CertificateException certificateException) {
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_CertificateException, (Object)this.getKeystoreType()));
                }
                catch (IOException e) {
                    if (e.getCause() != null && e.getCause() instanceof UnrecoverableKeyException) break block10;
                    return ValidationStatus.error((String)NLS.bind((String)ValidationMessages.KeystoreFileValidator_IOException, (Object)this.getKeystoreType()));
                }
            }
        }
        return ValidationStatus.ok();
    }
}

