/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.ui.wizard.validators;

import java.io.FileInputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.eclipse.core.databinding.validation.IValidator;
import org.eclipse.swt.widgets.Text;

public abstract class KeystoreValidator
implements IValidator {
    protected final Text fileText;
    protected final Text passwordText;

    public KeystoreValidator(Text fileText, Text passwordText) {
        this.fileText = fileText;
        this.passwordText = passwordText;
    }

    protected void loadKeyStore() throws KeyStoreException, IOException, NoSuchAlgorithmException, CertificateException {
        KeyStore ks = KeyStore.getInstance("JKS");
        FileInputStream fis = new FileInputStream(this.getFile());
        try {
            ks.load(fis, this.getPassword().toCharArray());
        }
        finally {
            fis.close();
        }
    }

    protected String getFile() {
        return this.fileText.getText();
    }

    protected String getPassword() {
        return this.passwordText.getText();
    }

    protected abstract String getKeystoreType();

    protected abstract boolean isEnabled();
}

