/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.util;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import java.util.Comparator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionNameUtils {
    private static final Pattern NAME_PATTERN = Pattern.compile(".*(\\d+)");
    private static ConnectionNameComparator nameComparator = new ConnectionNameComparator();

    public static String pickUpAvailableName(String base) {
        String candidate;
        int counter;
        if (!ConnectionNameUtils.nameExists(base)) {
            return base;
        }
        Matcher matcher = NAME_PATTERN.matcher(base);
        if (matcher.matches()) {
            base = base.substring(0, matcher.start(1));
            counter = Integer.parseInt(matcher.group(1)) + 1;
        } else {
            counter = 1;
        }
        while (ConnectionNameUtils.nameExists(candidate = String.valueOf(base) + counter++)) {
        }
        return candidate;
    }

    public static boolean nameExists(String name) {
        List<Connection> connections = ConnectionList.getInstance().getConnections();
        for (Connection connection : connections) {
            if (!connection.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Comparator<Connection> connectionNameComparator() {
        return nameComparator;
    }

    private static class ConnectionNameComparator
    implements Comparator<Connection> {
        private ConnectionNameComparator() {
        }

        @Override
        public int compare(Connection first, Connection second) {
            return String.CASE_INSENSITIVE_ORDER.compare(first.getName(), second.getName());
        }
    }
}

