/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.connections.util;

import com.datastax.driver.core.VersionNumber;

public class VersionNumberUtils {
    private static final VersionNumber VERSION_MIN_VALUE = VersionNumber.parse((String)"0.0.0");
    private static final VersionNumber VERSION_MAX_VALUE = VersionNumber.parse((String)"9999.9999.9999");

    public static boolean isVersionInRange(VersionNumber version, String fromString, String toString) {
        VersionNumber from = fromString == null || fromString.isEmpty() ? VERSION_MIN_VALUE : VersionNumber.parse((String)fromString);
        VersionNumber to = toString == null || toString.isEmpty() ? VERSION_MAX_VALUE : VersionNumber.parse((String)toString);
        return VersionNumberUtils.isVersionInRange(version, from, to);
    }

    public static boolean isVersionInRange(VersionNumber version, VersionNumber from, VersionNumber to) {
        return !(from != null && version.compareTo(from) < 0 || to != null && version.compareTo(to) >= 0);
    }
}

