/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.ui.views;

import com.datastax.devcenter.connections.models.Connection;
import com.datastax.devcenter.connections.models.ConnectionList;
import com.datastax.devcenter.connections.ui.views.providers.ConnectionProvider;
import com.datastax.devcenter.cql.CqlContext;
import com.datastax.devcenter.cql.ui.editor.CqlEditorPart;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.ui.views.providers.SchemaViewContentProvider;
import com.datastax.devcenter.schema.ui.views.providers.SchemaViewLabelProvider;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;

public class SchemaTreeViewPart
extends ViewPart
implements ConnectionList.Listener,
IPartListener2,
ConnectionProvider {
    public static final String ID = "com.datastax.devcenter.schema.ui.views.SchemaTreeViewPart";
    private static final String SCHEMA_CONTEXT_ID = "com.datastax.devcenter.schema.ui.views";
    private CqlEditorPart currentEditor;
    private TreeViewer treeViewer;
    private SchemaViewContentProvider schemaViewContentProvider;

    public void createPartControl(Composite parentComposite) {
        this.activateSchemaContext();
        this.createTreeViewer(parentComposite);
        this.hookContextMenu();
        ConnectionList.getInstance().addListener((ConnectionList.Listener)this);
        this.getSite().getWorkbenchWindow().getPartService().addPartListener((IPartListener2)this);
    }

    public void setFocus() {
        this.treeViewer.getControl().setFocus();
    }

    public void dispose() {
        ConnectionList.getInstance().removeListener((ConnectionList.Listener)this);
        this.getSite().getWorkbenchWindow().getPartService().removePartListener((IPartListener2)this);
        super.dispose();
    }

    public void connectionListUpdated() {
        this.refreshSchemaView(true);
    }

    public Connection getConnection() {
        return this.currentEditor == null ? null : this.currentEditor.getConnection();
    }

    public void partActivated(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part instanceof CqlEditorPart && this.currentEditor != part) {
            this.currentEditor = (CqlEditorPart)part;
            this.refreshSchemaView(false);
        }
    }

    private void activateSchemaContext() {
        IContextService service = (IContextService)this.getSite().getService(IContextService.class);
        service.activateContext(SCHEMA_CONTEXT_ID);
    }

    private void createTreeViewer(Composite parentComposite) {
        GridLayout gridLayout = new GridLayout(1, true);
        gridLayout.horizontalSpacing = 1;
        gridLayout.verticalSpacing = 3;
        gridLayout.marginHeight = 5;
        gridLayout.marginWidth = 0;
        gridLayout.marginTop = 0;
        gridLayout.marginBottom = 0;
        parentComposite.setLayout((Layout)gridLayout);
        this.treeViewer = new TreeViewer(parentComposite, 514);
        this.schemaViewContentProvider = new SchemaViewContentProvider();
        this.schemaViewContentProvider.init();
        this.treeViewer.setContentProvider((IContentProvider)this.schemaViewContentProvider);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new SchemaViewLabelProvider());
        GridData treeGridData = new GridData(1808);
        this.treeViewer.getTree().setLayoutData((Object)treeGridData);
        this.getSite().setSelectionProvider((ISelectionProvider)this.treeViewer);
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager();
        Menu menu = menuMgr.createContextMenu((Control)this.treeViewer.getTree());
        this.treeViewer.getTree().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.treeViewer);
    }

    private void refreshSchemaView(final boolean updateSchema) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SchemaTreeViewPart.this.treeViewer.getTree().isDisposed()) {
                    SchemaTreeViewPart.this.updatePartName();
                    SchemaTreeViewPart.this.updateTreeViewerInput(updateSchema);
                    SchemaTreeViewPart.this.treeViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                }
            }
        });
    }

    private void updatePartName() {
        Connection connection = this.getConnection();
        if (connection == null) {
            this.setPartName("Schema");
        } else {
            this.setPartName("Schema: " + connection.getName());
        }
    }

    private void updateTreeViewerInput(boolean updateSchema) {
        Schema schema = new Schema("");
        if (this.currentEditor != null) {
            CqlContext context = this.currentEditor.getContext();
            if (updateSchema) {
                this.currentEditor.updateConnectionAndRevalidate(this.getConnection());
            }
            schema = context.getDatabaseSchema();
        }
        this.treeViewer.setInput((Object)schema);
        this.treeViewer.refresh();
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        IWorkbenchPart part = partRef.getPart(false);
        if (part != null && part instanceof CqlEditorPart && this.currentEditor == part) {
            this.currentEditor = null;
            this.refreshSchemaView(false);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }
}

