/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.ui.views.providers;

import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.KeyspaceProvider;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import org.eclipse.swt.graphics.Image;

public class SchemaGroupingElement<T>
implements KeyspaceProvider {
    private final Keyspace keyspace;
    private final String name;
    private final Collection<T> elements;
    private Comparator<? super T> sortComparator;
    private Image image;

    public SchemaGroupingElement(Keyspace keyspace, String groupName, Collection<T> groupElements) {
        this.keyspace = keyspace;
        this.name = groupName;
        this.elements = groupElements;
    }

    public Keyspace getKeyspace() {
        return this.keyspace;
    }

    public String getName() {
        return this.name;
    }

    public Collection<T> getElements() {
        return this.elements;
    }

    public T[] getElementsArray() {
        Object[] array = this.elements.toArray();
        if (this.sortComparator == null) {
            return array;
        }
        Arrays.sort(array, this.sortComparator);
        return array;
    }

    public void addElement(T element) {
        this.elements.add(element);
    }

    public void setImage(Image groupImage) {
        this.image = groupImage;
    }

    public Image getImage() {
        return this.image;
    }

    public void setSortComparator(Comparator<? super T> comparator) {
        this.sortComparator = comparator;
    }
}

