/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.ui.views.providers;

import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.FunctionParameter;
import com.datastax.devcenter.schema.ISchemaElement;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.SchemaViewActivator;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.ui.views.providers.SchemaGroupingElement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;

public class SchemaViewContentProvider
implements ITreeContentProvider {
    private Schema schema;
    private Image columnImage;
    private Image tableImage;
    private Image udtImage;
    private Image pkColumnImage;
    private Image udfImage;

    public void init() {
        this.tableImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/table.gif").createImage();
        this.udtImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/udt.gif").createImage();
        this.udfImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/udf.gif").createImage();
        this.columnImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/column.gif").createImage();
        this.pkColumnImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/pkColumn.gif").createImage();
    }

    public void dispose() {
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput instanceof Schema) {
            this.schema = (Schema)newInput;
        }
    }

    public Object[] getElements(Object inputElement) {
        return this.getTreeDisplayElements(inputElement);
    }

    public Object[] getChildren(Object parentElement) {
        return this.getTreeDisplayElements(parentElement);
    }

    private Object[] getTreeDisplayElements(Object inputElement) {
        if (inputElement instanceof Schema) {
            Object[] keyspaces = this.schema.getKeyspaces().toArray(new Keyspace[0]);
            Arrays.sort(keyspaces, ISchemaElement.NAME_COMPARATOR);
            return keyspaces;
        }
        if (inputElement instanceof Keyspace) {
            Keyspace keyspace = (Keyspace)inputElement;
            Object[] objectArray = new Object[4];
            List tables = keyspace.getTables();
            SchemaGroupingElement tableGroupingElement = new SchemaGroupingElement(keyspace, "Tables", tables);
            tableGroupingElement.setImage(this.tableImage);
            tableGroupingElement.setSortComparator(ISchemaElement.NAME_COMPARATOR);
            objectArray[0] = tableGroupingElement;
            List userTypes = keyspace.getUserTypes();
            SchemaGroupingElement udtGroupingElement = new SchemaGroupingElement(keyspace, "User defined types", userTypes);
            udtGroupingElement.setImage(this.udtImage);
            udtGroupingElement.setSortComparator(ISchemaElement.NAME_COMPARATOR);
            objectArray[1] = udtGroupingElement;
            Set userDefinedFunctions = keyspace.getFunctions();
            ArrayList<SchemaFunction> userDefinedAggregates = new ArrayList<SchemaFunction>();
            for (SchemaFunction f : userDefinedFunctions) {
                if (!f.isAggregate()) continue;
                userDefinedAggregates.add(f);
            }
            userDefinedFunctions.removeAll(userDefinedAggregates);
            SchemaGroupingElement udfGroupingElement = new SchemaGroupingElement(keyspace, "User defined functions", userDefinedFunctions);
            udfGroupingElement.setImage(this.udfImage);
            udfGroupingElement.setSortComparator(ISchemaElement.NAME_COMPARATOR);
            objectArray[2] = udfGroupingElement;
            SchemaGroupingElement udaGroupingElement = new SchemaGroupingElement(keyspace, "User defined aggregates", userDefinedAggregates);
            udaGroupingElement.setImage(this.udfImage);
            udaGroupingElement.setSortComparator(ISchemaElement.NAME_COMPARATOR);
            objectArray[3] = udaGroupingElement;
            return objectArray;
        }
        if (inputElement instanceof Table) {
            Table table = (Table)inputElement;
            Object[] objectArray = new Object[4];
            List columnList = table.getColumns();
            SchemaGroupingElement columnGroupingElement = new SchemaGroupingElement(table.getKeyspace(), "Columns", columnList);
            columnGroupingElement.setImage(this.columnImage);
            objectArray[0] = columnGroupingElement;
            SchemaGroupingElement partitionKeyGroupingElement = new SchemaGroupingElement(table.getKeyspace(), "Partitioning Key", table.getPartitionKeys());
            partitionKeyGroupingElement.setImage(this.pkColumnImage);
            objectArray[1] = partitionKeyGroupingElement;
            SchemaGroupingElement clusteringKeyGroupingElement = new SchemaGroupingElement(table.getKeyspace(), "Clustering Column", table.getClusteringKeys());
            clusteringKeyGroupingElement.setImage(this.pkColumnImage);
            objectArray[2] = clusteringKeyGroupingElement;
            SchemaGroupingElement secondaryIndicesListHolder = new SchemaGroupingElement(table.getKeyspace(), "Secondary Indexes", new ArrayList());
            secondaryIndicesListHolder.setImage(this.pkColumnImage);
            for (Column column : columnList) {
                if (column.getIndex() == null) continue;
                secondaryIndicesListHolder.addElement(column.getIndex());
            }
            objectArray[3] = secondaryIndicesListHolder;
            return objectArray;
        }
        if (inputElement instanceof UserType) {
            UserType userType = (UserType)inputElement;
            Object[] objectArray = new Object[1];
            SchemaGroupingElement fieldGroupingElement = new SchemaGroupingElement(userType.getKeyspace(), "Fields", new ArrayList());
            fieldGroupingElement.setImage(this.columnImage);
            for (UserTypeField f : userType.getFields()) {
                fieldGroupingElement.addElement(f);
            }
            objectArray[0] = fieldGroupingElement;
            return objectArray;
        }
        if (inputElement instanceof SchemaFunction && ((SchemaFunction)inputElement).isAggregate()) {
            SchemaFunction udf = (SchemaFunction)inputElement;
            Object[] objectArray = new Object[1];
            SchemaGroupingElement functionParameterGroup = new SchemaGroupingElement(udf.getKeyspace(), "Parameters", new ArrayList());
            functionParameterGroup.setImage(this.columnImage);
            for (FunctionParameter p : udf.getFunctionParameters()) {
                functionParameterGroup.addElement(p);
            }
            objectArray[0] = functionParameterGroup;
            return objectArray;
        }
        if (inputElement instanceof SchemaFunction) {
            SchemaFunction udf = (SchemaFunction)inputElement;
            Object[] objectArray = new Object[1];
            SchemaGroupingElement functionParameterGroup = new SchemaGroupingElement(udf.getKeyspace(), "Parameters", new ArrayList());
            functionParameterGroup.setImage(this.columnImage);
            for (FunctionParameter p : udf.getFunctionParameters()) {
                functionParameterGroup.addElement(p);
            }
            objectArray[0] = functionParameterGroup;
            return objectArray;
        }
        if (inputElement instanceof SchemaGroupingElement) {
            SchemaGroupingElement fieldlistHolder = (SchemaGroupingElement)inputElement;
            return fieldlistHolder.getElementsArray();
        }
        return null;
    }

    public Object getParent(Object element) {
        return null;
    }

    public boolean hasChildren(Object element) {
        return element instanceof Schema || element instanceof Keyspace || element instanceof Table || element instanceof UserType || element instanceof SchemaFunction || element instanceof SchemaGroupingElement;
    }

    public Schema getSchema() {
        return this.schema;
    }
}

