/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.devcenter.schema.ui.views.providers;

import com.datastax.devcenter.common.ui.BasicStyler;
import com.datastax.devcenter.common.utils.IconUtility;
import com.datastax.devcenter.cql.validation.FunctionUtil;
import com.datastax.devcenter.schema.Column;
import com.datastax.devcenter.schema.FunctionParameter;
import com.datastax.devcenter.schema.Index;
import com.datastax.devcenter.schema.Keyspace;
import com.datastax.devcenter.schema.Schema;
import com.datastax.devcenter.schema.SchemaFunction;
import com.datastax.devcenter.schema.SchemaViewActivator;
import com.datastax.devcenter.schema.Table;
import com.datastax.devcenter.schema.UserType;
import com.datastax.devcenter.schema.UserTypeField;
import com.datastax.devcenter.schema.ui.views.providers.SchemaGroupingElement;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.StyledCellLabelProvider;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class SchemaViewLabelProvider
extends StyledCellLabelProvider {
    private final Image keyspaceImage;
    private final Image tableImage;
    private final Image columnImage;
    private final Image udtImage;
    private final Image udfImage;
    private final StyledString.Styler labelStyler;
    private final StyledString.Styler annotationStyler;
    private final Color BLACK = Display.getCurrent().getSystemColor(2);
    private final Color WHITE = Display.getCurrent().getSystemColor(1);
    private final Color DARK_GRAY = Display.getCurrent().getSystemColor(16);

    public SchemaViewLabelProvider() {
        this.keyspaceImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/keyspace.gif").createImage();
        this.tableImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/table.gif").createImage();
        this.udtImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/udt.gif").createImage();
        this.udfImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/udf.gif").createImage();
        this.columnImage = IconUtility.getImageDescriptor((Plugin)SchemaViewActivator.getDefault(), (String)"icons/column.gif").createImage();
        this.labelStyler = new BasicStyler(this.BLACK, this.WHITE);
        this.annotationStyler = new BasicStyler(this.DARK_GRAY, this.WHITE);
    }

    public void update(ViewerCell cell) {
        Object element = cell.getElement();
        if (element == null) {
            return;
        }
        if (element instanceof Schema) {
            Schema schema = (Schema)element;
            cell.setText(schema.getName());
        } else if (element instanceof Keyspace) {
            Keyspace keyspace = (Keyspace)element;
            cell.setText(keyspace.getName());
            cell.setImage(this.keyspaceImage);
        } else if (element instanceof Table) {
            Table table = (Table)element;
            cell.setText(table.getName());
            cell.setImage(this.tableImage);
        } else if (element instanceof Column) {
            Column column = (Column)element;
            StyledString styledString = new StyledString();
            styledString.append(column.getName(), this.labelStyler);
            String annotation = " (" + column.getType() + ")";
            styledString.append(annotation, this.annotationStyler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.columnImage);
        } else if (element instanceof UserType) {
            UserType udt = (UserType)element;
            cell.setText(udt.getName());
            cell.setImage(this.udtImage);
        } else if (element instanceof UserTypeField) {
            UserTypeField field = (UserTypeField)element;
            StyledString styledString = new StyledString();
            styledString.append(field.getName(), this.labelStyler);
            String annotation = " (" + field.getType() + ")";
            styledString.append(annotation, this.annotationStyler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.columnImage);
        } else if (element instanceof Index) {
            Index index = (Index)element;
            StyledString styledString = new StyledString();
            styledString.append(String.valueOf(index.getName()) + " " + index.getColumnDefinition(), this.labelStyler);
            String annotation = " (" + index.getColumn().getType() + ")";
            styledString.append(annotation, this.annotationStyler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.columnImage);
        } else if (element instanceof SchemaGroupingElement) {
            SchemaGroupingElement groupingElement = (SchemaGroupingElement)element;
            cell.setText(groupingElement.getName());
            cell.setImage(groupingElement.getImage());
        } else if (element instanceof SchemaFunction) {
            SchemaFunction udf = (SchemaFunction)element;
            StyledString styledString = new StyledString();
            styledString.append(FunctionUtil.getFunctionDisplayString((SchemaFunction)udf));
            String annotation = null;
            if (udf.getReturnType() != null) {
                annotation = " : " + udf.getReturnType();
                styledString.append(annotation, this.annotationStyler);
            }
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.udfImage);
        } else if (element instanceof FunctionParameter) {
            FunctionParameter functionParameter = (FunctionParameter)element;
            StyledString styledString = new StyledString();
            if (!functionParameter.getFunction().isAggregate()) {
                styledString.append(functionParameter.getName(), this.labelStyler);
            }
            String annotation = " (" + functionParameter.getType() + ")";
            styledString.append(annotation, this.annotationStyler);
            cell.setText(styledString.toString());
            cell.setStyleRanges(styledString.getStyleRanges());
            cell.setImage(this.columnImage);
        }
        super.update(cell);
    }
}

