/*
  DC++ Widget Toolkit

  Copyright (c) 2007-2008, Jacek Sieka

  All rights reserved.

  Redistribution and use in source and binary forms, with or without modification,
  are permitted provided that the following conditions are met:

      * Redistributions of source code must retain the above copyright notice,
        this list of conditions and the following disclaimer.
      * Redistributions in binary form must reproduce the above copyright notice,
        this list of conditions and the following disclaimer in the documentation
        and/or other materials provided with the distribution.
      * Neither the name of the DWT nor the names of its contributors
        may be used to endorse or promote products derived from this software
        without specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
  ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
  WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
  IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT,
  INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
  (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef DWT_FORWARD_H_
#define DWT_FORWARD_H_

namespace std { namespace tr1 {
template<class T> class shared_ptr;
} }

namespace dwt {

template< class WidgetType >
class WidgetCreator;

class Button;
typedef Button* ButtonPtr;

class CheckBox;
typedef CheckBox* CheckBoxPtr;

class ComboBox;
typedef ComboBox* ComboBoxPtr;

class Container;
typedef Container* ContainerPtr;

class CoolBar;
typedef CoolBar* CoolBarPtr;

class DateTime;
typedef DateTime* DateTimePtr;

class Grid;
typedef Grid* GridPtr;

class GroupBox;
typedef GroupBox* GroupBoxPtr;

class Label;
typedef Label* LabelPtr;

class Menu;
typedef std::tr1::shared_ptr<Menu> MenuPtr;

class MDIChild;
typedef MDIChild* MDIChildPtr;

class MDIFrame;
typedef MDIFrame* MDIFramePtr;

class MDIParent;
typedef MDIParent* MDIParentPtr;

class Notification;
typedef std::tr1::shared_ptr<Notification> NotificationPtr;

class ProgressBar;
typedef ProgressBar* ProgressBarPtr;

class RadioButton;
typedef RadioButton* RadioButtonPtr;

class RichTextBox;
typedef RichTextBox* RichTextBoxPtr;

class Slider;
typedef Slider* SliderPtr;

class Spinner;
typedef Spinner* SpinnerPtr;

class StatusBar;
typedef StatusBar* StatusBarPtr;

class Table;
typedef Table* TablePtr;

class TabView;
typedef TabView* TabViewPtr;

class TextBox;
typedef TextBox* TextBoxPtr;

class ToolBar;
typedef ToolBar* ToolBarPtr;

class ToolTip;
typedef ToolTip* ToolTipPtr;

class Tree;
typedef Tree* TreePtr;

class Window;
typedef Window* WindowPtr;

}
#endif /*FORWARD_H_*/
