/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.input;

import com.jme.input.KeyInput;
import com.jme.input.KeyInputListener;
import com.jme.util.LoggingSystem;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.BitSet;

public class AWTKeyInput
extends KeyInput
implements KeyListener {
    ArrayList<KeyEvent> events = new ArrayList();
    BitSet keyDown = new BitSet(256);
    private boolean enabled = true;

    protected AWTKeyInput() {
    }

    public boolean isKeyDown(int n) {
        return this.keyDown.get(n);
    }

    public String getKeyName(int n) {
        return KeyEvent.getKeyText(AWTKeyInput.toAWTCode(n));
    }

    public int getKeyIndex(String string) {
        throw new UnsupportedOperationException("getKeyIndex is not supported by AWTKeyInput.");
    }

    public void update() {
        if (this.listeners != null && this.listeners.size() > 0) {
            for (int i = 0; i < this.events.size(); ++i) {
                KeyEvent keyEvent = this.events.get(i);
                char c = keyEvent.getKeyChar();
                int n = AWTKeyInput.toInputCode(keyEvent.getKeyCode());
                boolean bl = keyEvent.getID() == 401;
                for (int j = 0; j < this.listeners.size(); ++j) {
                    KeyInputListener keyInputListener = (KeyInputListener)this.listeners.get(j);
                    keyInputListener.onKey(c, n, bl);
                }
            }
        }
        this.events.clear();
    }

    protected void destroy() {
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean bl) {
        this.enabled = bl;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        if (!this.enabled) {
            return;
        }
        this.events.add(keyEvent);
        this.keyDown.set(AWTKeyInput.toInputCode(keyEvent.getKeyCode()), true);
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (!this.enabled) {
            return;
        }
        this.events.add(keyEvent);
        this.keyDown.set(AWTKeyInput.toInputCode(keyEvent.getKeyCode()), false);
    }

    public static int toAWTCode(int n) {
        switch (n) {
            case 1: {
                return 27;
            }
            case 2: {
                return 49;
            }
            case 3: {
                return 50;
            }
            case 4: {
                return 51;
            }
            case 5: {
                return 52;
            }
            case 6: {
                return 53;
            }
            case 7: {
                return 54;
            }
            case 8: {
                return 55;
            }
            case 9: {
                return 56;
            }
            case 10: {
                return 57;
            }
            case 11: {
                return 48;
            }
            case 12: {
                return 45;
            }
            case 13: {
                return 61;
            }
            case 14: {
                return 8;
            }
            case 15: {
                return 9;
            }
            case 16: {
                return 81;
            }
            case 17: {
                return 87;
            }
            case 18: {
                return 69;
            }
            case 19: {
                return 82;
            }
            case 20: {
                return 84;
            }
            case 21: {
                return 89;
            }
            case 22: {
                return 85;
            }
            case 23: {
                return 73;
            }
            case 24: {
                return 79;
            }
            case 25: {
                return 80;
            }
            case 26: {
                return 91;
            }
            case 27: {
                return 93;
            }
            case 28: {
                return 10;
            }
            case 29: {
                return 17;
            }
            case 30: {
                return 65;
            }
            case 31: {
                return 83;
            }
            case 32: {
                return 68;
            }
            case 33: {
                return 70;
            }
            case 34: {
                return 71;
            }
            case 35: {
                return 72;
            }
            case 36: {
                return 74;
            }
            case 37: {
                return 75;
            }
            case 38: {
                return 76;
            }
            case 39: {
                return 59;
            }
            case 40: {
                return 222;
            }
            case 41: {
                return 128;
            }
            case 42: {
                return 16;
            }
            case 43: {
                return 92;
            }
            case 44: {
                return 90;
            }
            case 45: {
                return 88;
            }
            case 46: {
                return 67;
            }
            case 47: {
                return 86;
            }
            case 48: {
                return 66;
            }
            case 49: {
                return 78;
            }
            case 50: {
                return 77;
            }
            case 51: {
                return 44;
            }
            case 52: {
                return 46;
            }
            case 53: {
                return 47;
            }
            case 54: {
                return 16;
            }
            case 55: {
                return 106;
            }
            case 57: {
                return 32;
            }
            case 58: {
                return 20;
            }
            case 59: {
                return 112;
            }
            case 60: {
                return 113;
            }
            case 61: {
                return 114;
            }
            case 62: {
                return 115;
            }
            case 63: {
                return 116;
            }
            case 64: {
                return 117;
            }
            case 65: {
                return 118;
            }
            case 66: {
                return 119;
            }
            case 67: {
                return 120;
            }
            case 68: {
                return 121;
            }
            case 69: {
                return 144;
            }
            case 70: {
                return 145;
            }
            case 71: {
                return 103;
            }
            case 72: {
                return 104;
            }
            case 73: {
                return 105;
            }
            case 74: {
                return 109;
            }
            case 75: {
                return 100;
            }
            case 76: {
                return 101;
            }
            case 77: {
                return 102;
            }
            case 78: {
                return 107;
            }
            case 79: {
                return 97;
            }
            case 80: {
                return 98;
            }
            case 81: {
                return 99;
            }
            case 82: {
                return 96;
            }
            case 83: {
                return 110;
            }
            case 87: {
                return 122;
            }
            case 88: {
                return 123;
            }
            case 100: {
                return 61440;
            }
            case 101: {
                return 61441;
            }
            case 102: {
                return 61442;
            }
            case 112: {
                return 21;
            }
            case 121: {
                return 28;
            }
            case 123: {
                return 29;
            }
            case 141: {
                return 61;
            }
            case 144: {
                return 514;
            }
            case 145: {
                return 512;
            }
            case 146: {
                return 513;
            }
            case 147: {
                return 523;
            }
            case 149: {
                return 65480;
            }
            case 156: {
                return 10;
            }
            case 157: {
                return 17;
            }
            case 179: {
                return 44;
            }
            case 181: {
                return 111;
            }
            case 197: {
                return 19;
            }
            case 199: {
                return 36;
            }
            case 200: {
                return 38;
            }
            case 201: {
                return 33;
            }
            case 203: {
                return 37;
            }
            case 205: {
                return 39;
            }
            case 207: {
                return 35;
            }
            case 208: {
                return 40;
            }
            case 209: {
                return 34;
            }
            case 210: {
                return 155;
            }
            case 211: {
                return 127;
            }
            case 56: {
                return 18;
            }
            case 184: {
                return 18;
            }
        }
        LoggingSystem.getLogger().warning("unsupported key:" + n);
        return 65536 + n;
    }

    public static String getKeyParam(int n) {
        switch (n) {
            case 1: {
                return "KEY_ESCAPE";
            }
            case 2: {
                return "KEY_1";
            }
            case 3: {
                return "KEY_2";
            }
            case 4: {
                return "KEY_3";
            }
            case 5: {
                return "KEY_4";
            }
            case 6: {
                return "KEY_5";
            }
            case 7: {
                return "KEY_6";
            }
            case 8: {
                return "KEY_7";
            }
            case 9: {
                return "KEY_8";
            }
            case 10: {
                return "KEY_9";
            }
            case 11: {
                return "KEY_0";
            }
            case 12: {
                return "KEY_MINUS";
            }
            case 13: {
                return "KEY_EQUALS";
            }
            case 14: {
                return "KEY_BACK";
            }
            case 15: {
                return "KEY_TAB";
            }
            case 16: {
                return "KEY_Q";
            }
            case 17: {
                return "KEY_W";
            }
            case 18: {
                return "KEY_E";
            }
            case 19: {
                return "KEY_R";
            }
            case 20: {
                return "KEY_T";
            }
            case 21: {
                return "KEY_Y";
            }
            case 22: {
                return "KEY_U";
            }
            case 23: {
                return "KEY_I";
            }
            case 24: {
                return "KEY_O";
            }
            case 25: {
                return "KEY_P";
            }
            case 26: {
                return "KEY_LBRACKET";
            }
            case 27: {
                return "KEY_RBRACKET";
            }
            case 28: {
                return "KEY_RETURN";
            }
            case 29: {
                return "KEY_LCONTROL";
            }
            case 30: {
                return "KEY_A";
            }
            case 31: {
                return "KEY_S";
            }
            case 32: {
                return "KEY_D";
            }
            case 33: {
                return "KEY_F";
            }
            case 34: {
                return "KEY_G";
            }
            case 35: {
                return "KEY_H";
            }
            case 36: {
                return "KEY_J";
            }
            case 37: {
                return "KEY_K";
            }
            case 38: {
                return "KEY_L";
            }
            case 39: {
                return "KEY_SEMICOLON";
            }
            case 40: {
                return "KEY_APOSTROPHE";
            }
            case 41: {
                return "KEY_GRAVE";
            }
            case 42: {
                return "KEY_LSHIFT";
            }
            case 43: {
                return "KEY_BACKSLASH";
            }
            case 44: {
                return "KEY_Z";
            }
            case 45: {
                return "KEY_X";
            }
            case 46: {
                return "KEY_C";
            }
            case 47: {
                return "KEY_V";
            }
            case 48: {
                return "KEY_B";
            }
            case 49: {
                return "KEY_N";
            }
            case 50: {
                return "KEY_M";
            }
            case 51: {
                return "KEY_COMMA";
            }
            case 52: {
                return "KEY_PERIOD";
            }
            case 53: {
                return "KEY_SLASH";
            }
            case 54: {
                return "KEY_RSHIFT";
            }
            case 55: {
                return "KEY_MULTIPLY";
            }
            case 57: {
                return "KEY_SPACE";
            }
            case 58: {
                return "KEY_CAPITAL";
            }
            case 59: {
                return "KEY_F1";
            }
            case 60: {
                return "KEY_F2";
            }
            case 61: {
                return "KEY_F3";
            }
            case 62: {
                return "KEY_F4";
            }
            case 63: {
                return "KEY_F5";
            }
            case 64: {
                return "KEY_F6";
            }
            case 65: {
                return "KEY_F7";
            }
            case 66: {
                return "KEY_F8";
            }
            case 67: {
                return "KEY_F9";
            }
            case 68: {
                return "KEY_F10";
            }
            case 69: {
                return "KEY_NUMLOCK";
            }
            case 70: {
                return "KEY_SCROLL";
            }
            case 71: {
                return "KEY_NUMPAD7";
            }
            case 72: {
                return "KEY_NUMPAD8";
            }
            case 73: {
                return "KEY_NUMPAD9";
            }
            case 74: {
                return "KEY_SUBTRACT";
            }
            case 75: {
                return "KEY_NUMPAD4";
            }
            case 76: {
                return "KEY_NUMPAD5";
            }
            case 77: {
                return "KEY_NUMPAD6";
            }
            case 78: {
                return "KEY_ADD";
            }
            case 79: {
                return "KEY_NUMPAD1";
            }
            case 80: {
                return "VK_NUMPAD2";
            }
            case 81: {
                return "KEY_NUMPAD2";
            }
            case 82: {
                return "KEY_NUMPAD0";
            }
            case 83: {
                return "KEY_DECIMAL";
            }
            case 87: {
                return "KEY_F11";
            }
            case 88: {
                return "KEY_F12";
            }
            case 100: {
                return "KEY_F13";
            }
            case 101: {
                return "KEY_F14";
            }
            case 102: {
                return "KEY_F15";
            }
            case 112: {
                return "KEY_KANA";
            }
            case 121: {
                return "KEY_CONVERT";
            }
            case 123: {
                return "KEY_NOCONVERT";
            }
            case 141: {
                return "KEY_NUMPADEQUALS";
            }
            case 144: {
                return "KEY_CIRCUMFLEX";
            }
            case 145: {
                return "KEY_AT";
            }
            case 146: {
                return "KEY_COLON";
            }
            case 147: {
                return "KEY_UNDERLINE";
            }
            case 149: {
                return "KEY_STOP";
            }
            case 156: {
                return "KEY_NUMPADENTER";
            }
            case 157: {
                return "KEY_RCONTROL";
            }
            case 179: {
                return "KEY_NUMPADCOMMA";
            }
            case 181: {
                return "KEY_DIVIDE";
            }
            case 197: {
                return "KEY_PAUSE";
            }
            case 199: {
                return "KEY_HOME";
            }
            case 200: {
                return "KEY_UP";
            }
            case 201: {
                return "KEY_PRIOR";
            }
            case 203: {
                return "KEY_LEFT";
            }
            case 205: {
                return "KEY_RIGHT";
            }
            case 207: {
                return "KEY_END";
            }
            case 208: {
                return "KEY_DOWN";
            }
            case 209: {
                return "KEY_NEXT";
            }
            case 210: {
                return "KEY_INSERT";
            }
            case 211: {
                return "KEY_DELETE";
            }
            case 56: {
                return "KEY_LMENU";
            }
            case 184: {
                return "KEY_RMENU";
            }
        }
        LoggingSystem.getLogger().warning("unsupported key:" + n);
        return "unknown (" + n + ")";
    }

    public static int toInputCode(int n) {
        switch (n) {
            case 27: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 3;
            }
            case 51: {
                return 4;
            }
            case 52: {
                return 5;
            }
            case 53: {
                return 6;
            }
            case 54: {
                return 7;
            }
            case 55: {
                return 8;
            }
            case 56: {
                return 9;
            }
            case 57: {
                return 10;
            }
            case 48: {
                return 11;
            }
            case 45: {
                return 12;
            }
            case 61: {
                return 13;
            }
            case 8: {
                return 14;
            }
            case 9: {
                return 15;
            }
            case 81: {
                return 16;
            }
            case 87: {
                return 17;
            }
            case 69: {
                return 18;
            }
            case 82: {
                return 19;
            }
            case 84: {
                return 20;
            }
            case 89: {
                return 21;
            }
            case 85: {
                return 22;
            }
            case 73: {
                return 23;
            }
            case 79: {
                return 24;
            }
            case 80: {
                return 25;
            }
            case 91: {
                return 26;
            }
            case 93: {
                return 27;
            }
            case 10: {
                return 28;
            }
            case 17: {
                return 29;
            }
            case 65: {
                return 30;
            }
            case 83: {
                return 31;
            }
            case 68: {
                return 32;
            }
            case 70: {
                return 33;
            }
            case 71: {
                return 34;
            }
            case 72: {
                return 35;
            }
            case 74: {
                return 36;
            }
            case 75: {
                return 37;
            }
            case 76: {
                return 38;
            }
            case 59: {
                return 39;
            }
            case 222: {
                return 40;
            }
            case 128: {
                return 41;
            }
            case 16: {
                return 42;
            }
            case 92: {
                return 43;
            }
            case 90: {
                return 44;
            }
            case 88: {
                return 45;
            }
            case 67: {
                return 46;
            }
            case 86: {
                return 47;
            }
            case 66: {
                return 48;
            }
            case 78: {
                return 49;
            }
            case 77: {
                return 50;
            }
            case 44: {
                return 51;
            }
            case 46: {
                return 52;
            }
            case 47: {
                return 53;
            }
            case 106: {
                return 55;
            }
            case 32: {
                return 57;
            }
            case 20: {
                return 58;
            }
            case 112: {
                return 59;
            }
            case 113: {
                return 60;
            }
            case 114: {
                return 61;
            }
            case 115: {
                return 62;
            }
            case 116: {
                return 63;
            }
            case 117: {
                return 64;
            }
            case 118: {
                return 65;
            }
            case 119: {
                return 66;
            }
            case 120: {
                return 67;
            }
            case 121: {
                return 68;
            }
            case 144: {
                return 69;
            }
            case 145: {
                return 70;
            }
            case 103: {
                return 71;
            }
            case 104: {
                return 72;
            }
            case 105: {
                return 73;
            }
            case 109: {
                return 74;
            }
            case 100: {
                return 75;
            }
            case 101: {
                return 76;
            }
            case 102: {
                return 77;
            }
            case 107: {
                return 78;
            }
            case 97: {
                return 79;
            }
            case 98: {
                return 80;
            }
            case 99: {
                return 81;
            }
            case 96: {
                return 82;
            }
            case 110: {
                return 83;
            }
            case 122: {
                return 87;
            }
            case 123: {
                return 88;
            }
            case 61440: {
                return 100;
            }
            case 61441: {
                return 101;
            }
            case 61442: {
                return 102;
            }
            case 21: {
                return 112;
            }
            case 28: {
                return 121;
            }
            case 29: {
                return 123;
            }
            case 514: {
                return 144;
            }
            case 512: {
                return 145;
            }
            case 513: {
                return 146;
            }
            case 523: {
                return 147;
            }
            case 65480: {
                return 149;
            }
            case 111: {
                return 181;
            }
            case 19: {
                return 197;
            }
            case 36: {
                return 199;
            }
            case 38: {
                return 200;
            }
            case 33: {
                return 201;
            }
            case 37: {
                return 203;
            }
            case 39: {
                return 205;
            }
            case 35: {
                return 207;
            }
            case 40: {
                return 208;
            }
            case 34: {
                return 209;
            }
            case 155: {
                return 210;
            }
            case 127: {
                return 211;
            }
        }
        LoggingSystem.getLogger().warning("unsupported key:" + n);
        if (n >= 65536) {
            return n - 65536;
        }
        return 0;
    }
}

