/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.awt.swingui.dnd;

import com.jme.util.LoggingSystem;
import com.jmex.awt.swingui.JMEDesktop;
import com.jmex.awt.swingui.dnd.JMEDndException;
import com.jmex.awt.swingui.dnd.JMEDragGestureEvent;
import com.jmex.awt.swingui.dnd.JMEDragSourceEvent;
import com.jmex.awt.swingui.dnd.JMEDragSourceListener;
import com.jmex.awt.swingui.dnd.JMEDropTargetEvent;
import com.jmex.awt.swingui.dnd.JMEDropTargetListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JDesktopPane;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class JMEDragAndDrop {
    private static Logger log = LoggingSystem.getLogger();
    private JMEDragGestureEvent dge;
    private Transferable transferable;
    private JMEDragSourceListener dragSourceListener;
    private JMEDropTargetListener dropTargetListener;
    private boolean dndInProgress = false;
    private JMEDesktop desktop;
    private boolean allowFreeDrop;
    private JComponent dragComponent;

    public JMEDragAndDrop(JMEDesktop jMEDesktop) {
        this.setDesktop(jMEDesktop);
    }

    private void setDesktop(JMEDesktop jMEDesktop) {
        jMEDesktop.setDragAndDropSupport(this);
        this.desktop = jMEDesktop;
    }

    public Transferable getTransferable() {
        return this.transferable;
    }

    public boolean isDragPanel(Component component) {
        return component != null && component == this.dragComponent;
    }

    public void startDrag(JMEDragGestureEvent jMEDragGestureEvent, ImageIcon imageIcon, Transferable transferable, JMEDragSourceListener jMEDragSourceListener) throws JMEDndException {
        this.startDrag(jMEDragGestureEvent, imageIcon, transferable, jMEDragSourceListener, false);
    }

    public void startDrag(JMEDragGestureEvent jMEDragGestureEvent, ImageIcon imageIcon, Transferable transferable, JMEDragSourceListener jMEDragSourceListener, boolean bl) throws JMEDndException {
        if (this.dndInProgress) {
            throw new JMEDndException("drag and drop in progress");
        }
        this.dge = jMEDragGestureEvent;
        this.transferable = transferable;
        this.allowFreeDrop = bl;
        this.dragSourceListener = jMEDragSourceListener;
        if (jMEDragSourceListener instanceof JMEDropTargetListener) {
            this.dropTargetListener = (JMEDropTargetListener)((Object)jMEDragSourceListener);
        }
        JLabel jLabel = new JLabel(imageIcon);
        jLabel.setName("dragLabel");
        jLabel.setSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        this.dragComponent = jLabel;
        this.desktop.getJDesktop().add((Component)this.dragComponent, Integer.MAX_VALUE);
        this.desktop.getJDesktop().setComponentZOrder(this.dragComponent, 0);
        this.dndInProgress = true;
    }

    public boolean isDragging() {
        return this.dndInProgress;
    }

    public void doDrag(MouseEvent mouseEvent) {
        Point point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY(), this.desktop.getJDesktop());
        this.dragComponent.setLocation(point.x - this.dragComponent.getWidth() / 2, point.y - this.dragComponent.getHeight() / 2);
        if (this.dropTargetListener != null) {
            Point point2 = SwingUtilities.convertPoint(this.desktop.getJDesktop(), point.x, point.y, (Component)((Object)this.dropTargetListener));
            this.dropTargetListener.dragOver(new JMEDropTargetEvent(point2, this.dge.getAction(), this));
        }
    }

    private JMEDropTargetListener getDropTargetListener(Container container) {
        for (int i = 0; i < container.getComponentCount(); ++i) {
            JMEDropTargetListener jMEDropTargetListener;
            Component component = container.getComponent(i);
            if (component instanceof JMEDropTargetListener) {
                return (JMEDropTargetListener)((Object)component);
            }
            if (!(component instanceof Container) || (jMEDropTargetListener = this.getDropTargetListener((Container)component)) == null) continue;
            return jMEDropTargetListener;
        }
        return null;
    }

    private JMEDropTargetListener getDropTargetListenerAt(Component component, int n, int n2) {
        Component component2 = component.getComponentAt(n, n2);
        if (component2 == null || component2 == component) {
            return null;
        }
        if (component2 instanceof JMEDropTargetListener) {
            return (JMEDropTargetListener)((Object)component2);
        }
        if (component2 instanceof Container) {
            return this.getDropTargetListener((Container)component2);
        }
        return null;
    }

    public void doDrop(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        this.dragComponent.setVisible(false);
        this.desktop.getJDesktop().remove(this.dragComponent);
        if (this.dropTargetListener == null && !((Component)((Object)this.dragSourceListener)).contains(point)) {
            point = SwingUtilities.convertPoint((Component)((Object)this.dragSourceListener), mouseEvent.getX(), mouseEvent.getY(), this.desktop.getJDesktop());
            this.dropTargetListener = this.getDropTargetListenerAt(this.desktop.getJDesktop(), point.x, point.y);
        }
        boolean bl = false;
        boolean bl2 = false;
        if (this.dropTargetListener != null) {
            Point point2 = SwingUtilities.convertPoint((Component)((Object)this.dragSourceListener), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)this.dropTargetListener));
            JMEDropTargetEvent jMEDropTargetEvent = new JMEDropTargetEvent(point2, this.dge.getAction(), this);
            this.dropTargetListener.drop(jMEDropTargetEvent);
            bl2 = jMEDropTargetEvent.isCompleted();
        } else if (this.allowFreeDrop) {
            point = SwingUtilities.convertPoint((Component)((Object)this.dragSourceListener), mouseEvent.getX(), mouseEvent.getY(), this.desktop.getJDesktop());
            Component component = this.desktop.getJDesktop().getComponentAt(point);
            if (component == null || component instanceof JDesktopPane) {
                bl2 = true;
                bl = true;
            } else {
                log.info("no drop target and dropped on " + point + component);
            }
        } else {
            log.info("no drop target and freedrop is not allowed.");
        }
        this.dragSourceListener.dragDropEnd(new JMEDragSourceEvent(point, this.dge.getAction(), bl2, bl));
        this.dndInProgress = false;
        this.dropTargetListener = null;
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMEDropTargetListener) {
            this.dropTargetListener = (JMEDropTargetListener)mouseEvent.getSource();
            Point point = SwingUtilities.convertPoint((Component)((Object)this.dragSourceListener), mouseEvent.getX(), mouseEvent.getY(), (Component)((Object)this.dropTargetListener));
            ((JMEDropTargetListener)mouseEvent.getSource()).dragEnter(new JMEDropTargetEvent(point, this.dge.getAction(), this));
        }
        this.dragSourceListener.dragEnter(new JMEDragSourceEvent(mouseEvent.getPoint(), this.dge.getAction(), mouseEvent.getComponent()));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        if (mouseEvent.getSource() instanceof JMEDropTargetListener) {
            this.dropTargetListener = null;
            ((JMEDropTargetListener)mouseEvent.getSource()).dragExit(new JMEDropTargetEvent(mouseEvent.getPoint(), this.dge.getAction(), this));
        }
        this.dragSourceListener.dragExit(new JMEDragSourceEvent(mouseEvent.getPoint(), this.dge.getAction()));
    }

    public static ImageIcon createTextIcon(JComponent jComponent, String string) {
        Font font = jComponent.getFont();
        int n = 2;
        int n2 = 1;
        int n3 = jComponent.getFontMetrics(font).stringWidth(string) + n * 2;
        int n4 = jComponent.getFontMetrics(font).getHeight() + n2 * 2;
        BufferedImage bufferedImage = new BufferedImage(n3, n4, 6);
        Graphics graphics = bufferedImage.getGraphics();
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n3, n4);
        graphics.setFont(font);
        graphics.setColor(Color.yellow);
        graphics.drawString(string, n, n4 - n2);
        log.info("created a text image for " + string + ": " + bufferedImage.toString());
        return new ImageIcon(bufferedImage);
    }

    public JMEDropTargetListener getDropTargetListener() {
        return this.dropTargetListener;
    }
}

