/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.input;

import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.Map;
import org.lwjgl.BufferUtils;
import org.lwjgl.LWJGLException;
import org.lwjgl.LWJGLUtil;
import org.lwjgl.Sys;
import org.lwjgl.input.Cursor;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.InputImplementation;

public class Mouse {
    public static final int EVENT_SIZE = 22;
    private static boolean created;
    private static ByteBuffer buttons;
    private static int x;
    private static int y;
    private static IntBuffer coord_buffer;
    private static int dx;
    private static int dy;
    private static int dwheel;
    private static int buttonCount;
    private static boolean hasWheel;
    private static Cursor currentCursor;
    private static String[] buttonName;
    private static final Map buttonMap;
    private static boolean initialized;
    private static ByteBuffer readBuffer;
    private static int eventButton;
    private static boolean eventState;
    private static int event_dx;
    private static int event_dy;
    private static int event_dwheel;
    private static int event_x;
    private static int event_y;
    private static long event_nanos;
    private static final int BUFFER_SIZE = 50;
    private static boolean isGrabbed;
    private static InputImplementation implementation;
    private static final boolean emulateCursorAnimation;
    static /* synthetic */ Class class$org$lwjgl$opengl$Display;

    private Mouse() {
    }

    public static synchronized Cursor getNativeCursor() {
        return currentCursor;
    }

    public static synchronized Cursor setNativeCursor(Cursor cursor) throws LWJGLException {
        if ((Cursor.getCapabilities() & 1) == 0) {
            throw new IllegalStateException("Mouse doesn't support native cursors");
        }
        Cursor oldCursor = currentCursor;
        currentCursor = cursor;
        if (Mouse.isCreated()) {
            if (currentCursor != null) {
                implementation.setNativeCursor(currentCursor.getHandle());
                currentCursor.setTimeout();
            } else {
                implementation.setNativeCursor(null);
            }
        }
        return oldCursor;
    }

    public static synchronized void setCursorPosition(int new_x, int new_y) {
        if (!Mouse.isCreated()) {
            throw new IllegalStateException("Mouse is not created");
        }
        x = event_x = new_x;
        y = event_y = new_y;
        if (!Mouse.isGrabbed() && (Cursor.getCapabilities() & 1) != 0) {
            implementation.setCursorPosition(x, y);
        }
    }

    private static void initialize() {
        Sys.initialize();
        buttonName = new String[16];
        for (int i = 0; i < 16; ++i) {
            Mouse.buttonName[i] = "BUTTON" + i;
            buttonMap.put(buttonName[i], new Integer(i));
        }
        initialized = true;
    }

    private static void resetMouse() {
        dwheel = 0;
        dy = 0;
        dx = 0;
        readBuffer.position(readBuffer.limit());
    }

    static InputImplementation getImplementation() {
        return implementation;
    }

    static InputImplementation createImplementation() {
        try {
            return (InputImplementation)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    Method getImplementation_method = (class$org$lwjgl$opengl$Display == null ? (class$org$lwjgl$opengl$Display = Mouse.class$("org.lwjgl.opengl.Display")) : class$org$lwjgl$opengl$Display).getDeclaredMethod("getImplementation", null);
                    getImplementation_method.setAccessible(true);
                    return getImplementation_method.invoke(null, null);
                }
            });
        }
        catch (PrivilegedActionException e) {
            throw new Error(e);
        }
    }

    private static void create(InputImplementation impl) throws LWJGLException {
        if (created) {
            return;
        }
        if (!initialized) {
            Mouse.initialize();
        }
        implementation = impl;
        implementation.createMouse();
        hasWheel = implementation.hasWheel();
        created = true;
        buttonCount = implementation.getButtonCount();
        buttons = BufferUtils.createByteBuffer(buttonCount);
        coord_buffer = BufferUtils.createIntBuffer(3);
        if (currentCursor != null && implementation.getNativeCursorCapabilities() != 0) {
            Mouse.setNativeCursor(currentCursor);
        }
        readBuffer = ByteBuffer.allocate(1100);
        readBuffer.limit(0);
        Mouse.setGrabbed(isGrabbed);
    }

    public static synchronized void create() throws LWJGLException {
        if (!Display.isCreated()) {
            throw new IllegalStateException("Display must be created.");
        }
        Mouse.create(Mouse.createImplementation());
    }

    public static synchronized boolean isCreated() {
        return created;
    }

    public static synchronized void destroy() {
        if (!created) {
            return;
        }
        created = false;
        buttons = null;
        coord_buffer = null;
        implementation.destroyMouse();
    }

    public static synchronized void poll() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll it");
        }
        implementation.pollMouse(coord_buffer, buttons);
        int poll_coord1 = coord_buffer.get(0);
        int poll_coord2 = coord_buffer.get(1);
        int poll_dwheel = coord_buffer.get(2);
        if (Mouse.isGrabbed()) {
            dx += poll_coord1;
            dy += poll_coord2;
            x += poll_coord1;
            y += poll_coord2;
        } else {
            dx = poll_coord1 - x;
            dy = poll_coord2 - y;
            x = poll_coord1;
            y = poll_coord2;
        }
        x = Math.min(implementation.getWidth() - 1, Math.max(0, x));
        y = Math.min(implementation.getHeight() - 1, Math.max(0, y));
        dwheel += poll_dwheel;
        Mouse.read();
    }

    private static void read() {
        readBuffer.compact();
        implementation.readMouse(readBuffer);
        readBuffer.flip();
    }

    public static synchronized boolean isButtonDown(int button) {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can poll the button state");
        }
        if (button >= buttonCount || button < 0) {
            return false;
        }
        return buttons.get(button) == 1;
    }

    public static synchronized String getButtonName(int button) {
        if (button >= buttonName.length || button < 0) {
            return null;
        }
        return buttonName[button];
    }

    public static synchronized int getButtonIndex(String buttonName) {
        Integer ret = (Integer)buttonMap.get(buttonName);
        if (ret == null) {
            return -1;
        }
        return ret;
    }

    public static synchronized boolean next() {
        if (!created) {
            throw new IllegalStateException("Mouse must be created before you can read events");
        }
        if (readBuffer.hasRemaining()) {
            eventButton = readBuffer.get();
            boolean bl = eventState = readBuffer.get() != 0;
            if (Mouse.isGrabbed()) {
                event_dx = readBuffer.getInt();
                event_dy = readBuffer.getInt();
                event_x += event_dx;
                event_y += event_dy;
            } else {
                int new_event_x = readBuffer.getInt();
                int new_event_y = readBuffer.getInt();
                event_dx = new_event_x - event_x;
                event_dy = new_event_y - event_y;
                event_x = new_event_x;
                event_y = new_event_y;
            }
            event_x = Math.min(implementation.getWidth() - 1, Math.max(0, event_x));
            event_y = Math.min(implementation.getHeight() - 1, Math.max(0, event_y));
            event_dwheel = readBuffer.getInt();
            event_nanos = readBuffer.getLong();
            return true;
        }
        return false;
    }

    public static synchronized int getEventButton() {
        return eventButton;
    }

    public static synchronized boolean getEventButtonState() {
        return eventState;
    }

    public static synchronized int getEventDX() {
        return event_dx;
    }

    public static synchronized int getEventDY() {
        return event_dy;
    }

    public static synchronized int getEventX() {
        return event_x;
    }

    public static synchronized int getEventY() {
        return event_y;
    }

    public static synchronized int getEventDWheel() {
        return event_dwheel;
    }

    public static synchronized long getEventNanoseconds() {
        return event_nanos;
    }

    public static synchronized int getX() {
        return x;
    }

    public static synchronized int getY() {
        return y;
    }

    public static synchronized int getDX() {
        int result = dx;
        dx = 0;
        return result;
    }

    public static synchronized int getDY() {
        int result = dy;
        dy = 0;
        return result;
    }

    public static synchronized int getDWheel() {
        int result = dwheel;
        dwheel = 0;
        return result;
    }

    public static synchronized int getButtonCount() {
        return buttonCount;
    }

    public static synchronized boolean hasWheel() {
        return hasWheel;
    }

    public static synchronized boolean isGrabbed() {
        return isGrabbed;
    }

    public static synchronized void setGrabbed(boolean grab) {
        isGrabbed = grab;
        if (Mouse.isCreated()) {
            implementation.grabMouse(isGrabbed);
            Mouse.poll();
            event_x = x;
            event_y = y;
            Mouse.resetMouse();
        }
    }

    public static synchronized void updateCursor() {
        block3: {
            if (emulateCursorAnimation && currentCursor != null && currentCursor.hasTimedOut()) {
                currentCursor.nextCursor();
                try {
                    Mouse.setNativeCursor(currentCursor);
                }
                catch (LWJGLException e) {
                    if (!LWJGLUtil.DEBUG) break block3;
                    e.printStackTrace();
                }
            }
        }
    }

    static {
        buttonCount = -1;
        buttonMap = new HashMap(16);
        emulateCursorAnimation = LWJGLUtil.getPlatform() == 3 || LWJGLUtil.getPlatform() == 2;
    }
}

