/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.math;

import com.jme.math.Vector3f;
import com.jmex.font3d.math.PlanarEdge;

public class PlanarVertex {
    int index;
    Vector3f point;
    private PlanarEdge arb_outgoing;

    PlanarVertex(int n, Vector3f vector3f) {
        this.index = n;
        this.point = vector3f;
    }

    void addOutgoingEdge(PlanarEdge planarEdge) {
        PlanarEdge planarEdge2;
        if (this.arb_outgoing == null) {
            this.arb_outgoing = planarEdge;
            planarEdge.getTwin().setNext(planarEdge);
        } else {
            planarEdge2 = this.clockWiseOf(planarEdge);
            planarEdge2.getPrev().setNext(planarEdge);
            planarEdge.getTwin().setNext(planarEdge2);
        }
        if (planarEdge.getTwin().getOrigin().arb_outgoing == null) {
            planarEdge.getTwin().getOrigin().arb_outgoing = planarEdge.getTwin();
            planarEdge.setNext(planarEdge.getTwin());
        } else {
            planarEdge2 = planarEdge.getTwin().getOrigin().clockWiseOf(planarEdge.getTwin());
            planarEdge2.getPrev().setNext(planarEdge.getTwin());
            planarEdge.setNext(planarEdge2);
        }
    }

    private PlanarEdge clockWiseOf(PlanarEdge planarEdge) {
        PlanarEdge planarEdge2;
        PlanarEdge planarEdge3 = planarEdge2 = this.arb_outgoing;
        float f = planarEdge3.angleCounterClockWise(planarEdge);
        do {
            if (planarEdge3.getOrigin() != this) {
                throw new RuntimeException("We get an edge that does not orginate from this vertex !!!");
            }
            float f2 = (planarEdge3 = planarEdge3.getTwin().getNext()).angleCounterClockWise(planarEdge);
            if (f2 == f && planarEdge2 != planarEdge3) {
                if (planarEdge3.getTwin().getNext() == planarEdge2) {
                    planarEdge2 = planarEdge3;
                    continue;
                }
                if (planarEdge3.isRealEdge() && !planarEdge2.isRealEdge()) {
                    planarEdge2 = planarEdge3;
                    continue;
                }
                if (planarEdge2.getTwin().getNext() == planarEdge3) continue;
                System.out.println("\nHOLY CRAP: (nangle == angle && " + planarEdge2 + " != " + planarEdge3 + ")");
                continue;
            }
            if (!(f2 < f)) continue;
            planarEdge2 = planarEdge3;
            f = f2;
        } while (planarEdge3 != this.arb_outgoing);
        return planarEdge2;
    }

    PlanarEdge getEdge(PlanarVertex planarVertex) {
        if (this.arb_outgoing == null) {
            return null;
        }
        PlanarEdge planarEdge = this.arb_outgoing;
        do {
            if (planarEdge.getTwin().getOrigin() != planarVertex) continue;
            return planarEdge;
        } while ((planarEdge = planarEdge.getTwin().getNext()) != this.arb_outgoing);
        return null;
    }

    public int getIndex() {
        return this.index;
    }

    PlanarEdge getFirstEdge() {
        return this.arb_outgoing;
    }

    public String toString() {
        return "[indx:" + this.index + ",(" + this.point.x + "," + this.point.y + ")]";
    }

    public Vector3f getPoint() {
        return this.point;
    }

    public void printEdges() {
        if (this.arb_outgoing == null) {
            System.out.println("I HAVE NOT EDGES !");
            return;
        }
        PlanarEdge planarEdge = this.arb_outgoing;
        do {
            System.out.println("Edge:" + planarEdge);
        } while ((planarEdge = planarEdge.getTwin().getNext()) != this.arb_outgoing);
    }
}

