/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada;

import com.jme.animation.Bone;
import com.jme.animation.BoneAnimation;
import com.jme.animation.BoneTransform;
import com.jme.animation.SkinNode;
import com.jme.animation.TextureKeyframeController;
import com.jme.bounding.BoundingBox;
import com.jme.bounding.BoundingVolume;
import com.jme.image.Texture;
import com.jme.light.DirectionalLight;
import com.jme.light.Light;
import com.jme.light.LightNode;
import com.jme.light.PointLight;
import com.jme.light.SpotLight;
import com.jme.math.Matrix4f;
import com.jme.math.Quaternion;
import com.jme.math.Vector2f;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.renderer.Renderer;
import com.jme.scene.CameraNode;
import com.jme.scene.Controller;
import com.jme.scene.Geometry;
import com.jme.scene.Line;
import com.jme.scene.SharedMesh;
import com.jme.scene.Spatial;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.batch.TriangleBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.ClipState;
import com.jme.scene.state.ColorMaskState;
import com.jme.scene.state.CullState;
import com.jme.scene.state.DitherState;
import com.jme.scene.state.FogState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ShadeState;
import com.jme.scene.state.StencilState;
import com.jme.scene.state.TextureState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jme.util.ErrorManager;
import com.jme.util.LoggingSystem;
import com.jme.util.TextureManager;
import com.jme.util.export.Savable;
import com.jme.util.export.binary.BinaryExporter;
import com.jme.util.export.binary.BinaryImporter;
import com.jme.util.geom.BufferUtils;
import com.jme.util.geom.GeometryTool;
import com.jmex.model.collada.ColladaMaterial;
import com.jmex.model.collada.ExtraPluginManager;
import com.jmex.model.collada.schema.COLLADASchemaDoc;
import com.jmex.model.collada.schema.COLLADAType;
import com.jmex.model.collada.schema.IDREF_arrayType;
import com.jmex.model.collada.schema.InstanceWithExtra;
import com.jmex.model.collada.schema.Name_arrayType;
import com.jmex.model.collada.schema.TargetableFloat3;
import com.jmex.model.collada.schema.accessorType;
import com.jmex.model.collada.schema.animationType;
import com.jmex.model.collada.schema.assetType;
import com.jmex.model.collada.schema.bind_materialType;
import com.jmex.model.collada.schema.cameraType;
import com.jmex.model.collada.schema.colorType;
import com.jmex.model.collada.schema.common_newparam_type;
import com.jmex.model.collada.schema.controllerType;
import com.jmex.model.collada.schema.effectType;
import com.jmex.model.collada.schema.float4x4;
import com.jmex.model.collada.schema.float_arrayType;
import com.jmex.model.collada.schema.fx_sampler2D_common;
import com.jmex.model.collada.schema.fx_surface_common;
import com.jmex.model.collada.schema.geometryType;
import com.jmex.model.collada.schema.imageType;
import com.jmex.model.collada.schema.instance_controllerType;
import com.jmex.model.collada.schema.instance_geometryType;
import com.jmex.model.collada.schema.instance_materialType;
import com.jmex.model.collada.schema.instance_physics_modelType;
import com.jmex.model.collada.schema.lambertType;
import com.jmex.model.collada.schema.library_animationsType;
import com.jmex.model.collada.schema.library_camerasType;
import com.jmex.model.collada.schema.library_controllersType;
import com.jmex.model.collada.schema.library_effectsType;
import com.jmex.model.collada.schema.library_geometriesType;
import com.jmex.model.collada.schema.library_imagesType;
import com.jmex.model.collada.schema.library_lightsType;
import com.jmex.model.collada.schema.library_materialsType;
import com.jmex.model.collada.schema.library_physics_modelsType;
import com.jmex.model.collada.schema.library_physics_scenesType;
import com.jmex.model.collada.schema.library_visual_scenesType;
import com.jmex.model.collada.schema.lightType;
import com.jmex.model.collada.schema.materialType;
import com.jmex.model.collada.schema.meshType;
import com.jmex.model.collada.schema.nodeType2;
import com.jmex.model.collada.schema.opticsType;
import com.jmex.model.collada.schema.orthographicType;
import com.jmex.model.collada.schema.paramType3;
import com.jmex.model.collada.schema.passType3;
import com.jmex.model.collada.schema.perspectiveType;
import com.jmex.model.collada.schema.phongType;
import com.jmex.model.collada.schema.physics_modelType;
import com.jmex.model.collada.schema.physics_sceneType;
import com.jmex.model.collada.schema.polygonsType;
import com.jmex.model.collada.schema.rigid_bodyType;
import com.jmex.model.collada.schema.sceneType;
import com.jmex.model.collada.schema.shapeType2;
import com.jmex.model.collada.schema.skinType;
import com.jmex.model.collada.schema.sourceType;
import com.jmex.model.collada.schema.techniqueType2;
import com.jmex.model.collada.schema.techniqueType4;
import com.jmex.model.collada.schema.technique_commonType;
import com.jmex.model.collada.schema.technique_commonType2;
import com.jmex.model.collada.schema.technique_commonType4;
import com.jmex.model.collada.schema.textureType;
import com.jmex.model.collada.schema.trianglesType;
import com.jmex.model.collada.schema.vertex_weightsType;
import com.jmex.model.collada.schema.visual_sceneType;
import com.jmex.model.collada.xml.Node;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColladaImporter {
    private String modelAuthor;
    private String tool;
    private String revision;
    private String unitName;
    private float unitMeter;
    private String upAxis;
    private static ColladaImporter instance;
    private String name;
    private String[] boneIds;
    private static boolean squelch;
    URL textureDirectory;
    private Map<String, Object> resourceLibrary;
    private ArrayList<String> controllerNames;
    private ArrayList<String> uvControllerNames;
    private ArrayList<String> skinNodeNames;
    private ArrayList<String> cameraNodeNames;
    private ArrayList<String> lightNodeNames;
    private ArrayList<String> geometryNames;
    private ArrayList<String> skeletonNames;
    private com.jme.scene.Node model;
    private static final long serialVersionUID = -4024091270314000507L;

    private ColladaImporter(String string2) {
        this.name = string2;
    }

    public static void load(InputStream inputStream, URL uRL, String string2) {
        if (instance == null) {
            instance = new ColladaImporter(string2);
        }
        instance.load(inputStream, uRL);
    }

    private void load(InputStream inputStream, URL uRL) {
        this.model = new com.jme.scene.Node(this.name);
        this.resourceLibrary = new HashMap<String, Object>();
        this.textureDirectory = uRL;
        COLLADASchemaDoc cOLLADASchemaDoc = new COLLADASchemaDoc();
        try {
            COLLADAType cOLLADAType = new COLLADAType(cOLLADASchemaDoc.load(inputStream));
            LoggingSystem.getLogger().info("Version: " + cOLLADAType.getversion().getValue());
            this.processCollada(cOLLADAType);
        }
        catch (Exception exception) {
            ErrorManager.getInstance().addError(Level.WARNING, "Unable to load Collada file. " + exception.getMessage());
            return;
        }
    }

    public static ArrayList<String> getControllerNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.controllerNames;
    }

    public static ArrayList<String> getUVControllerNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.uvControllerNames;
    }

    public static void addUVControllerName(String string2) {
        if (ColladaImporter.instance.uvControllerNames == null) {
            ColladaImporter.instance.uvControllerNames = new ArrayList();
        }
        ColladaImporter.instance.uvControllerNames.add(string2);
    }

    public static ArrayList<String> getSkinNodeNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.skinNodeNames;
    }

    public static ArrayList<String> getCameraNodeNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.cameraNodeNames;
    }

    public static ArrayList<String> getLightNodeNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.lightNodeNames;
    }

    public static ArrayList<String> getSkeletonNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.skeletonNames;
    }

    public static ArrayList<String> getGeometryNames() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.geometryNames;
    }

    public static com.jme.scene.Node getModel() {
        if (instance == null) {
            return null;
        }
        return ColladaImporter.instance.model;
    }

    public static SkinNode getSkinNode(String string2) {
        if (instance == null) {
            return null;
        }
        return (SkinNode)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static CameraNode getCameraNode(String string2) {
        if (instance == null) {
            return null;
        }
        return (CameraNode)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static LightNode getLightNode(String string2) {
        if (instance == null) {
            return null;
        }
        return (LightNode)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static Object get(Object object) {
        return ColladaImporter.instance.resourceLibrary.get(object);
    }

    public static void put(String string2, Object object) {
        if (ColladaImporter.instance.resourceLibrary.containsKey(string2) && !squelch) {
            ErrorManager.getInstance().addError(Level.WARNING, "Key: " + string2 + " already in use. Overriding previous data. This is probably not" + " desired.");
        }
        ColladaImporter.instance.resourceLibrary.put(string2, object);
    }

    public static BoneAnimation getAnimationController(String string2) {
        if (instance == null) {
            return null;
        }
        return (BoneAnimation)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static TextureKeyframeController getUVAnimationController(String string2) {
        if (instance == null) {
            return null;
        }
        return (TextureKeyframeController)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static Bone getSkeleton(String string2) {
        if (instance == null) {
            return null;
        }
        return (Bone)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static Geometry getGeometry(String string2) {
        if (instance == null) {
            return null;
        }
        return (Geometry)ColladaImporter.instance.resourceLibrary.get(string2);
    }

    public static void cleanUp() {
        if (instance != null) {
            instance.shutdown();
        }
    }

    public void shutdown() {
        instance = null;
    }

    public String getModelAuthor() {
        return this.modelAuthor;
    }

    public String getRevision() {
        return this.revision;
    }

    public String getTool() {
        return this.tool;
    }

    public float getUnitMeter() {
        return this.unitMeter;
    }

    public String getUnitName() {
        return this.unitName;
    }

    public String getAssetInformation() {
        return this.modelAuthor + " " + this.revision + "\n" + this.tool + "\n" + this.unitName + " " + this.unitMeter + "\n" + this.upAxis;
    }

    public void processCollada(COLLADAType cOLLADAType) {
        block63: {
            block62: {
                block61: {
                    Node node;
                    int n;
                    Node node2;
                    block60: {
                        block59: {
                            block58: {
                                block57: {
                                    block56: {
                                        block55: {
                                            block54: {
                                                block53: {
                                                    block52: {
                                                        block51: {
                                                            block50: {
                                                                block49: {
                                                                    if (cOLLADAType.hasasset()) {
                                                                        try {
                                                                            this.processAssetInformation(cOLLADAType.getasset());
                                                                        }
                                                                        catch (Exception exception) {
                                                                            if (squelch) break block49;
                                                                            exception.printStackTrace();
                                                                            ErrorManager.getInstance().addError(Level.WARNING, "Error processing asset information - " + exception, (Throwable)exception);
                                                                        }
                                                                    }
                                                                }
                                                                if (cOLLADAType.hasextra()) {
                                                                    try {
                                                                        ExtraPluginManager.processExtra(cOLLADAType, cOLLADAType.getextra());
                                                                    }
                                                                    catch (Exception exception) {
                                                                        if (squelch) break block50;
                                                                        exception.printStackTrace();
                                                                        ErrorManager.getInstance().addError(Level.WARNING, "Error processing extra information - " + exception, (Throwable)exception);
                                                                    }
                                                                }
                                                            }
                                                            if (cOLLADAType.haslibrary_animations()) {
                                                                try {
                                                                    this.processAnimationLibrary(cOLLADAType.getlibrary_animations());
                                                                }
                                                                catch (Exception exception) {
                                                                    exception.printStackTrace();
                                                                    if (squelch) break block51;
                                                                    ErrorManager.getInstance().addError(Level.WARNING, "Error processing animation information - " + exception, (Throwable)exception);
                                                                }
                                                            }
                                                        }
                                                        if (cOLLADAType.haslibrary_animation_clips() && !squelch) {
                                                            ErrorManager.getInstance().addError(Level.WARNING, "Animation Clips not currently supported");
                                                        }
                                                        if (cOLLADAType.haslibrary_cameras()) {
                                                            try {
                                                                this.processCameraLibrary(cOLLADAType.getlibrary_cameras());
                                                            }
                                                            catch (Exception exception) {
                                                                exception.printStackTrace();
                                                                if (squelch) break block52;
                                                                ErrorManager.getInstance().addError(Level.WARNING, "Error processing camera information - " + exception, (Throwable)exception);
                                                            }
                                                        }
                                                    }
                                                    if (cOLLADAType.haslibrary_force_fields() && !squelch) {
                                                        ErrorManager.getInstance().addError(Level.WARNING, "Forcefields not currently supported");
                                                    }
                                                    if (cOLLADAType.haslibrary_lights()) {
                                                        try {
                                                            this.processLightLibrary(cOLLADAType.getlibrary_lights());
                                                        }
                                                        catch (Exception exception) {
                                                            exception.printStackTrace();
                                                            if (squelch) break block53;
                                                            ErrorManager.getInstance().addError(Level.WARNING, "Error processing light information - " + exception, (Throwable)exception);
                                                        }
                                                    }
                                                }
                                                if (cOLLADAType.haslibrary_nodes() && !squelch) {
                                                    ErrorManager.getInstance().addError(Level.WARNING, "Stand-alone nodes not currently supported");
                                                }
                                                if (cOLLADAType.haslibrary_images()) {
                                                    try {
                                                        this.processImageLibrary(cOLLADAType.getlibrary_images());
                                                    }
                                                    catch (Exception exception) {
                                                        if (squelch) break block54;
                                                        ErrorManager.getInstance().addError(Level.WARNING, "Error processing image library information - " + exception, (Throwable)exception);
                                                    }
                                                }
                                            }
                                            if (cOLLADAType.haslibrary_materials()) {
                                                try {
                                                    this.processMaterialLibrary(cOLLADAType.getlibrary_materials());
                                                }
                                                catch (Exception exception) {
                                                    if (squelch) break block55;
                                                    ErrorManager.getInstance().addError(Level.WARNING, "Error processing material library information - " + exception, (Throwable)exception);
                                                }
                                            }
                                        }
                                        if (cOLLADAType.haslibrary_effects()) {
                                            try {
                                                this.processEffects(cOLLADAType.getlibrary_effects());
                                            }
                                            catch (Exception exception) {
                                                if (squelch) break block56;
                                                exception.printStackTrace();
                                                ErrorManager.getInstance().addError(Level.WARNING, "Error processing effects library information - " + exception, (Throwable)exception);
                                            }
                                        }
                                    }
                                    if (cOLLADAType.haslibrary_geometries()) {
                                        try {
                                            this.processGeometry(cOLLADAType.getlibrary_geometries());
                                        }
                                        catch (Exception exception) {
                                            exception.printStackTrace();
                                            if (squelch) break block57;
                                            ErrorManager.getInstance().addError(Level.WARNING, "Error processing geometry library information - " + exception, (Throwable)exception);
                                            exception.printStackTrace();
                                        }
                                    }
                                }
                                if (cOLLADAType.haslibrary_controllers()) {
                                    try {
                                        this.processControllerLibrary(cOLLADAType.getlibrary_controllers());
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                        if (squelch) break block58;
                                        exception.printStackTrace();
                                        ErrorManager.getInstance().addError(Level.WARNING, "Error processing controller library information - " + exception, (Throwable)exception);
                                    }
                                }
                            }
                            if (cOLLADAType.haslibrary_visual_scenes()) {
                                try {
                                    this.processVisualSceneLibrary(cOLLADAType.getlibrary_visual_scenes());
                                }
                                catch (Exception exception) {
                                    if (squelch) break block59;
                                    exception.printStackTrace();
                                    ErrorManager.getInstance().addError(Level.WARNING, "Error processing visual scene library information - " + exception, (Throwable)exception);
                                }
                            }
                        }
                        if (cOLLADAType.haslibrary_physics_scenes()) {
                            try {
                                node2 = cOLLADAType.getlibrary_physics_scenes();
                                for (n = 0; n < ((library_physics_scenesType)node2).getphysics_sceneCount(); ++n) {
                                    node = ((library_physics_scenesType)node2).getphysics_sceneAt(n);
                                    ColladaImporter.put(((physics_sceneType)node).getid().toString(), node);
                                }
                            }
                            catch (Exception exception) {
                                if (squelch) break block60;
                                exception.printStackTrace();
                                ErrorManager.getInstance().addError(Level.WARNING, "Error processing physics scene library information - " + exception, (Throwable)exception);
                            }
                        }
                    }
                    if (cOLLADAType.haslibrary_physics_models()) {
                        try {
                            node2 = cOLLADAType.getlibrary_physics_models();
                            for (n = 0; n < ((library_physics_modelsType)node2).getphysics_modelCount(); ++n) {
                                node = ((library_physics_modelsType)node2).getphysics_modelAt(n);
                                ColladaImporter.put(((physics_modelType)node).getid().toString(), node);
                            }
                        }
                        catch (Exception exception) {
                            if (squelch) break block61;
                            exception.printStackTrace();
                            ErrorManager.getInstance().addError(Level.WARNING, "Error processing physics model library information - " + exception, (Throwable)exception);
                        }
                    }
                }
                if (cOLLADAType.hasscene()) {
                    try {
                        this.processScene(cOLLADAType.getscene());
                    }
                    catch (Exception exception) {
                        if (squelch) break block62;
                        exception.printStackTrace();
                        ErrorManager.getInstance().addError(Level.WARNING, "Error processing scene information - " + exception, (Throwable)exception);
                    }
                }
            }
            try {
                this.optimizeGeometry();
            }
            catch (Exception exception) {
                if (squelch) break block63;
                exception.printStackTrace();
                ErrorManager.getInstance().addError(Level.WARNING, "Error optimizing geometry - " + exception, (Throwable)exception);
            }
        }
    }

    private void optimizeGeometry() {
        for (String string2 : this.resourceLibrary.keySet()) {
            Object object = this.resourceLibrary.get(string2);
            if (!(object instanceof TriMesh)) continue;
            TriMesh triMesh = (TriMesh)object;
            int n = 7;
            if (triMesh.getParent() instanceof SkinNode) {
                SkinNode skinNode = (SkinNode)triMesh.getParent();
                skinNode.updateGeometricState(100.0f, true);
                skinNode.revertToBind();
                skinNode.remapInfluences(GeometryTool.minimizeVerts((TriMesh)triMesh, (int)n));
                skinNode.regenInfluenceOffsets();
                skinNode.updateSkin();
                continue;
            }
            GeometryTool.minimizeVerts((TriMesh)triMesh, (int)n);
        }
    }

    private void processLightLibrary(library_lightsType library_lightsType2) throws Exception {
        if (library_lightsType2.haslight()) {
            for (int i = 0; i < library_lightsType2.getlightCount(); ++i) {
                this.processLight(library_lightsType2.getlightAt(i));
            }
        }
    }

    private void processLight(lightType lightType2) throws Exception {
        technique_commonType4 technique_commonType42 = lightType2.gettechnique_common();
        DirectionalLight directionalLight = null;
        if (technique_commonType42.hasdirectional()) {
            directionalLight = new DirectionalLight();
            directionalLight.setDiffuse(this.getLightColor(technique_commonType42.getdirectional().getcolor()));
        } else if (technique_commonType42.haspoint()) {
            directionalLight = new PointLight();
            directionalLight.setDiffuse(this.getLightColor(technique_commonType42.getpoint().getcolor()));
            directionalLight.setAttenuate(true);
            directionalLight.setConstant(Float.parseFloat(technique_commonType42.getpoint().getconstant_attenuation().getValue().toString()));
            directionalLight.setLinear(Float.parseFloat(technique_commonType42.getpoint().getlinear_attenuation().getValue().toString()));
            directionalLight.setQuadratic(Float.parseFloat(technique_commonType42.getpoint().getquadratic_attenuation().getValue().toString()));
        } else if (technique_commonType42.hasspot()) {
            directionalLight = new SpotLight();
            directionalLight.setDiffuse(this.getLightColor(technique_commonType42.getspot().getcolor()));
            directionalLight.setAttenuate(true);
            directionalLight.setConstant(Float.parseFloat(technique_commonType42.getspot().getconstant_attenuation().getValue().toString()));
            directionalLight.setLinear(Float.parseFloat(technique_commonType42.getspot().getlinear_attenuation().getValue().toString()));
            directionalLight.setQuadratic(Float.parseFloat(technique_commonType42.getspot().getquadratic_attenuation().getValue().toString()));
            ((SpotLight)directionalLight).setAngle(Float.parseFloat(technique_commonType42.getspot().getfalloff_angle().getValue().toString()));
            ((SpotLight)directionalLight).setExponent(Float.parseFloat(technique_commonType42.getspot().getfalloff_exponent().getValue().toString()));
        }
        if (directionalLight != null) {
            directionalLight.getSpecular().set(0.0f, 0.0f, 0.0f, 1.0f);
            if (technique_commonType42.hasambient()) {
                directionalLight.setAmbient(this.getLightColor(technique_commonType42.getambient().getcolor()));
            } else {
                directionalLight.getAmbient().set(0.0f, 0.0f, 0.0f, 1.0f);
            }
            directionalLight.setEnabled(true);
            LightNode lightNode = new LightNode(lightType2.getid().toString(), DisplaySystem.getDisplaySystem().getRenderer().createLightState());
            lightNode.setLight((Light)directionalLight);
            if (this.lightNodeNames == null) {
                this.lightNodeNames = new ArrayList();
            }
            this.lightNodeNames.add(lightNode.getName());
            ColladaImporter.put(lightNode.getName(), lightNode);
        }
    }

    private ColorRGBA getLightColor(TargetableFloat3 targetableFloat3) {
        StringTokenizer stringTokenizer = new StringTokenizer(targetableFloat3.getValue().toString());
        ColorRGBA colorRGBA = new ColorRGBA(Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), Float.parseFloat(stringTokenizer.nextToken()), 1.0f);
        return colorRGBA;
    }

    public void processScene(sceneType sceneType2) throws Exception {
        Object object;
        String string2;
        int n;
        if (sceneType2.hasinstance_visual_scene()) {
            for (n = 0; n < sceneType2.getinstance_visual_sceneCount(); ++n) {
                string2 = sceneType2.getinstance_visual_sceneAt(n).geturl().toString().substring(1);
                object = (com.jme.scene.Node)this.resourceLibrary.get(string2);
                if (object == null) continue;
                this.model.attachChild((Spatial)object);
            }
        }
        if (sceneType2.hasinstance_physics_scene()) {
            for (n = 0; n < sceneType2.getinstance_physics_sceneCount(); ++n) {
                string2 = sceneType2.getinstance_physics_sceneAt(n).geturl().toString().substring(1);
                object = (physics_sceneType)this.resourceLibrary.get(string2);
                if (object == null) continue;
                this.processPhysicsScene((physics_sceneType)object);
            }
        }
    }

    private void processPhysicsScene(physics_sceneType physics_sceneType2) throws Exception {
        if (physics_sceneType2.hasinstance_physics_model()) {
            for (int i = 0; i < physics_sceneType2.getinstance_physics_modelCount(); ++i) {
                String string2;
                com.jme.scene.Node node;
                String string3;
                Spatial spatial;
                instance_physics_modelType instance_physics_modelType2 = physics_sceneType2.getinstance_physics_modelAt(i);
                String string4 = instance_physics_modelType2.geturl().toString().substring(1);
                physics_modelType physics_modelType2 = (physics_modelType)this.resourceLibrary.get(string4);
                if (physics_modelType2 != null) {
                    this.processPhysicsModel(physics_modelType2);
                }
                if (!instance_physics_modelType2.hasinstance_rigid_body() || (spatial = (Spatial)this.resourceLibrary.get(string3 = instance_physics_modelType2.getinstance_rigid_body().getbody().toString())) == null || (node = (com.jme.scene.Node)this.resourceLibrary.get(string2 = instance_physics_modelType2.getinstance_rigid_body().gettarget().toString().substring(1))) == null) continue;
                node.setUserData("COLLISION", (Savable)spatial);
            }
        }
    }

    private void processPhysicsModel(physics_modelType physics_modelType2) throws Exception {
        if (physics_modelType2.hasrigid_body()) {
            for (int i = 0; i < physics_modelType2.getrigid_bodyCount(); ++i) {
                rigid_bodyType rigid_bodyType2 = physics_modelType2.getrigid_bodyAt(i);
                String string2 = rigid_bodyType2.getsid().toString();
                if (!rigid_bodyType2.hastechnique_common() || !rigid_bodyType2.gettechnique_common().hasshape()) continue;
                for (int j = 0; j < rigid_bodyType2.gettechnique_common().getshapeCount(); ++j) {
                    String string3;
                    Spatial spatial;
                    shapeType2 shapeType22 = rigid_bodyType2.gettechnique_common().getshapeAt(j);
                    if (!shapeType22.hasinstance_geometry() || (spatial = (Spatial)this.resourceLibrary.get(string3 = shapeType22.getinstance_geometry().geturl().toString().substring(1))) == null) continue;
                    ColladaImporter.put(string2, spatial);
                }
            }
        }
    }

    private void processSource(sourceType sourceType2) throws Exception {
        if (sourceType2.hasfloat_array()) {
            float[] fArray = this.processFloatArray(sourceType2.getfloat_array());
            if (sourceType2.hastechnique_common()) {
                paramType3 paramType32 = sourceType2.gettechnique_common().getaccessor().getparam();
                if ("TIME".equals(paramType32.getname().toString())) {
                    ColladaImporter.put(sourceType2.getid().toString(), fArray);
                } else if ("float4x4".equals(paramType32.gettype().toString())) {
                    Matrix4f[] matrix4fArray = new Matrix4f[fArray.length / 16];
                    for (int i = 0; i < matrix4fArray.length; ++i) {
                        matrix4fArray[i] = new Matrix4f();
                        float[] fArray2 = new float[16];
                        for (int j = 0; j < 16; ++j) {
                            fArray2[j] = fArray[16 * i + j];
                        }
                        matrix4fArray[i].set(fArray2, true);
                    }
                    ColladaImporter.put(sourceType2.getid().toString(), matrix4fArray);
                } else if ("ROTX.ANGLE".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray3 = new float[fArray.length];
                        for (int i = 0; i < fArray3.length; ++i) {
                            fArray3[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray3);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if ("ROTY.ANGLE".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray4 = new float[fArray.length];
                        for (int i = 0; i < fArray4.length; ++i) {
                            fArray4[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray4);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if ("ROTZ.ANGLE".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray5 = new float[fArray.length];
                        for (int i = 0; i < fArray5.length; ++i) {
                            fArray5[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray5);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if ("TRANS.X".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray6 = new float[fArray.length];
                        for (int i = 0; i < fArray6.length; ++i) {
                            fArray6[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray6);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if ("TRANS.Y".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray7 = new float[fArray.length];
                        for (int i = 0; i < fArray7.length; ++i) {
                            fArray7[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray7);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if ("TRANS.Z".equals(paramType32.getname().toString())) {
                    if ("float".equals(paramType32.gettype().toString())) {
                        float[] fArray8 = new float[fArray.length];
                        for (int i = 0; i < fArray8.length; ++i) {
                            fArray8[i] = fArray[i];
                        }
                        ColladaImporter.put(sourceType2.getid().toString(), fArray8);
                    } else if (!squelch) {
                        ErrorManager.getInstance().addError(Level.WARNING, paramType32.gettype() + " not yet supported " + "for animation transforms.");
                    }
                } else if (!squelch) {
                    ErrorManager.getInstance().addError(Level.WARNING, paramType32.getname() + " not yet supported " + "for animation source.");
                }
            }
        } else if (sourceType2.hasName_array()) {
            int[] nArray = this.processInterpolationArray(sourceType2.getName_array());
            ColladaImporter.put(sourceType2.getid().toString(), nArray);
        }
    }

    private int[] processInterpolationArray(Name_arrayType name_arrayType) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(name_arrayType.getValue().toString());
        int[] nArray = new int[name_arrayType.getcount().intValue()];
        String string2 = null;
        for (int i = 0; i < nArray.length; ++i) {
            string2 = stringTokenizer.nextToken();
            if ("LINEAR".equals(string2)) {
                nArray[i] = 0;
                continue;
            }
            if (!"BEZIER".equals(string2)) continue;
            nArray[i] = 1;
        }
        return nArray;
    }

    private float[] processFloatArray(float_arrayType float_arrayType2) throws Exception {
        StringTokenizer stringTokenizer = new StringTokenizer(float_arrayType2.getValue().toString());
        float[] fArray = new float[float_arrayType2.getcount().intValue()];
        for (int i = 0; i < fArray.length; ++i) {
            fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
        }
        return fArray;
    }

    private void processAssetInformation(assetType assetType2) throws Exception {
        if (assetType2.hascontributor()) {
            if (assetType2.getcontributor().hasauthor()) {
                this.modelAuthor = assetType2.getcontributor().getauthor().toString();
            }
            if (assetType2.getcontributor().hasauthoring_tool()) {
                this.tool = assetType2.getcontributor().getauthoring_tool().toString();
            }
        }
        if (assetType2.hasrevision()) {
            this.revision = assetType2.getrevision().toString();
        }
        this.unitName = assetType2.getunit().getname().toString();
        this.unitMeter = assetType2.getunit().getmeter().floatValue();
        this.upAxis = assetType2.getup_axis().getValue();
    }

    private void processAnimationLibrary(library_animationsType library_animationsType2) throws Exception {
        if (library_animationsType2.hasanimation()) {
            if (this.controllerNames == null) {
                this.controllerNames = new ArrayList();
            }
            for (int i = 0; i < library_animationsType2.getanimationCount(); ++i) {
                BoneAnimation boneAnimation = this.processAnimation(library_animationsType2.getanimationAt(i));
                boneAnimation.setInterpolate(false);
                boneAnimation.optimize(true);
                ColladaImporter.put(boneAnimation.getName(), boneAnimation);
                this.controllerNames.add(boneAnimation.getName());
                if (!library_animationsType2.getanimationAt(i).hasextra()) continue;
                ExtraPluginManager.processExtra(boneAnimation, library_animationsType2.getanimationAt(i).getextra());
            }
        }
    }

    private BoneAnimation processAnimation(animationType animationType2) throws Exception {
        String string2;
        String string3;
        int n;
        BoneAnimation boneAnimation = new BoneAnimation(animationType2.getid().toString());
        BoneTransform boneTransform = new BoneTransform();
        boneAnimation.setInterpolate(true);
        if (animationType2.hassource()) {
            for (int i = 0; i < animationType2.getsourceCount(); ++i) {
                this.processSource(animationType2.getsourceAt(i));
            }
        }
        Object object = null;
        Object object2 = null;
        Object object3 = null;
        Object object4 = null;
        Object object5 = null;
        Object object6 = null;
        boolean bl = false;
        if (animationType2.hassampler()) {
            Matrix4f[] matrix4fArray;
            for (n = 0; n < animationType2.getsamplerCount(); ++n) {
                for (int i = 0; i < animationType2.getsamplerAt(n).getinputCount(); ++i) {
                    Object object7;
                    if ("INPUT".equals(animationType2.getsamplerAt(n).getinputAt(i).getsemantic().toString())) {
                        string3 = animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().substring(1);
                        object7 = (float[])this.resourceLibrary.get(string3);
                        if (object7 == null) {
                            ErrorManager.getInstance().addError(Level.WARNING, "Animation source invalid: " + string3);
                            continue;
                        }
                        boneAnimation.setTimes(object7);
                        boneAnimation.setStartFrame(0);
                        boneAnimation.setEndFrame(((float[])object7).length - 1);
                        continue;
                    }
                    if ("OUTPUT".equals(animationType2.getsamplerAt(n).getinputAt(i).getsemantic().toString())) {
                        string3 = animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().substring(1);
                        object7 = this.resourceLibrary.get(string3);
                        if (object7 == null) {
                            ErrorManager.getInstance().addError(Level.WARNING, "Animation source invalid: " + string3);
                            continue;
                        }
                        if (object7 instanceof Matrix4f[]) {
                            Matrix4f[] matrix4fArray2 = (Matrix4f[])object7;
                            boneTransform.setTransforms(matrix4fArray2);
                            bl = true;
                            continue;
                        }
                        if (!(object7 instanceof float[])) continue;
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Rotate-X-")) {
                            object = object7;
                            continue;
                        }
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Rotate-Y-")) {
                            object2 = object7;
                            continue;
                        }
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Rotate-Z-")) {
                            object3 = object7;
                            continue;
                        }
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Translate-X-")) {
                            object4 = object7;
                            continue;
                        }
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Translate-Y-")) {
                            object5 = object7;
                            continue;
                        }
                        if (animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().contains("Translate-Z-")) {
                            object6 = object7;
                            continue;
                        }
                        if (squelch) continue;
                        ErrorManager.getInstance().addError(Level.WARNING, "Not sure what this sampler is.");
                        continue;
                    }
                    if (!"INTERPOLATION".equals(animationType2.getsamplerAt(n).getinputAt(i).getsemantic().toString())) continue;
                    string3 = animationType2.getsamplerAt(n).getinputAt(i).getsource().toString().substring(1);
                    object7 = (int[])this.resourceLibrary.get(string3);
                    if (object7 == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Animation source invalid: " + string3);
                        continue;
                    }
                    boneAnimation.setInterpolationTypes((int[])object7);
                }
            }
            if (!bl && (matrix4fArray = this.generateTransforms((float[])object, (float[])object2, (float[])object3, (float[])object4, (float[])object5, (float[])object6)) != null) {
                boneTransform.setTransforms(matrix4fArray);
            }
        }
        if (animationType2.haschannel() && (string2 = animationType2.getchannel().gettarget().toString()).contains("/")) {
            String string4 = string2.substring(0, animationType2.getchannel().gettarget().toString().indexOf(47));
            boneTransform.setBoneId(string4);
            boneTransform.getBoneId();
            string3 = (Bone)this.resourceLibrary.get(string4);
            if (string3 != null) {
                boneTransform.setBone((Bone)string3);
            }
            boneAnimation.addBoneTransforms(boneTransform);
        }
        if (animationType2.hasanimation()) {
            for (n = 0; n < animationType2.getanimationCount(); ++n) {
                boneAnimation.addBoneAnimation(this.processAnimation(animationType2.getanimationAt(n)));
            }
        }
        return boneAnimation;
    }

    private Matrix4f[] generateTransforms(float[] fArray, float[] fArray2, float[] fArray3, float[] fArray4, float[] fArray5, float[] fArray6) {
        Quaternion quaternion = new Quaternion();
        int n = 0;
        if (fArray != null) {
            n = fArray.length;
        } else if (fArray4 != null) {
            n = fArray4.length;
        }
        Matrix4f[] matrix4fArray = new Matrix4f[n];
        float[] fArray7 = new float[3];
        for (int i = 0; i < matrix4fArray.length; ++i) {
            fArray7[2] = 0.0f;
            fArray7[1] = 0.0f;
            fArray7[0] = 0.0f;
            if (fArray != null) {
                fArray7[0] = fArray[i];
            }
            if (fArray2 != null) {
                fArray7[1] = fArray2[i];
            }
            if (fArray3 != null) {
                fArray7[2] = fArray3[i];
            }
            quaternion.fromAngles(fArray7);
            matrix4fArray[i] = quaternion.toRotationMatrix(new Matrix4f());
            if (fArray4 != null) {
                matrix4fArray[i].m03 = fArray4[i];
            }
            if (fArray4 != null) {
                matrix4fArray[i].m13 = fArray5[i];
            }
            if (fArray4 == null) continue;
            matrix4fArray[i].m23 = fArray6[i];
        }
        return matrix4fArray;
    }

    private void processCameraLibrary(library_camerasType library_camerasType2) throws Exception {
        if (library_camerasType2.hascamera()) {
            for (int i = 0; i < library_camerasType2.getcameraCount(); ++i) {
                this.processCamera(library_camerasType2.getcameraAt(i));
            }
        }
    }

    private void processCamera(cameraType cameraType2) throws Exception {
        Node node;
        opticsType opticsType2 = cameraType2.getoptics();
        technique_commonType2 technique_commonType22 = opticsType2.gettechnique_common();
        Renderer renderer = DisplaySystem.getDisplaySystem().getRenderer();
        int n = renderer.getWidth();
        int n2 = renderer.getHeight();
        Camera camera = renderer.createCamera(n, n2);
        float f = camera.getFrustumNear();
        float f2 = camera.getFrustumFar();
        float f3 = (float)n / (float)n2;
        if (technique_commonType22.hasorthographic()) {
            node = technique_commonType22.getorthographic();
            float f4 = 1.0f;
            float f5 = 1.0f;
            if (((orthographicType)node).hasznear()) {
                f = Float.parseFloat(((orthographicType)node).getznear().getValue().toString());
            }
            if (((orthographicType)node).haszfar()) {
                f2 = Float.parseFloat(((orthographicType)node).getzfar().getValue().toString());
            }
            if (((orthographicType)node).hasxmag() && ((orthographicType)node).hasymag()) {
                f4 = Float.parseFloat(((orthographicType)node).getxmag().getValue().toString());
                f5 = Float.parseFloat(((orthographicType)node).getymag().getValue().toString());
            } else {
                if (((orthographicType)node).hasaspect_ratio()) {
                    f3 = Float.parseFloat(((orthographicType)node).getaspect_ratio().getValue().toString());
                }
                if (((orthographicType)node).hasxmag()) {
                    assert (!((orthographicType)node).hasymag());
                    f4 = Float.parseFloat(((orthographicType)node).getxmag().getValue().toString());
                    f5 = f4 / f3;
                } else {
                    assert (((orthographicType)node).hasymag());
                    f5 = Float.parseFloat(((orthographicType)node).getymag().getValue().toString());
                    f4 = f5 * f3;
                }
            }
            camera.setParallelProjection(true);
            camera.setFrustum(f, f2, -f4, f4, -f5, f5);
        } else {
            assert (technique_commonType22.hasperspective());
            node = technique_commonType22.getperspective();
            float f6 = 1.0f;
            float f7 = 1.0f;
            if (((perspectiveType)node).hasznear()) {
                f = Float.parseFloat(((perspectiveType)node).getznear().getValue().toString());
            }
            if (((perspectiveType)node).haszfar()) {
                f2 = Float.parseFloat(((perspectiveType)node).getzfar().getValue().toString());
            }
            if (((perspectiveType)node).hasxfov() && ((perspectiveType)node).hasyfov()) {
                f6 = Float.parseFloat(((perspectiveType)node).getxfov().getValue().toString());
                f7 = Float.parseFloat(((perspectiveType)node).getyfov().getValue().toString());
            } else {
                if (((perspectiveType)node).hasaspect_ratio()) {
                    f3 = Float.parseFloat(((perspectiveType)node).getaspect_ratio().getValue().toString());
                }
                if (((perspectiveType)node).hasxfov()) {
                    assert (!((perspectiveType)node).hasyfov());
                    f6 = Float.parseFloat(((perspectiveType)node).getxfov().getValue().toString());
                    f7 = f6 / f3;
                } else {
                    assert (((perspectiveType)node).hasyfov());
                    f7 = Float.parseFloat(((perspectiveType)node).getyfov().getValue().toString());
                    f6 = f7 * f3;
                }
            }
            camera.setParallelProjection(false);
            camera.setFrustumPerspective(f7, f3, f, f2);
        }
        if (this.cameraNodeNames == null) {
            this.cameraNodeNames = new ArrayList();
        }
        node = new CameraNode(cameraType2.getid().toString(), camera);
        if ("X_UP".equals(this.upAxis)) {
            node.setLocalRotation(new Quaternion(1.0f, 0.0f, 0.0f, 0.0f));
        } else if ("Y_UP".equals(this.upAxis)) {
            node.setLocalRotation(new Quaternion(0.0f, 1.0f, 0.0f, 0.0f));
        } else if ("Z_UP".equals(this.upAxis)) {
            node.setLocalRotation(new Quaternion(0.0f, 0.0f, 1.0f, 0.0f));
        }
        this.cameraNodeNames.add(node.getName());
        ColladaImporter.put(node.getName(), node);
    }

    private void processImageLibrary(library_imagesType library_imagesType2) throws Exception {
        if (library_imagesType2.hasimage()) {
            for (int i = 0; i < library_imagesType2.getimageCount(); ++i) {
                this.processImage(library_imagesType2.getimageAt(i));
            }
        }
    }

    private void processImage(imageType imageType2) throws Exception {
        if (imageType2.hasdata() && !squelch) {
            ErrorManager.getInstance().addError(Level.WARNING, "Raw data images not supported.");
        }
        if (imageType2.hasinit_from()) {
            ColladaImporter.put(imageType2.getid().toString(), this.getFileName(imageType2.getinit_from().toString()));
        }
    }

    private String getFileName(String string2) {
        int n = string2.lastIndexOf(47) + 1;
        int n2 = string2.lastIndexOf(92) + 1;
        int n3 = Math.max(n, n2);
        return string2.substring(n3);
    }

    private void processMaterialLibrary(library_materialsType library_materialsType2) throws Exception {
        if (library_materialsType2.hasmaterial()) {
            for (int i = 0; i < library_materialsType2.getmaterialCount(); ++i) {
                this.processMaterial(library_materialsType2.getmaterialAt(i));
            }
        }
    }

    private void processMaterial(materialType materialType2) throws Exception {
        ColladaMaterial colladaMaterial = new ColladaMaterial();
        String string2 = null;
        if (materialType2.hasinstance_effect()) {
            string2 = materialType2.getinstance_effect().geturl().toString();
            if (string2.startsWith("#")) {
                string2 = string2.substring(1);
            }
            ColladaImporter.put(string2, colladaMaterial);
            ColladaImporter.put(materialType2.getid().toString(), string2);
        }
        if (materialType2.hasextra()) {
            ExtraPluginManager.processExtra(colladaMaterial, materialType2.getextra());
        }
    }

    private void processEffects(library_effectsType library_effectsType2) throws Exception {
        if (library_effectsType2.haseffect()) {
            for (int i = 0; i < library_effectsType2.geteffectCount(); ++i) {
                String string2 = library_effectsType2.geteffectAt(i).getid().toString();
                ColladaMaterial colladaMaterial = (ColladaMaterial)this.resourceLibrary.get(string2);
                if (colladaMaterial == null) continue;
                this.fillMaterial(library_effectsType2.geteffectAt(i), colladaMaterial);
            }
        }
    }

    private void fillMaterial(effectType effectType2, ColladaMaterial colladaMaterial) throws Exception {
        int n;
        if (effectType2.hasprofile_COMMON()) {
            for (n = 0; n < effectType2.getprofile_COMMON().getnewparamCount(); ++n) {
                this.processNewParam(effectType2.getprofile_COMMON().getnewparamAt(n), colladaMaterial);
            }
            for (n = 0; n < effectType2.getprofile_COMMON().gettechniqueCount(); ++n) {
                this.processTechniqueCOMMON(effectType2.getprofile_COMMON().gettechniqueAt(n), colladaMaterial);
            }
        }
        if (effectType2.hasprofile_GLSL()) {
            for (n = 0; n < effectType2.getprofile_GLSL().gettechniqueCount(); ++n) {
                this.processTechniqueGLSL(effectType2.getprofile_GLSL().gettechniqueAt(n), colladaMaterial);
            }
        }
    }

    private void processNewParam(common_newparam_type common_newparam_type2, ColladaMaterial colladaMaterial) throws Exception {
        if (common_newparam_type2.hassampler2D()) {
            this.processSampler2D(common_newparam_type2.getsid().toString(), common_newparam_type2.getsampler2D(), colladaMaterial);
        }
        if (common_newparam_type2.hassurface()) {
            this.processSurface(common_newparam_type2.getsid().toString(), common_newparam_type2.getsurface());
        }
    }

    private void processSampler2D(String string2, fx_sampler2D_common fx_sampler2D_common2, ColladaMaterial colladaMaterial) throws Exception {
        if (fx_sampler2D_common2.hasmagfilter()) {
            colladaMaterial.magFilter = fx_sampler2D_common2.getmagfilter().getValue().toString();
        }
        if (fx_sampler2D_common2.hasminfilter()) {
            colladaMaterial.minFilter = fx_sampler2D_common2.getminfilter().getValue().toString();
        }
        ColladaImporter.put(string2, fx_sampler2D_common2.getsource().getValue().toString());
    }

    private void processSurface(String string2, fx_surface_common fx_surface_common2) throws Exception {
        ColladaImporter.put(string2, fx_surface_common2.getinit_from().getValue().toString());
    }

    private void processTechniqueGLSL(techniqueType4 techniqueType42, ColladaMaterial colladaMaterial) throws Exception {
        if (techniqueType42.haspass()) {
            for (int i = 0; i < techniqueType42.getpassCount(); ++i) {
                this.processPassGLSL(techniqueType42.getpassAt(i), colladaMaterial);
            }
        }
    }

    private void processPassGLSL(passType3 passType32, ColladaMaterial colladaMaterial) throws Exception {
        Object object;
        int n;
        ClipState clipState;
        if (passType32.hasclip_plane()) {
            clipState = (ClipState)colladaMaterial.getState(16);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createClipState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getclip_plane().hasindex() && passType32.getclip_plane().hasvalue2()) {
                n = passType32.getclip_plane().getindex().intValue();
                object = new StringTokenizer(passType32.getclip_plane().getvalue2().toString());
                float[] fArray = new float[4];
                for (int i = 0; i < 4; ++i) {
                    fArray[i] = Float.parseFloat(((StringTokenizer)object).nextToken());
                }
                clipState.setClipPlaneEquation(n, (double)fArray[0], (double)fArray[1], (double)fArray[2], (double)fArray[3]);
            }
        }
        if (passType32.hasclip_plane_enable()) {
            clipState = (ClipState)colladaMaterial.getState(16);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createClipState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getclip_plane_enable().hasindex() && passType32.getclip_plane_enable().hasvalue2()) {
                n = passType32.getclip_plane().getindex().intValue();
                clipState.setEnableClipPlane(n, passType32.getclip_plane_enable().getvalue2().booleanValue());
            }
        }
        if (passType32.hascolor_mask()) {
            clipState = (ColorMaskState)colladaMaterial.getState(15);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createColorMaskState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getcolor_mask().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getcolor_mask().getvalue2().toString());
                object = new boolean[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Boolean.parseBoolean(stringTokenizer.nextToken());
                }
                clipState.setRed((boolean)object[0]);
                clipState.setGreen((boolean)object[1]);
                clipState.setBlue((boolean)object[2]);
                clipState.setAlpha((boolean)object[3]);
            }
        }
        if (passType32.hasdither_enable()) {
            clipState = (DitherState)colladaMaterial.getState(1);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createDitherState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getdither_enable().hasvalue2()) {
                clipState.setEnabled(passType32.getdither_enable().getvalue2().booleanValue());
            }
        }
        if (passType32.hasdepth_func()) {
            clipState = (ZBufferState)colladaMaterial.getState(8);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getdepth_func().hasvalue2()) {
                String string2 = passType32.getdepth_func().getvalue2().toString();
                if ("NEVER".equals(string2)) {
                    clipState.setFunction(0);
                } else if ("LESS".equals(string2)) {
                    clipState.setFunction(1);
                } else if ("LEQUAL".equals(string2)) {
                    clipState.setFunction(3);
                } else if ("EQUAL".equals(string2)) {
                    clipState.setFunction(2);
                } else if ("GREATER".equals(string2)) {
                    clipState.setFunction(4);
                } else if ("NOTEQUAL".equals(string2)) {
                    clipState.setFunction(5);
                } else if ("GEQUAL".equals(string2)) {
                    clipState.setFunction(6);
                } else if ("ALWAYS".equals(string2)) {
                    clipState.setFunction(7);
                }
            }
        }
        if (passType32.hasdepth_mask()) {
            clipState = (ZBufferState)colladaMaterial.getState(8);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getdepth_mask().hasvalue2()) {
                clipState.setWritable(passType32.getdepth_mask().getvalue2().booleanValue());
            }
        }
        if (passType32.hasdepth_test_enable()) {
            clipState = (ZBufferState)colladaMaterial.getState(8);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getdepth_test_enable().hasvalue2()) {
                clipState.setEnabled(passType32.getdepth_test_enable().getvalue2().booleanValue());
            }
        }
        if (passType32.hascolor_material()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getcolor_material().hasface()) {
                String string3 = passType32.getcolor_material().getface().getvalue2().toString();
                if ("FRONT".equals(string3)) {
                    clipState.setMaterialFace(0);
                } else if ("BACK".equals(string3)) {
                    clipState.setMaterialFace(1);
                } else if ("FRONT_AND_BACK".equals(string3)) {
                    clipState.setMaterialFace(2);
                }
            }
            if (passType32.getcolor_material().hasmode()) {
                String string4 = passType32.getcolor_material().getmode().getvalue2().toString();
                if ("AMBIENT".equals(string4)) {
                    clipState.setColorMaterial(1);
                } else if ("EMISSION".equals(string4)) {
                    clipState.setColorMaterial(5);
                } else if ("DIFFUSE".equals(string4)) {
                    clipState.setColorMaterial(2);
                } else if ("SPECULAR".equals(string4)) {
                    clipState.setColorMaterial(4);
                } else if ("AMBIENT_AND_DIFFUSE".equals(string4)) {
                    clipState.setColorMaterial(3);
                }
            }
        }
        if (passType32.hasfog_color()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_color().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getfog_color().getvalue2().toString());
                object = new float[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                clipState.setColor(new ColorRGBA((float)object[0], (float)object[1], (float)object[2], (float)object[3]));
            }
        }
        if (passType32.hasfog_density()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_density().hasvalue2()) {
                clipState.setDensity(passType32.getfog_density().getvalue2().floatValue());
            }
        }
        if (passType32.hasfog_enable()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_enable().hasvalue2()) {
                clipState.setEnabled(passType32.getfog_enable().getvalue2().booleanValue());
            }
        }
        if (passType32.hasfog_end()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_end().hasvalue2()) {
                clipState.setEnd(passType32.getfog_end().getvalue2().floatValue());
            }
        }
        if (passType32.hasfog_mode()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_mode().hasvalue2()) {
                String string5 = passType32.getfog_mode().getvalue2().toString();
                if ("LINEAR".equals(string5)) {
                    clipState.setDensityFunction(0);
                } else if ("EXP".equals(string5)) {
                    clipState.setDensityFunction(1);
                } else if ("EXP2".equals(string5)) {
                    clipState.setDensityFunction(2);
                }
            }
        }
        if (passType32.hasfog_start()) {
            clipState = (FogState)colladaMaterial.getState(2);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createFogState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getfog_start().hasvalue2()) {
                clipState.setStart(passType32.getfog_start().getvalue2().floatValue());
            }
        }
        if (passType32.hasalpha_test_enable()) {
            clipState = (AlphaState)colladaMaterial.getState(0);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                colladaMaterial.setState((RenderState)clipState);
            }
            clipState.setTestEnabled(passType32.getalpha_test_enable().getvalue2().booleanValue());
        }
        if (passType32.hasalpha_func()) {
            clipState = (AlphaState)colladaMaterial.getState(0);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getalpha_func().hasfunc()) {
                String string6 = passType32.getalpha_func().getfunc().getvalue2().toString();
                if ("NEVER".equals(string6)) {
                    clipState.setTestFunction(0);
                } else if ("LESS".equals(string6)) {
                    clipState.setTestFunction(1);
                } else if ("LEQUAL".equals(string6)) {
                    clipState.setTestFunction(3);
                } else if ("EQUAL".equals(string6)) {
                    clipState.setTestFunction(2);
                } else if ("GREATER".equals(string6)) {
                    clipState.setTestFunction(4);
                } else if ("NOTEQUAL".equals(string6)) {
                    clipState.setTestFunction(5);
                } else if ("GEQUAL".equals(string6)) {
                    clipState.setTestFunction(6);
                } else if ("ALWAYS".equals(string6)) {
                    clipState.setTestFunction(7);
                }
            }
            if (passType32.getalpha_func().hasvalue2()) {
                clipState.setReference(passType32.getalpha_func().getvalue2().getvalue2().floatValue());
            }
        }
        if (passType32.hasblend_enable()) {
            clipState = (AlphaState)colladaMaterial.getState(0);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                colladaMaterial.setState((RenderState)clipState);
            }
            clipState.setBlendEnabled(passType32.getblend_enable().getvalue2().booleanValue());
        }
        if (passType32.hasblend_func()) {
            clipState = (AlphaState)colladaMaterial.getState(0);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getblend_func().hasdest()) {
                String string7 = passType32.getblend_func().getdest().getvalue2().toString();
                if ("ZERO".equals(string7)) {
                    clipState.setDstFunction(0);
                } else if ("ONE".equals(string7)) {
                    clipState.setDstFunction(1);
                } else if ("SRC_COLOR".equals(string7)) {
                    clipState.setDstFunction(2);
                } else if ("ONE_MINUS_SRC_COLOR".equals(string7)) {
                    clipState.setDstFunction(3);
                } else if ("SRC_ALPHA".equals(string7)) {
                    clipState.setDstFunction(4);
                } else if ("ONE_MINUS_SRC_ALPHA".equals(string7)) {
                    clipState.setDstFunction(5);
                } else if ("DST_ALPHA".equals(string7)) {
                    clipState.setDstFunction(6);
                } else if ("ONE_MINUS_DST_ALPHA".equals(string7)) {
                    clipState.setDstFunction(7);
                } else if ("CONSTANT_COLOR".equals(string7)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("ONE_MINUS_CONSTANT_COLOR".equals(string7)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("CONSTANT_ALPHA".equals(string7)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("ONE_MINUS_CONSTANT_ALPHA".equals(string7)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("SRC_ALPHA_SATURATE".equals(string7)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "saturate not supported");
                }
            }
            if (passType32.getblend_func().hassrc()) {
                String string8 = passType32.getblend_func().getsrc().getvalue2().toString();
                if ("ZERO".equals(string8)) {
                    clipState.setSrcFunction(0);
                } else if ("ONE".equals(string8)) {
                    clipState.setSrcFunction(1);
                } else if ("DEST_COLOR".equals(string8)) {
                    clipState.setSrcFunction(2);
                } else if ("ONE_MINUS_DEST_COLOR".equals(string8)) {
                    clipState.setSrcFunction(3);
                } else if ("SRC_ALPHA".equals(string8)) {
                    clipState.setSrcFunction(4);
                } else if ("ONE_MINUS_SRC_ALPHA".equals(string8)) {
                    clipState.setSrcFunction(5);
                } else if ("DST_ALPHA".equals(string8)) {
                    clipState.setSrcFunction(6);
                } else if ("ONE_MINUS_DST_ALPHA".equals(string8)) {
                    clipState.setSrcFunction(7);
                } else if ("CONSTANT_COLOR".equals(string8)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("ONE_MINUS_CONSTANT_COLOR".equals(string8)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("CONSTANT_ALPHA".equals(string8)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("ONE_MINUS_CONSTANT_ALPHA".equals(string8)) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Constant not supported");
                } else if ("SRC_ALPHA_SATURATE".equals(string8)) {
                    clipState.setSrcFunction(8);
                }
            }
        }
        if (passType32.hascull_face_enable()) {
            clipState = (CullState)colladaMaterial.getState(9);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
                colladaMaterial.setState((RenderState)clipState);
            }
            clipState.setEnabled(passType32.getcull_face_enable().getvalue2().booleanValue());
        }
        if (passType32.hascull_face()) {
            clipState = (CullState)colladaMaterial.getState(9);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createCullState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getcull_face().hasvalue2()) {
                String string9 = passType32.getcull_face().getvalue2().toString();
                if ("FRONT".equals(string9)) {
                    clipState.setCullMode(1);
                } else if ("BACK".equals(string9)) {
                    clipState.setCullMode(2);
                } else if ("FRONT_AND_BACK".equals(string9)) {
                    clipState.setCullMode(3);
                }
            }
        }
        if (passType32.hasshade_model()) {
            clipState = (ShadeState)colladaMaterial.getState(5);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createShadeState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getshade_model().hasvalue2()) {
                String string10 = passType32.getshade_model().getvalue2().toString();
                if ("FLAT".equals(string10)) {
                    clipState.setShade(0);
                } else if ("SMOOTH".equals(string10)) {
                    clipState.setShade(1);
                }
            }
        }
        if (passType32.hasmaterial_ambient()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getmaterial_ambient().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getmaterial_ambient().getvalue2().toString());
                object = new float[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                clipState.setAmbient(new ColorRGBA((float)object[0], (float)object[1], (float)object[2], (float)object[3]));
            }
        }
        if (passType32.hasmaterial_diffuse()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getmaterial_diffuse().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getmaterial_diffuse().getvalue2().toString());
                object = new float[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                clipState.setDiffuse(new ColorRGBA((float)object[0], (float)object[1], (float)object[2], (float)object[3]));
            }
        }
        if (passType32.hasmaterial_emission()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getmaterial_emission().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getmaterial_emission().getvalue2().toString());
                object = new float[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                clipState.setEmissive(new ColorRGBA((float)object[0], (float)object[1], (float)object[2], (float)object[3]));
            }
        }
        if (passType32.hasmaterial_shininess()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getmaterial_shininess().hasvalue2()) {
                clipState.setShininess(passType32.getmaterial_shininess().getvalue2().floatValue());
            }
        }
        if (passType32.hasmaterial_specular()) {
            clipState = (MaterialState)colladaMaterial.getState(4);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
                colladaMaterial.setState((RenderState)clipState);
            }
            if (passType32.getmaterial_specular().hasvalue2()) {
                StringTokenizer stringTokenizer = new StringTokenizer(passType32.getmaterial_specular().getvalue2().toString());
                object = new float[4];
                for (int i = 0; i < 4; ++i) {
                    object[i] = Float.parseFloat(stringTokenizer.nextToken());
                }
                clipState.setSpecular(new ColorRGBA((float)object[0], (float)object[1], (float)object[2], (float)object[3]));
            }
        }
        if (passType32.hasstencil_func()) {
            clipState = (StencilState)colladaMaterial.getState(13);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createStencilState();
            }
            if (passType32.getstencil_func().hasfunc()) {
                String string11 = passType32.getstencil_func().getfunc().toString();
                if ("NEVER".equals(string11)) {
                    clipState.setStencilFunc(0);
                } else if ("LESS".equals(string11)) {
                    clipState.setStencilFunc(1);
                } else if ("LEQUAL".equals(string11)) {
                    clipState.setStencilFunc(2);
                } else if ("EQUAL".equals(string11)) {
                    clipState.setStencilFunc(5);
                } else if ("GREATER".equals(string11)) {
                    clipState.setStencilFunc(3);
                } else if ("NOTEQUAL".equals(string11)) {
                    clipState.setStencilFunc(6);
                } else if ("GEQUAL".equals(string11)) {
                    clipState.setStencilFunc(4);
                }
            }
            if (passType32.getstencil_func().hasref()) {
                clipState.setStencilRef(passType32.getstencil_func().getref().getvalue2().intValue());
            }
            if (passType32.getstencil_func().hasmask()) {
                clipState.setStencilRef(passType32.getstencil_func().getmask().getvalue2().intValue());
            }
        }
        if (passType32.hasstencil_op()) {
            clipState = (StencilState)colladaMaterial.getState(13);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createStencilState();
            }
            if (passType32.getstencil_op().hasfail()) {
                clipState.setStencilOpFail(this.evaluateStencilOp(passType32.getstencil_op().getfail().toString()));
            }
            if (passType32.getstencil_op().haszfail()) {
                clipState.setStencilOpZFail(this.evaluateStencilOp(passType32.getstencil_op().getzfail().toString()));
            }
            if (passType32.getstencil_op().haszpass()) {
                clipState.setStencilOpZPass(this.evaluateStencilOp(passType32.getstencil_op().getzpass().toString()));
            }
        }
        if (passType32.hasstencil_test_enable()) {
            clipState = (StencilState)colladaMaterial.getState(13);
            if (clipState == null) {
                clipState = DisplaySystem.getDisplaySystem().getRenderer().createStencilState();
            }
            clipState.setEnabled(passType32.getstencil_test_enable().getvalue2().booleanValue());
        }
    }

    public int evaluateStencilOp(String string2) {
        if ("KEEP".equals(string2)) {
            return 0;
        }
        if ("ZERO".equals(string2)) {
            return 1;
        }
        if ("REPLACE".equals(string2)) {
            return 2;
        }
        if ("INCR".equals(string2)) {
            return 3;
        }
        if ("DECR".equals(string2)) {
            return 4;
        }
        if ("INVERT".equals(string2)) {
            return 5;
        }
        if ("INCR_WRAP".equals(string2)) {
            return 0;
        }
        if ("DECT_WRAP".equals(string2)) {
            return 0;
        }
        return 0;
    }

    private void processTechniqueCOMMON(techniqueType2 techniqueType22, ColladaMaterial colladaMaterial) throws Exception {
        if (techniqueType22.haslambert()) {
            this.processLambert(techniqueType22.getlambert(), colladaMaterial);
        }
        if (techniqueType22.hasphong()) {
            this.processPhong(techniqueType22.getphong(), colladaMaterial);
        }
    }

    private void processPhong(phongType phongType2, ColladaMaterial colladaMaterial) throws Exception {
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        if (phongType2.hasambient()) {
            materialState.setAmbient(this.getColor(phongType2.getambient().getcolor()));
        }
        if (phongType2.hasdiffuse()) {
            if (phongType2.getdiffuse().hascolor()) {
                materialState.setDiffuse(this.getColor(phongType2.getdiffuse().getcolor()));
            }
            if (phongType2.getdiffuse().hastexture()) {
                for (int i = 0; i < phongType2.getdiffuse().gettextureCount(); ++i) {
                    colladaMaterial.setState((RenderState)this.processTexture(phongType2.getdiffuse().gettextureAt(i), colladaMaterial));
                }
            }
        }
        if (phongType2.hasemission()) {
            materialState.setEmissive(this.getColor(phongType2.getemission().getcolor()));
        }
        if (phongType2.hastransparent()) {
            if (phongType2.gettransparent().hascolor() && !phongType2.gettransparency().getfloat2().getValue().toString().equals("0")) {
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setSrcFunction(3);
                alphaState.setDstFunction(1);
                alphaState.setBlendEnabled(true);
                colladaMaterial.setState((RenderState)alphaState);
            } else if (phongType2.gettransparent().hastexture()) {
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setSrcFunction(4);
                alphaState.setDstFunction(5);
                alphaState.setBlendEnabled(true);
                alphaState.setReference(0.14f);
                alphaState.setTestEnabled(true);
                alphaState.setTestFunction(6);
                colladaMaterial.setState((RenderState)alphaState);
            }
        }
        colladaMaterial.setState((RenderState)materialState);
    }

    private void processLambert(lambertType lambertType2, ColladaMaterial colladaMaterial) throws Exception {
        ShadeState shadeState = DisplaySystem.getDisplaySystem().getRenderer().createShadeState();
        shadeState.setShade(0);
        colladaMaterial.setState((RenderState)shadeState);
        MaterialState materialState = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
        if (lambertType2.hasambient()) {
            materialState.setAmbient(this.getColor(lambertType2.getambient().getcolor()));
        }
        if (lambertType2.hasdiffuse()) {
            if (lambertType2.getdiffuse().hascolor()) {
                materialState.setDiffuse(this.getColor(lambertType2.getdiffuse().getcolor()));
            }
            if (lambertType2.getdiffuse().hastexture()) {
                for (int i = 0; i < lambertType2.getdiffuse().gettextureCount(); ++i) {
                    colladaMaterial.setState((RenderState)this.processTexture(lambertType2.getdiffuse().gettextureAt(i), colladaMaterial));
                }
            }
        }
        if (lambertType2.hasemission()) {
            materialState.setEmissive(this.getColor(lambertType2.getemission().getcolor()));
        }
        colladaMaterial.setState((RenderState)materialState);
        if (lambertType2.hastransparent()) {
            if (lambertType2.gettransparent().hascolor() && !lambertType2.gettransparency().getfloat2().getValue().toString().equals("0")) {
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setSrcFunction(3);
                alphaState.setDstFunction(1);
                alphaState.setBlendEnabled(true);
                colladaMaterial.setState((RenderState)alphaState);
            } else if (lambertType2.gettransparent().hastexture()) {
                AlphaState alphaState = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
                alphaState.setSrcFunction(4);
                alphaState.setDstFunction(5);
                alphaState.setBlendEnabled(true);
                alphaState.setReference(0.14f);
                alphaState.setTestEnabled(true);
                alphaState.setTestFunction(6);
                colladaMaterial.setState((RenderState)alphaState);
            }
        }
    }

    private TextureState processTexture(textureType textureType2, ColladaMaterial colladaMaterial) throws Exception {
        TextureState textureState = DisplaySystem.getDisplaySystem().getRenderer().createTextureState();
        URL uRL = null;
        String string2 = textureType2.gettexture().toString();
        String string3 = (String)this.resourceLibrary.get(string2);
        if (string3 == null) {
            return null;
        }
        while (!string3.contains(".")) {
            if ((string3 = (String)this.resourceLibrary.get(string3)) != null) continue;
            return null;
        }
        this.loadTexture(textureState, uRL, string3, colladaMaterial);
        return textureState;
    }

    private void loadTexture(TextureState textureState, URL uRL, String string2, ColladaMaterial colladaMaterial) {
        Texture texture;
        block6: {
            if (this.textureDirectory != null) {
                try {
                    uRL = new URL(this.textureDirectory.toString() + string2);
                }
                catch (MalformedURLException malformedURLException) {
                    if (squelch) break block6;
                    ErrorManager.getInstance().addError(Level.WARNING, "Invalid texture location (texture not found): \"" + this.textureDirectory.toString() + string2 + "\"");
                }
            }
        }
        if ((texture = TextureManager.loadTexture((URL)uRL, (int)colladaMaterial.getMinFilterConstant(), (int)colladaMaterial.getMagFilterConstant())) != null) {
            texture.setWrap(4);
            textureState.setTexture(texture);
        } else if (!squelch) {
            ErrorManager.getInstance().addError(Level.WARNING, "Invalid texture: \"" + this.textureDirectory.toString() + string2 + "\"");
        }
    }

    private void processGeometry(library_geometriesType library_geometriesType2) throws Exception {
        for (int i = 0; i < library_geometriesType2.getgeometryCount(); ++i) {
            geometryType geometryType2 = library_geometriesType2.getgeometryAt(i);
            if (geometryType2.hasmesh()) {
                for (int j = 0; j < geometryType2.getmeshCount(); ++j) {
                    Geometry geometry = this.processMesh(geometryType2.getmeshAt(j), geometryType2);
                    ColladaImporter.put(geometryType2.getid().toString(), geometry);
                    if (this.geometryNames == null) {
                        this.geometryNames = new ArrayList();
                    }
                    this.geometryNames.add(geometryType2.getid().toString());
                }
            }
            if (!geometryType2.hasspline() || squelch) continue;
            ErrorManager.getInstance().addError(Level.WARNING, "splines not yet supported.");
        }
    }

    private void processControllerLibrary(library_controllersType library_controllersType2) throws Exception {
        if (library_controllersType2.hascontroller()) {
            for (int i = 0; i < library_controllersType2.getcontrollerCount(); ++i) {
                this.processController(library_controllersType2.getcontrollerAt(i));
            }
        }
    }

    private void processController(controllerType controllerType2) throws Exception {
        if (controllerType2.hasskin()) {
            this.processSkin(controllerType2.getid().toString(), controllerType2.getskin());
        } else if (controllerType2.hasmorph()) {
            // empty if block
        }
    }

    private void processSkin(String string2, skinType skinType2) throws Exception {
        Matrix4f[] matrix4fArray;
        SkinNode skinNode = new SkinNode(string2 + "_node");
        if (this.skinNodeNames == null) {
            this.skinNodeNames = new ArrayList();
        }
        this.skinNodeNames.add(string2);
        ColladaImporter.put(string2, skinNode);
        if (skinType2.hasbind_shape_matrix()) {
            String string3 = skinType2.getsource().toString();
            if (string3.startsWith("#")) {
                string3 = string3.substring(1);
            }
            if ((matrix4fArray = (Matrix4f[])this.resourceLibrary.get(string3)) == null) {
                if (!squelch) {
                    ErrorManager.getInstance().addError(Level.WARNING, string3 + " mesh does NOT exist in COLLADA file.");
                }
                return;
            }
            this.processBindShapeMatrix(skinNode, skinType2.getbind_shape_matrix());
            skinNode.setSkin((Geometry)matrix4fArray);
        }
        if (skinType2.hassource2()) {
            for (int i = 0; i < skinType2.getsource2Count(); ++i) {
                this.processControllerSource(skinType2.getsource2At(i));
            }
        }
        if (skinType2.hasvertex_weights()) {
            this.processVertexWeights(skinType2.getvertex_weights(), skinNode);
        }
        if (skinType2.hasjoints()) {
            int n;
            String[] stringArray = null;
            matrix4fArray = null;
            if (skinType2.getjoints().hasinput()) {
                for (n = 0; n < skinType2.getjoints().getinputCount(); ++n) {
                    if ("JOINT".equals(skinType2.getjoints().getinputAt(n).getsemantic().toString())) {
                        stringArray = (String[])this.resourceLibrary.get(skinType2.getjoints().getinputAt(n).getsource().toString().substring(1));
                        continue;
                    }
                    if (!"INV_BIND_MATRIX".equals(skinType2.getjoints().getinputAt(n).getsemantic().toString())) continue;
                    matrix4fArray = (Matrix4f[])this.resourceLibrary.get(skinType2.getjoints().getinputAt(n).getsource().toString().substring(1));
                }
            }
            if (stringArray != null) {
                for (n = 0; n < stringArray.length; ++n) {
                    Bone bone = (Bone)this.resourceLibrary.get(stringArray[n]);
                    bone.setBindMatrix(matrix4fArray[n].invert());
                }
            }
        }
    }

    private void processVertexWeights(vertex_weightsType vertex_weightsType2, SkinNode skinNode) throws Exception {
        int n;
        int[] nArray = new int[vertex_weightsType2.getcount().intValue()];
        StringTokenizer stringTokenizer = new StringTokenizer(vertex_weightsType2.getvcount().getValue());
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = Integer.parseInt(stringTokenizer.nextToken());
        }
        stringTokenizer = new StringTokenizer(vertex_weightsType2.getv().getValue());
        n = 0;
        String[] stringArray = null;
        float[] fArray = null;
        for (int i = 0; i < vertex_weightsType2.getinputCount(); ++i) {
            String string2;
            if ("JOINT".equals(vertex_weightsType2.getinputAt(i).getsemantic().toString())) {
                string2 = vertex_weightsType2.getinputAt(i).getsource().toString();
                string2 = string2.substring(1);
                stringArray = (String[])this.resourceLibrary.get(string2);
                continue;
            }
            if (!"WEIGHT".equals(vertex_weightsType2.getinputAt(i).getsemantic().toString())) continue;
            string2 = vertex_weightsType2.getinputAt(i).getsource().toString();
            string2 = string2.substring(1);
            fArray = (float[])this.resourceLibrary.get(string2);
        }
        if (stringArray == null || fArray == null) {
            if (!squelch) {
                ErrorManager.getInstance().addError(Level.WARNING, "Missing resource values for either bone weights or bone vertex ids.");
            }
            return;
        }
        Map map = (Map)this.resourceLibrary.get(skinNode.getSkin().getName() + "VertMap");
        while (stringTokenizer.hasMoreTokens()) {
            for (int i = 0; i < nArray[n]; ++i) {
                int n2 = Integer.parseInt(stringTokenizer.nextToken());
                int n3 = Integer.parseInt(stringTokenizer.nextToken());
                float f = fArray[n3];
                ArrayList arrayList = (ArrayList)map.get(n);
                if (arrayList == null) continue;
                int n4 = arrayList.size();
                for (int j = 0; j < n4; ++j) {
                    BatchVertPair batchVertPair = (BatchVertPair)arrayList.get(j);
                    skinNode.addBoneInfluence(batchVertPair.batch, batchVertPair.index, this.boneIds[n2], f);
                }
            }
            ++n;
        }
    }

    private void processControllerSource(sourceType sourceType2) throws Exception {
        String string2 = sourceType2.gettechnique_common().getaccessor().getparam().gettype().getValue().toString();
        if (string2.equalsIgnoreCase("IDREF")) {
            if (sourceType2.hasIDREF_array()) {
                IDREF_arrayType iDREF_arrayType = sourceType2.getIDREF_array();
                Bone[] boneArray = new Bone[iDREF_arrayType.getcount().intValue()];
                this.boneIds = new String[boneArray.length];
                StringTokenizer stringTokenizer = new StringTokenizer(iDREF_arrayType.getValue().toString());
                for (int i = 0; i < boneArray.length; ++i) {
                    boneArray[i] = new Bone(stringTokenizer.nextToken());
                    this.boneIds[i] = boneArray[i].getName();
                    ColladaImporter.put(this.boneIds[i], boneArray[i]);
                }
                ColladaImporter.put(sourceType2.getid().toString(), this.boneIds);
            }
        } else if (string2.equalsIgnoreCase("Name")) {
            if (sourceType2.hasName_array()) {
                Name_arrayType name_arrayType = sourceType2.getName_array();
                Bone[] boneArray = new Bone[name_arrayType.getcount().intValue()];
                this.boneIds = new String[boneArray.length];
                StringTokenizer stringTokenizer = new StringTokenizer(name_arrayType.getValue().toString());
                for (int i = 0; i < boneArray.length; ++i) {
                    boneArray[i] = new Bone(stringTokenizer.nextToken());
                    this.boneIds[i] = boneArray[i].getName();
                    ColladaImporter.put(this.boneIds[i], boneArray[i]);
                    ColladaImporter.put(sourceType2.getid().toString(), this.boneIds);
                }
            }
        } else if (string2.equalsIgnoreCase("float4x4")) {
            StringTokenizer stringTokenizer = new StringTokenizer(sourceType2.getfloat_array().getValue().toString());
            int n = stringTokenizer.countTokens() / 16;
            Matrix4f[] matrix4fArray = new Matrix4f[n];
            for (int i = 0; i < matrix4fArray.length; ++i) {
                matrix4fArray[i] = new Matrix4f();
                float[] fArray = new float[16];
                for (int j = 0; j < 16; ++j) {
                    fArray[j] = Float.parseFloat(stringTokenizer.nextToken());
                }
                matrix4fArray[i].set(fArray, true);
            }
            ColladaImporter.put(sourceType2.getid().toString(), matrix4fArray);
        } else if (string2.equalsIgnoreCase("float")) {
            float_arrayType float_arrayType2 = sourceType2.getfloat_array();
            float[] fArray = new float[float_arrayType2.getcount().intValue()];
            StringTokenizer stringTokenizer = new StringTokenizer(float_arrayType2.getValue().toString());
            for (int i = 0; i < fArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
            }
            ColladaImporter.put(sourceType2.getid().toString(), fArray);
        }
    }

    private void processBindShapeMatrix(SkinNode skinNode, float4x4 float4x42) {
        Matrix4f matrix4f = new Matrix4f();
        StringTokenizer stringTokenizer = new StringTokenizer(float4x42.getValue().toString());
        float[] fArray = new float[16];
        for (int i = 0; i < 16; ++i) {
            fArray[i] = Float.parseFloat(stringTokenizer.nextToken());
        }
        matrix4f.set(fArray, true);
        skinNode.setBindMatrix(matrix4f);
    }

    private void processBindMaterial(bind_materialType bind_materialType2, Geometry geometry) throws Exception {
        technique_commonType technique_commonType10 = bind_materialType2.gettechnique_common();
        for (int i = 0; i < technique_commonType10.getinstance_materialCount(); ++i) {
            this.processInstanceMaterial(technique_commonType10.getinstance_materialAt(i), geometry);
        }
    }

    private Geometry processMesh(meshType meshType2, geometryType geometryType2) throws Exception {
        for (int i = 0; i < meshType2.getsourceCount(); ++i) {
            int n;
            sourceType sourceType2 = meshType2.getsourceAt(i);
            if (!sourceType2.hasfloat_array()) continue;
            float_arrayType float_arrayType2 = sourceType2.getfloat_array();
            StringTokenizer stringTokenizer = new StringTokenizer(float_arrayType2.getValue().toString());
            float[] fArray = new float[float_arrayType2.getcount().intValue()];
            for (int j = 0; j < fArray.length; ++j) {
                fArray[j] = Float.parseFloat(stringTokenizer.nextToken());
            }
            if (!sourceType2.hastechnique_common()) continue;
            accessorType accessorType2 = sourceType2.gettechnique_common().getaccessor();
            Vector3f[] vector3fArray = new Vector3f[accessorType2.getcount().intValue()];
            int n2 = accessorType2.getstride().intValue();
            if (2 == n2) {
                for (n = 0; n < vector3fArray.length; ++n) {
                    vector3fArray[n] = new Vector3f(fArray[n * n2], fArray[n * n2 + 1], 0.0f);
                }
            } else {
                assert (3 == n2);
                for (n = 0; n < vector3fArray.length; ++n) {
                    vector3fArray[n] = new Vector3f(fArray[n * n2], fArray[n * n2 + 1], fArray[n * n2 + 2]);
                }
            }
            ColladaImporter.put(sourceType2.getid().toString(), vector3fArray);
        }
        if (meshType2.hasvertices() && meshType2.getvertices().hasinput()) {
            ColladaImporter.put(meshType2.getvertices().getid().toString(), meshType2.getvertices().getinput().getsource().toString());
        }
        if (meshType2.hastriangles()) {
            return this.processTriMesh(meshType2, geometryType2);
        }
        if (meshType2.haspolygons()) {
            return this.processPolygonMesh(meshType2, geometryType2);
        }
        if (meshType2.haslines()) {
            return this.processLines(meshType2, geometryType2);
        }
        return null;
    }

    private TriMesh processTriMesh(meshType meshType2, geometryType geometryType2) throws Exception {
        HashMap<Integer, ArrayList<BatchVertPair>> hashMap = new HashMap<Integer, ArrayList<BatchVertPair>>();
        ColladaImporter.put(geometryType2.getid().toString() + "VertMap", hashMap);
        TriMesh triMesh = new TriMesh(geometryType2.getid().toString());
        for (int i = 0; i < meshType2.gettrianglesCount(); ++i) {
            int n;
            Vector3f[] vector3fArray;
            Object object;
            int n2;
            Object object2;
            trianglesType trianglesType2 = meshType2.gettrianglesAt(i);
            TriangleBatch triangleBatch = null;
            if (i < triMesh.getBatchCount()) {
                triangleBatch = triMesh.getBatch(i);
            } else {
                triangleBatch = new TriangleBatch();
                triMesh.addBatch((GeomBatch)triangleBatch);
            }
            if (trianglesType2.hasmaterial()) {
                object2 = (String)this.resourceLibrary.get(trianglesType2.getmaterial().toString());
                ColladaMaterial colladaMaterial = (ColladaMaterial)this.resourceLibrary.get(object2);
                if (colladaMaterial != null) {
                    for (n2 = 0; n2 < 17; ++n2) {
                        if (colladaMaterial.getState(n2) == null) continue;
                        if (colladaMaterial.getState(n2).getType() == 0) {
                            triMesh.getBatch(i).setRenderQueueMode(3);
                        }
                        try {
                            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                            BinaryExporter.getInstance().save((Savable)colladaMaterial.getState(n2), (OutputStream)byteArrayOutputStream);
                            object = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
                            vector3fArray = (Vector3f[])BinaryImporter.getInstance().load((InputStream)object);
                            triangleBatch.setRenderState((RenderState)vector3fArray);
                            continue;
                        }
                        catch (IOException iOException) {
                            iOException.printStackTrace();
                        }
                    }
                    ArrayList<Controller> arrayList = colladaMaterial.getControllerList();
                    if (arrayList != null) {
                        for (int j = 0; j < arrayList.size(); ++j) {
                            if (!(arrayList.get(j) instanceof TextureKeyframeController) || (object = (TextureState)triangleBatch.getRenderState(6)) == null) continue;
                            object.getTexture().setWrap(3);
                            ((TextureKeyframeController)arrayList.get(j)).setTexture(object.getTexture());
                        }
                    }
                    if (meshType2.hasextra()) {
                        for (int j = 0; j < meshType2.getextraCount(); ++j) {
                            try {
                                ExtraPluginManager.processExtra(triangleBatch, meshType2.getextraAt(j));
                                continue;
                            }
                            catch (Exception exception) {
                                if (squelch) continue;
                                exception.printStackTrace();
                                ErrorManager.getInstance().addError(Level.WARNING, "Error processing extra information - " + exception, (Throwable)exception);
                            }
                        }
                    }
                }
                triangleBatch.setName(trianglesType2.getmaterial().toString());
            }
            object2 = BufferUtils.createIntBuffer((int)(trianglesType2.getcount().intValue() * 3));
            for (n = 0; n < ((Buffer)object2).capacity(); ++n) {
                ((IntBuffer)object2).put(n);
            }
            triMesh.setIndexBuffer(i, (IntBuffer)object2);
            n = -1;
            for (n2 = 0; n2 < trianglesType2.getinputCount(); ++n2) {
                int n3 = trianglesType2.getinputAt(n2).getoffset().intValue();
                if (n >= n3) continue;
                n = n3;
            }
            for (n2 = 0; n2 < trianglesType2.getinputCount(); ++n2) {
                int n4;
                FloatBuffer floatBuffer;
                int n5;
                StringTokenizer stringTokenizer;
                if ("VERTEX".equals(trianglesType2.getinputAt(n2).getsemantic().toString())) {
                    String string2 = trianglesType2.getinputAt(n2).getsource().getValue().toString();
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    object = this.resourceLibrary.get(string2);
                    while (object instanceof String) {
                        string2 = (String)object;
                        if (string2.startsWith("#")) {
                            string2 = string2.substring(1);
                        }
                        object = this.resourceLibrary.get(string2);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string2);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = new StringTokenizer(trianglesType2.getp().getValue());
                    n5 = trianglesType2.getcount().intValue() * 3;
                    floatBuffer = BufferUtils.createVector3Buffer((int)n5);
                    triangleBatch.setVertexCount(n5);
                    for (n4 = 0; n4 < n5; ++n4) {
                        int n6 = Integer.parseInt(stringTokenizer.nextToken());
                        ArrayList<BatchVertPair> arrayList = (ArrayList<BatchVertPair>)hashMap.get(n6);
                        if (arrayList == null) {
                            arrayList = new ArrayList<BatchVertPair>();
                            arrayList.add(new BatchVertPair(i, n4));
                            hashMap.put(n6, arrayList);
                        } else {
                            arrayList.add(new BatchVertPair(i, n4));
                        }
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[n6], (FloatBuffer)floatBuffer, (int)n4);
                        for (int j = 0; j < n; ++j) {
                            stringTokenizer.nextToken();
                        }
                    }
                    triMesh.setVertexBuffer(i, floatBuffer);
                    continue;
                }
                if ("NORMAL".equals(trianglesType2.getinputAt(n2).getsemantic().toString())) {
                    int n7;
                    String string3 = trianglesType2.getinputAt(n2).getsource().getValue().toString();
                    if (string3.startsWith("#")) {
                        string3 = string3.substring(1);
                    }
                    object = this.resourceLibrary.get(string3);
                    while (object instanceof String) {
                        string3 = (String)object;
                        if (string3.startsWith("#")) {
                            string3 = string3.substring(1);
                        }
                        object = this.resourceLibrary.get(string3);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string3);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = new StringTokenizer(trianglesType2.getp().getValue());
                    n5 = trianglesType2.getcount().intValue() * 3;
                    floatBuffer = BufferUtils.createVector3Buffer((int)n5);
                    n4 = trianglesType2.getinputAt(n2).getoffset().intValue();
                    for (n7 = 0; n7 < n4; ++n7) {
                        stringTokenizer.nextToken();
                    }
                    for (n7 = 0; n7 < n5; ++n7) {
                        int n8 = Integer.parseInt(stringTokenizer.nextToken());
                        if (n8 < vector3fArray.length) {
                            BufferUtils.setInBuffer((Vector3f)vector3fArray[n8], (FloatBuffer)floatBuffer, (int)n7);
                        }
                        for (int j = 0; j < n; ++j) {
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringTokenizer.nextToken();
                        }
                    }
                    triMesh.setNormalBuffer(i, floatBuffer);
                    continue;
                }
                if ("TEXCOORD".equals(trianglesType2.getinputAt(n2).getsemantic().toString())) {
                    Vector3f vector3f;
                    int n9;
                    String string4 = trianglesType2.getinputAt(n2).getsource().getValue().toString();
                    if (string4.startsWith("#")) {
                        string4 = string4.substring(1);
                    }
                    object = this.resourceLibrary.get(string4);
                    while (object instanceof String) {
                        string4 = (String)object;
                        if (string4.startsWith("#")) {
                            string4 = string4.substring(1);
                        }
                        object = this.resourceLibrary.get(string4);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string4);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = new StringTokenizer(trianglesType2.getp().getValue());
                    n5 = trianglesType2.getcount().intValue() * 3;
                    floatBuffer = BufferUtils.createVector2Buffer((int)n5);
                    n4 = trianglesType2.getinputAt(n2).getoffset().intValue();
                    int n10 = trianglesType2.getinputAt(n2).getset().intValue();
                    for (int j = 0; j < n4; ++j) {
                        stringTokenizer.nextToken();
                    }
                    float f = -10.0f;
                    float f2 = -10.0f;
                    float f3 = 10.0f;
                    float f4 = 10.0f;
                    Vector2f vector2f = new Vector2f();
                    for (n9 = 0; n9 < n5; ++n9) {
                        int n11 = Integer.parseInt(stringTokenizer.nextToken());
                        vector3f = vector3fArray[n11];
                        if (vector3f.x > f) {
                            f = vector3f.x;
                        }
                        if (vector3f.x < f3) {
                            f3 = vector3f.x;
                        }
                        if (vector3f.y > f2) {
                            f2 = vector3f.y;
                        }
                        if (vector3f.y < f4) {
                            f4 = vector3f.y;
                        }
                        vector2f.set(vector3f.x, vector3f.y);
                        BufferUtils.setInBuffer((Vector2f)vector2f, (FloatBuffer)floatBuffer, (int)n9);
                        for (int j = 0; j < n; ++j) {
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringTokenizer.nextToken();
                        }
                    }
                    n9 = n10 == 0 ? 0 : n10 - 1;
                    triMesh.setTextureBuffer(i, floatBuffer, n9);
                    TextureState textureState = (TextureState)triangleBatch.getRenderState(6);
                    if (textureState == null) {
                        textureState = (TextureState)triMesh.getRenderState(6);
                    }
                    if (textureState == null || (vector3f = textureState.getTexture(n9)) == null) continue;
                    if (f > 1.0f || f3 < 0.0f) {
                        if (f2 > 1.0f || f4 < 0.0f) {
                            vector3f.setWrap(3);
                            continue;
                        }
                        if (vector3f.getWrap() == 3) continue;
                        if (vector3f.getWrap() == 1) {
                            vector3f.setWrap(3);
                            continue;
                        }
                        vector3f.setWrap(2);
                        continue;
                    }
                    if (!(f2 > 1.0f) && !(f4 < 0.0f) || vector3f.getWrap() == 3) continue;
                    if (vector3f.getWrap() == 2) {
                        vector3f.setWrap(3);
                        continue;
                    }
                    vector3f.setWrap(1);
                    continue;
                }
                if (!"COLOR".equals(trianglesType2.getinputAt(n2).getsemantic().toString())) continue;
                String string5 = trianglesType2.getinputAt(n2).getsource().getValue().toString();
                if (string5.startsWith("#")) {
                    string5 = string5.substring(1);
                }
                object = this.resourceLibrary.get(string5);
                while (object instanceof String) {
                    string5 = (String)object;
                    if (string5.startsWith("#")) {
                        string5 = string5.substring(1);
                    }
                    object = this.resourceLibrary.get(string5);
                }
                vector3fArray = (Vector3f[])object;
                stringTokenizer = new StringTokenizer(trianglesType2.getp().getValue());
                n5 = trianglesType2.getcount().intValue() * 3;
                floatBuffer = BufferUtils.createColorBuffer((int)n5);
                n4 = trianglesType2.getinputAt(n2).getoffset().intValue();
                for (int j = 0; j < n4; ++j) {
                    stringTokenizer.nextToken();
                }
                ColorRGBA colorRGBA = new ColorRGBA();
                for (int j = 0; j < n5; ++j) {
                    int n12 = Integer.parseInt(stringTokenizer.nextToken());
                    Vector3f vector3f = vector3fArray[n12];
                    colorRGBA.set(vector3f.x, vector3f.y, vector3f.z, 1.0f);
                    BufferUtils.setInBuffer((ColorRGBA)colorRGBA, (FloatBuffer)floatBuffer, (int)j);
                    for (int k = 0; k < n; ++k) {
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        stringTokenizer.nextToken();
                    }
                }
                triMesh.setColorBuffer(i, floatBuffer);
            }
        }
        triMesh.setModelBound((BoundingVolume)new BoundingBox());
        triMesh.updateModelBound();
        return triMesh;
    }

    private TriMesh processPolygonMesh(meshType meshType2, geometryType geometryType2) throws Exception {
        HashMap<Integer, ArrayList<BatchVertPair>> hashMap = new HashMap<Integer, ArrayList<BatchVertPair>>();
        ColladaImporter.put(geometryType2.getid().toString() + "VertMap", hashMap);
        TriMesh triMesh = new TriMesh(geometryType2.getid().toString());
        for (int i = 0; i < meshType2.getpolygonsCount(); ++i) {
            int n;
            int n2;
            int n3;
            polygonsType polygonsType2 = meshType2.getpolygonsAt(i);
            TriangleBatch triangleBatch = null;
            if (i < triMesh.getBatchCount()) {
                triangleBatch = triMesh.getBatch(i);
            } else {
                triangleBatch = new TriangleBatch();
                triMesh.addBatch((GeomBatch)triangleBatch);
            }
            if (polygonsType2.hasmaterial()) {
                triangleBatch.setName(polygonsType2.getmaterial().toString());
            }
            IntBuffer intBuffer = BufferUtils.createIntBuffer((int)(polygonsType2.getcount().intValue() * 3));
            for (n3 = 0; n3 < intBuffer.capacity(); ++n3) {
                intBuffer.put(n3);
            }
            triMesh.setIndexBuffer(i, intBuffer);
            n3 = -1;
            for (n2 = 0; n2 < polygonsType2.getinputCount(); ++n2) {
                n = polygonsType2.getinputAt(n2).getoffset().intValue();
                if (n3 >= n) continue;
                n3 = n;
            }
            n2 = n3 + 1;
            for (n = 0; n < polygonsType2.getinputCount(); ++n) {
                int n4;
                Vector2f vector2f;
                int n5;
                FloatBuffer floatBuffer;
                int n6;
                StringTokenizer stringTokenizer;
                Vector3f[] vector3fArray;
                Object object;
                String string2;
                if ("VERTEX".equals(polygonsType2.getinputAt(n).getsemantic().toString())) {
                    string2 = polygonsType2.getinputAt(n).getsource().getValue().toString();
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    object = this.resourceLibrary.get(string2);
                    while (object instanceof String) {
                        string2 = (String)object;
                        if (string2.startsWith("#")) {
                            string2 = string2.substring(1);
                        }
                        object = this.resourceLibrary.get(string2);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string2);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = null;
                    n6 = polygonsType2.getcount().intValue() * n2;
                    floatBuffer = BufferUtils.createVector3Buffer((int)n6);
                    triangleBatch.setVertexCount(n6);
                    for (n5 = 0; n5 < n6; ++n5) {
                        int n7;
                        ArrayList<BatchVertPair> arrayList;
                        if (n5 % n2 == 0) {
                            stringTokenizer = new StringTokenizer(polygonsType2.getpAt(n5 / n2).getValue());
                        }
                        if ((arrayList = (ArrayList<BatchVertPair>)hashMap.get(n7 = Integer.parseInt(stringTokenizer.nextToken()))) == null) {
                            arrayList = new ArrayList<BatchVertPair>();
                            arrayList.add(new BatchVertPair(i, n5));
                            hashMap.put(n7, arrayList);
                        } else {
                            arrayList.add(new BatchVertPair(i, n5));
                        }
                        BufferUtils.setInBuffer((Vector3f)vector3fArray[n7], (FloatBuffer)floatBuffer, (int)n5);
                        for (int j = 0; j < n3; ++j) {
                            stringTokenizer.nextToken();
                        }
                    }
                    triMesh.setVertexBuffer(i, floatBuffer);
                    continue;
                }
                if ("NORMAL".equals(polygonsType2.getinputAt(n).getsemantic().toString())) {
                    int n8;
                    string2 = polygonsType2.getinputAt(n).getsource().getValue().toString();
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    object = this.resourceLibrary.get(string2);
                    while (object instanceof String) {
                        string2 = (String)object;
                        if (string2.startsWith("#")) {
                            string2 = string2.substring(1);
                        }
                        object = this.resourceLibrary.get(string2);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string2);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = null;
                    n6 = polygonsType2.getcount().intValue() * n2;
                    floatBuffer = BufferUtils.createVector3Buffer((int)n6);
                    n5 = polygonsType2.getinputAt(n).getoffset().intValue();
                    for (n8 = 0; n8 < n5; ++n8) {
                        if (n8 % n2 == 0) {
                            stringTokenizer = new StringTokenizer(polygonsType2.getpAt(n8 / n2).getValue());
                        }
                        stringTokenizer.nextToken();
                    }
                    for (n8 = 0; n8 < n6; ++n8) {
                        int n9;
                        if (n8 % n2 == 0) {
                            stringTokenizer = new StringTokenizer(polygonsType2.getpAt(n8 / n2).getValue());
                        }
                        if ((n9 = Integer.parseInt(stringTokenizer.nextToken())) < vector3fArray.length) {
                            BufferUtils.setInBuffer((Vector3f)vector3fArray[n9], (FloatBuffer)floatBuffer, (int)n8);
                        }
                        for (int j = 0; j < n3; ++j) {
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringTokenizer.nextToken();
                        }
                    }
                    triMesh.setNormalBuffer(i, floatBuffer);
                    continue;
                }
                if ("TEXCOORD".equals(polygonsType2.getinputAt(n).getsemantic().toString())) {
                    Vector3f vector3f;
                    string2 = polygonsType2.getinputAt(n).getsource().getValue().toString();
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    object = this.resourceLibrary.get(string2);
                    while (object instanceof String) {
                        string2 = (String)object;
                        if (string2.startsWith("#")) {
                            string2 = string2.substring(1);
                        }
                        object = this.resourceLibrary.get(string2);
                    }
                    if (object == null) {
                        ErrorManager.getInstance().addError(Level.WARNING, "Invalid source: " + string2);
                        continue;
                    }
                    vector3fArray = (Vector3f[])object;
                    stringTokenizer = new StringTokenizer(polygonsType2.getp().getValue());
                    n6 = polygonsType2.getcount().intValue() * n2;
                    floatBuffer = BufferUtils.createVector2Buffer((int)n6);
                    n5 = polygonsType2.getinputAt(n).getoffset().intValue();
                    int n10 = polygonsType2.getinputAt(n).getset().intValue();
                    for (int j = 0; j < n5; ++j) {
                        if (j % n2 == 0) {
                            stringTokenizer = new StringTokenizer(polygonsType2.getpAt(j / n2).getValue());
                        }
                        stringTokenizer.nextToken();
                    }
                    float f = -1.0f;
                    float f2 = -1.0f;
                    vector2f = new Vector2f();
                    for (n4 = 0; n4 < n6; ++n4) {
                        if (n4 % n2 == 0) {
                            stringTokenizer = new StringTokenizer(polygonsType2.getpAt(n4 / n2).getValue());
                        }
                        int n11 = Integer.parseInt(stringTokenizer.nextToken());
                        vector3f = vector3fArray[n11];
                        if (vector3f.x > f) {
                            f = vector3f.x;
                        }
                        if (vector3f.y > f2) {
                            f2 = vector3f.y;
                        }
                        vector2f.set(vector3f.x, vector3f.y);
                        BufferUtils.setInBuffer((Vector2f)vector2f, (FloatBuffer)floatBuffer, (int)n4);
                        for (int j = 0; j < n3; ++j) {
                            if (!stringTokenizer.hasMoreTokens()) continue;
                            stringTokenizer.nextToken();
                        }
                    }
                    n4 = n10 == 0 ? 0 : n10 - 1;
                    triMesh.setTextureBuffer(i, floatBuffer, n4);
                    TextureState textureState = (TextureState)triangleBatch.getRenderState(6);
                    if (textureState == null) {
                        textureState = (TextureState)triMesh.getRenderState(6);
                    }
                    if (textureState == null || (vector3f = textureState.getTexture(n4)) == null) continue;
                    if (f > 1.0f) {
                        if (f2 > 1.0f) {
                            vector3f.setWrap(3);
                            continue;
                        }
                        vector3f.setWrap(2);
                        continue;
                    }
                    if (!(f2 > 1.0f)) continue;
                    vector3f.setWrap(1);
                    continue;
                }
                if (!"COLOR".equals(polygonsType2.getinputAt(n).getsemantic().toString())) continue;
                string2 = polygonsType2.getinputAt(n).getsource().getValue().toString();
                if (string2.startsWith("#")) {
                    string2 = string2.substring(1);
                }
                object = this.resourceLibrary.get(string2);
                while (object instanceof String) {
                    string2 = (String)object;
                    if (string2.startsWith("#")) {
                        string2 = string2.substring(1);
                    }
                    object = this.resourceLibrary.get(string2);
                }
                vector3fArray = (Vector3f[])object;
                stringTokenizer = new StringTokenizer(polygonsType2.getp().getValue());
                n6 = polygonsType2.getcount().intValue() * 3;
                floatBuffer = BufferUtils.createColorBuffer((int)n6);
                n5 = polygonsType2.getinputAt(n).getoffset().intValue();
                for (int j = 0; j < n5; ++j) {
                    stringTokenizer.nextToken();
                }
                ColorRGBA colorRGBA = new ColorRGBA();
                for (int j = 0; j < n6; ++j) {
                    int n12 = Integer.parseInt(stringTokenizer.nextToken());
                    vector2f = vector3fArray[n12];
                    colorRGBA.set(vector2f.x, vector2f.y, vector2f.z, 1.0f);
                    BufferUtils.setInBuffer((ColorRGBA)colorRGBA, (FloatBuffer)floatBuffer, (int)j);
                    for (n4 = 0; n4 < n3; ++n4) {
                        if (!stringTokenizer.hasMoreTokens()) continue;
                        stringTokenizer.nextToken();
                    }
                }
                triMesh.setColorBuffer(i, floatBuffer);
            }
        }
        triMesh.setModelBound((BoundingVolume)new BoundingBox());
        triMesh.updateModelBound();
        return triMesh;
    }

    private Line processLines(meshType meshType2, geometryType geometryType2) {
        if (!squelch) {
            ErrorManager.getInstance().addError(Level.WARNING, "Line are not supported.");
        }
        return null;
    }

    private void processVisualSceneLibrary(library_visual_scenesType library_visual_scenesType2) throws Exception {
        for (int i = 0; i < library_visual_scenesType2.getvisual_sceneCount(); ++i) {
            com.jme.scene.Node node = new com.jme.scene.Node(library_visual_scenesType2.getvisual_sceneAt(i).getid().toString());
            ColladaImporter.put(node.getName(), node);
            this.processVisualScene(library_visual_scenesType2.getvisual_sceneAt(i), node);
        }
    }

    private void processVisualScene(visual_sceneType visual_sceneType2, com.jme.scene.Node node) throws Exception {
        int n;
        for (n = 0; n < visual_sceneType2.getnodeCount(); ++n) {
            this.processNode(visual_sceneType2.getnodeAt(n), node);
        }
        for (n = 0; n < node.getQuantity(); ++n) {
            Spatial spatial = node.getChild(n);
            if (!(spatial instanceof Bone)) continue;
            spatial.updateGeometricState(0.0f, true);
            spatial.removeFromParent();
            node.attachChild(spatial);
        }
    }

    private void processNode(nodeType2 nodeType22, com.jme.scene.Node node) throws Exception {
        Vector3f vector3f;
        Object object;
        Object object2;
        String string2;
        String string3 = null;
        if (nodeType22.hasid()) {
            string3 = nodeType22.getid().toString();
        } else if (nodeType22.hassid()) {
            string3 = nodeType22.getsid().toString();
        } else if (nodeType22.hasname()) {
            string3 = nodeType22.getname().toString();
        }
        com.jme.scene.Node node2 = null;
        if (nodeType22.hastype() && "JOINT".equals(nodeType22.gettype().toString()) && (nodeType22.hassid() || nodeType22.hasid())) {
            string2 = (nodeType22.hassid() ? nodeType22.getsid() : nodeType22.getid()).toString();
            node2 = (Bone)this.resourceLibrary.get(string2);
            if (node2 == null) {
                node2 = new Bone(string2);
                ColladaImporter.put(string2, node2);
                if (!squelch) {
                    ErrorManager.getInstance().addError(Level.WARNING, "Bone " + string2 + " is not attached to any vertices.");
                }
            }
            if (!(node instanceof Bone)) {
                if (this.skeletonNames == null) {
                    this.skeletonNames = new ArrayList();
                }
                this.skeletonNames.add(string2);
            }
        } else if (nodeType22.hasextra()) {
            for (int i = 0; i < nodeType22.getextraCount(); ++i) {
                try {
                    object2 = ExtraPluginManager.processExtra(string3, nodeType22.getextraAt(i));
                    if (!(object2 instanceof com.jme.scene.Node)) continue;
                    node2 = (com.jme.scene.Node)object2;
                    continue;
                }
                catch (Exception exception) {
                    if (squelch) continue;
                    exception.printStackTrace();
                    ErrorManager.getInstance().addError(Level.WARNING, "Error processing extra information - " + exception, (Throwable)exception);
                }
            }
        }
        if (node2 == null) {
            node2 = new com.jme.scene.Node(string3);
        }
        node.attachChild(node2);
        ColladaImporter.put(string3, node2);
        if (nodeType22.hasinstance_camera()) {
            for (int i = 0; i < nodeType22.getinstance_cameraCount(); ++i) {
                this.processInstanceCamera(nodeType22.getinstance_cameraAt(i), node2);
            }
        }
        if (nodeType22.hasinstance_controller()) {
            for (int i = 0; i < nodeType22.getinstance_controllerCount(); ++i) {
                this.processInstanceController(nodeType22.getinstance_controllerAt(i), node2);
            }
        }
        if (nodeType22.hasinstance_geometry()) {
            for (int i = 0; i < nodeType22.getinstance_geometryCount(); ++i) {
                this.processInstanceGeom(nodeType22.getinstance_geometryAt(i), node2);
            }
        }
        if (nodeType22.hasinstance_light()) {
            for (int i = 0; i < nodeType22.getinstance_lightCount(); ++i) {
                this.processInstanceLight(nodeType22.getinstance_lightAt(i), node2);
            }
        }
        if (nodeType22.hastranslate()) {
            string2 = new Vector3f();
            object2 = new StringTokenizer(nodeType22.gettranslate().getValue().toString());
            ((Vector3f)string2).x = Float.parseFloat(((StringTokenizer)object2).nextToken());
            ((Vector3f)string2).y = Float.parseFloat(((StringTokenizer)object2).nextToken());
            ((Vector3f)string2).z = Float.parseFloat(((StringTokenizer)object2).nextToken());
            node2.setLocalTranslation((Vector3f)string2);
        }
        if (nodeType22.hasrotate()) {
            string2 = null;
            for (int i = 0; i < nodeType22.getrotateCount(); ++i) {
                object = new Quaternion();
                vector3f = new Vector3f();
                StringTokenizer stringTokenizer = new StringTokenizer(nodeType22.getrotateAt(i).getValue().toString());
                vector3f.x = Float.parseFloat(stringTokenizer.nextToken());
                vector3f.y = Float.parseFloat(stringTokenizer.nextToken());
                vector3f.z = Float.parseFloat(stringTokenizer.nextToken());
                vector3f.normalizeLocal();
                float f = Float.parseFloat(stringTokenizer.nextToken());
                object.fromAngleNormalAxis(f *= (float)Math.PI / 180, vector3f);
                if (string2 == null) {
                    string2 = new Quaternion();
                    string2.set(object);
                    continue;
                }
                string2.multLocal(object);
            }
            node2.setLocalRotation((Quaternion)string2);
        }
        if (nodeType22.hasmatrix()) {
            string2 = new Matrix4f();
            StringTokenizer stringTokenizer = new StringTokenizer(nodeType22.getmatrix().getValue().toString());
            object = new float[16];
            for (int i = 0; i < 16; ++i) {
                object[i] = (Quaternion)Float.parseFloat(stringTokenizer.nextToken());
            }
            string2.set((float[])object, true);
            node2.setLocalTranslation(string2.toTranslationVector());
            vector3f = string2.toRotationQuat();
            vector3f.normalize();
            node2.setLocalRotation((Quaternion)vector3f);
        }
        if (nodeType22.hasscale()) {
            string2 = new Vector3f();
            StringTokenizer stringTokenizer = new StringTokenizer(nodeType22.getscale().getValue().toString());
            ((Vector3f)string2).x = Float.parseFloat(stringTokenizer.nextToken());
            ((Vector3f)string2).y = Float.parseFloat(stringTokenizer.nextToken());
            ((Vector3f)string2).z = Float.parseFloat(stringTokenizer.nextToken());
            node2.setLocalScale((Vector3f)string2);
        }
        if (nodeType22.hasnode()) {
            for (int i = 0; i < nodeType22.getnodeCount(); ++i) {
                this.processNode(nodeType22.getnodeAt(i), node2);
            }
        }
    }

    private void processInstanceCamera(InstanceWithExtra instanceWithExtra, com.jme.scene.Node node) throws Exception {
        CameraNode cameraNode;
        String string2 = instanceWithExtra.geturl().toString();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if ((cameraNode = (CameraNode)this.resourceLibrary.get(string2)) != null) {
            node.attachChild((Spatial)cameraNode);
        }
    }

    private void processInstanceLight(InstanceWithExtra instanceWithExtra, com.jme.scene.Node node) throws Exception {
        LightNode lightNode;
        String string2 = instanceWithExtra.geturl().toString();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if ((lightNode = (LightNode)this.resourceLibrary.get(string2)) != null) {
            node.attachChild((Spatial)lightNode);
        }
    }

    private void processInstanceController(instance_controllerType instance_controllerType2, com.jme.scene.Node node) throws Exception {
        SkinNode skinNode;
        String string2 = instance_controllerType2.geturl().toString();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if ((skinNode = (SkinNode)this.resourceLibrary.get(string2)) != null) {
            node.attachChild((Spatial)skinNode);
        } else if (!squelch) {
            ErrorManager.getInstance().addError(Level.WARNING, "Instance " + instance_controllerType2.geturl().toString().substring(1) + " does not exist.");
        }
        if (instance_controllerType2.hasskeleton()) {
            Bone bone;
            String string3;
            if (instance_controllerType2.getskeletonCount() > 1 && !squelch) {
                ErrorManager.getInstance().addError(Level.WARNING, "Controller has more than one skeleton.");
            }
            if ((string3 = instance_controllerType2.getskeleton().getValue()).startsWith("#")) {
                string3 = string3.substring(1);
            }
            if ((bone = (Bone)this.resourceLibrary.get(string3)) != null) {
                skinNode.setSkeleton(bone);
            }
        }
        if (instance_controllerType2.hasbind_material()) {
            this.processBindMaterial(instance_controllerType2.getbind_material(), skinNode.getSkin());
        }
    }

    private void processInstanceGeom(instance_geometryType instance_geometryType2, com.jme.scene.Node node) throws Exception {
        Geometry geometry;
        String string2 = instance_geometryType2.geturl().toString();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if ((geometry = (Geometry)this.resourceLibrary.get(string2)) != null) {
            if (geometry instanceof TriMesh) {
                geometry = new SharedMesh(string2, (TriMesh)geometry);
            }
            node.attachChild((Spatial)geometry);
            if (instance_geometryType2.hasbind_material()) {
                this.processBindMaterial(instance_geometryType2.getbind_material(), geometry);
            }
        }
    }

    private void processInstanceMaterial(instance_materialType instance_materialType2, Geometry geometry) throws Exception {
        Object object;
        Object object2;
        int n;
        String string2 = instance_materialType2.gettarget().toString();
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        ColladaMaterial colladaMaterial = (ColladaMaterial)this.resourceLibrary.get(this.resourceLibrary.get(string2));
        Geometry geometry2 = geometry;
        for (n = 0; n < geometry.getBatchCount(); ++n) {
            object2 = geometry.getBatch(n);
            object = instance_materialType2.getsymbol().toString();
            if (!((String)object).equals(object2.getName())) continue;
            geometry2 = object2;
            break;
        }
        if (colladaMaterial != null) {
            for (n = 0; n < 17; ++n) {
                if (colladaMaterial.getState(n) == null) continue;
                if (colladaMaterial.getState(n).getType() == 0) {
                    geometry2.setRenderQueueMode(3);
                }
                try {
                    object2 = new ByteArrayOutputStream();
                    BinaryExporter.getInstance().save((Savable)colladaMaterial.getState(n), (OutputStream)object2);
                    object = new ByteArrayInputStream(((ByteArrayOutputStream)object2).toByteArray());
                    RenderState renderState = (RenderState)BinaryImporter.getInstance().load((InputStream)object);
                    geometry2.setRenderState(renderState);
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
    }

    private ColorRGBA getColor(colorType colorType2) {
        ColorRGBA colorRGBA = new ColorRGBA();
        StringTokenizer stringTokenizer = new StringTokenizer(colorType2.getValue().toString());
        colorRGBA.r = Float.parseFloat(stringTokenizer.nextToken());
        colorRGBA.g = Float.parseFloat(stringTokenizer.nextToken());
        colorRGBA.b = Float.parseFloat(stringTokenizer.nextToken());
        colorRGBA.a = Float.parseFloat(stringTokenizer.nextToken());
        return colorRGBA;
    }

    public static void squelchErrors(boolean bl) {
        squelch = bl;
    }

    private class BatchVertPair {
        public int batch;
        public int index;

        public BatchVertPair(int n, int n2) {
            this.batch = n;
            this.index = n2;
        }
    }
}

