/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaString;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeBinary;
import com.jmex.model.collada.types.TypesIncompatibleException;

public abstract class SchemaBinaryBase
implements SchemaTypeBinary {
    protected byte[] value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaBinaryBase() {
        this.setEmpty();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaBinaryBase)) {
            return false;
        }
        SchemaBinaryBase schemaBinaryBase = (SchemaBinaryBase)object;
        if (this.value.length != schemaBinaryBase.value.length) {
            return false;
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == schemaBinaryBase.value[i]) continue;
            return false;
        }
        return true;
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaBinaryBase) {
            this.value = ((SchemaBinaryBase)schemaType).value;
            this.isempty = ((SchemaBinaryBase)schemaType).isempty;
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public byte[] getValue() {
        return this.value;
    }

    public void setValue(byte[] byArray) {
        this.value = byArray;
        this.isnull = byArray == null;
        this.isempty = byArray.length == 0;
    }

    public abstract void parse(String var1);

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = null;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = null;
    }

    public int hashCode() {
        if (this.value == null) {
            return 0;
        }
        return this.value[0];
    }

    public int length() {
        return this.value.length;
    }

    public boolean booleanValue() {
        return true;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaBinaryBase)object);
    }

    public int compareTo(SchemaBinaryBase schemaBinaryBase) {
        if (this.value.length != schemaBinaryBase.value.length) {
            return new Integer(this.value.length).compareTo(new Integer(schemaBinaryBase.value.length));
        }
        for (int i = 0; i < this.value.length; ++i) {
            if (this.value[i] == schemaBinaryBase.value[i]) continue;
            return new Integer(this.value[i]).compareTo(new Integer(schemaBinaryBase.value[i]));
        }
        return 0;
    }
}

