/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaInteger;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import com.jmex.model.collada.types.ValuesNotConvertableException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaDouble
implements SchemaTypeNumber {
    private static final long serialVersionUID = 1L;
    protected double value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaDouble() {
        this.setEmpty();
    }

    public SchemaDouble(SchemaDouble schemaDouble) {
        this.value = schemaDouble.value;
        this.isempty = schemaDouble.isempty;
        this.isnull = schemaDouble.isnull;
    }

    public SchemaDouble(double d) {
        this.setValue(d);
    }

    public SchemaDouble(String string2) {
        this.parse(string2);
    }

    public SchemaDouble(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDouble(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double d) {
        this.value = d;
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = Double.parseDouble(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).doubleValue();
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
        this.isempty = false;
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = 0.0;
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = 0.0;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.value);
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaDouble)) {
            return false;
        }
        return this.value == ((SchemaDouble)object).value;
    }

    public Object clone() {
        return new SchemaDouble(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        String string2 = Double.toString(this.value);
        if (string2.length() > 2 && string2.substring(string2.length() - 2, string2.length()).equals(".0")) {
            return string2.substring(0, string2.length() - 2);
        }
        return string2;
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value != 0.0 && this.value != Double.NaN;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaDouble)object);
    }

    public int compareTo(SchemaDouble schemaDouble) {
        return Double.compare(this.value, schemaDouble.value);
    }

    public int numericType() {
        return 5;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return (long)this.value;
    }

    public BigInteger bigIntegerValue() {
        try {
            return new BigInteger(this.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaInteger(0L));
        }
    }

    public float floatValue() {
        return (float)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public BigDecimal bigDecimalValue() {
        return new BigDecimal(this.value);
    }
}

