/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaCalendarBase;
import com.jmex.model.collada.types.SchemaDate;
import com.jmex.model.collada.types.SchemaDateTime;
import com.jmex.model.collada.types.SchemaString;
import com.jmex.model.collada.types.SchemaTime;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeCalendar;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.text.DecimalFormat;

public class SchemaDuration
extends SchemaCalendarBase {
    private static final long serialVersionUID = 1L;
    protected boolean bNegative;

    public SchemaDuration() {
        this.setEmpty();
    }

    public SchemaDuration(SchemaDuration schemaDuration) {
        this.year = schemaDuration.year;
        this.month = schemaDuration.month;
        this.day = schemaDuration.day;
        this.hour = schemaDuration.hour;
        this.minute = schemaDuration.minute;
        this.second = schemaDuration.second;
        this.partsecond = schemaDuration.partsecond;
        this.hasTZ = schemaDuration.hasTZ;
        this.offsetTZ = schemaDuration.offsetTZ;
        this.bNegative = schemaDuration.isNegative();
        this.isempty = schemaDuration.isempty;
    }

    public SchemaDuration(int n, int n2, int n3, int n4, int n5, int n6, double d, boolean bl) {
        this.setYear(n);
        this.setMonth(n2);
        this.setDay(n3);
        this.setHour(n4);
        this.setMinute(n5);
        this.setSecond(n6);
        this.setPartSecond(d);
        this.bNegative = bl;
        this.isempty = false;
    }

    public SchemaDuration(String string2) {
        this.parse(string2);
    }

    public SchemaDuration(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaDuration(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public int getYear() {
        return this.year;
    }

    public int getMonth() {
        return this.month;
    }

    public int getDay() {
        return this.day;
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public double getPartSecond() {
        return this.partsecond;
    }

    public int getMillisecond() {
        return (int)Math.round(this.partsecond * 1000.0);
    }

    public boolean isNegative() {
        return this.bNegative;
    }

    public void setYear(int n) {
        if (n < 0) {
            this.year = -n;
            this.bNegative = true;
        } else {
            this.year = n;
        }
        this.isempty = false;
    }

    public void setMonth(int n) {
        if (n < 0) {
            this.month = -n;
            this.bNegative = true;
        } else {
            this.month = n;
        }
        this.isempty = false;
    }

    public void setDay(int n) {
        if (n < 0) {
            this.day = -n;
            this.bNegative = true;
        } else {
            this.day = n;
        }
        this.isempty = false;
    }

    public void setHour(int n) {
        if (n < 0) {
            this.hour = -n;
            this.bNegative = true;
        } else {
            this.hour = n;
        }
        this.isempty = false;
    }

    public void setMinute(int n) {
        if (n < 0) {
            this.minute = -n;
            this.bNegative = true;
        } else {
            this.minute = n;
        }
        this.isempty = false;
    }

    public void setSecond(int n) {
        if (n < 0) {
            this.second = -n;
            this.bNegative = true;
        } else {
            this.second = n;
        }
        this.isempty = false;
    }

    public void setPartSecond(double d) {
        if (d < 0.0) {
            this.partsecond = -d;
            this.bNegative = true;
        } else {
            this.partsecond = d;
        }
        this.isempty = false;
    }

    public void setMillisecond(int n) {
        int n2;
        int n3 = n;
        if (n3 < 0) {
            n2 = n / 1000 + 1;
            n3 = n2 * 1000 + n;
            this.second = !this.bNegative ? (this.second -= n2) : (this.second += n2 - 1);
        }
        if (n3 >= 1000) {
            n2 = n3 / 1000;
            n3 %= 1000;
            this.second = !this.bNegative ? (this.second += n2) : (this.second -= n2);
        }
        this.partsecond = (double)n3 / 1000.0;
        this.isempty = false;
    }

    public void setNegative(boolean bl) {
        this.bNegative = bl;
        this.isempty = false;
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull() || schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaDuration) {
            this.setInternalValues(((SchemaDuration)schemaType).year, ((SchemaDuration)schemaType).month, ((SchemaDuration)schemaType).day, ((SchemaDuration)schemaType).hour, ((SchemaDuration)schemaType).minute, ((SchemaDuration)schemaType).second, ((SchemaDuration)schemaType).partsecond, 0, 0);
            this.bNegative = ((SchemaDuration)schemaType).bNegative;
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setEmpty() {
        this.setInternalValues(0, 0, 0, 0, 0, 0, 0.0, 0, 0);
        this.bNegative = false;
        this.isempty = true;
    }

    public Object clone() {
        return new SchemaDuration(this);
    }

    public String toString() {
        if (this.isempty) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.bNegative) {
            stringBuffer.append("-");
        }
        stringBuffer.append("P");
        if (this.year != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.year));
            stringBuffer.append("Y");
        }
        if (this.month != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.month));
            stringBuffer.append("M");
        }
        if (this.day != 0) {
            stringBuffer.append(new DecimalFormat("0").format(this.day));
            stringBuffer.append("D");
        }
        if (this.hour != 0 || this.minute != 0 || this.second != 0 || this.partsecond > 0.0) {
            stringBuffer.append("T");
            if (this.hour != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.hour));
                stringBuffer.append("H");
            }
            if (this.minute != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.minute));
                stringBuffer.append("M");
            }
            if (this.second != 0) {
                stringBuffer.append(new DecimalFormat("0").format(this.second));
            }
            if (this.partsecond > 0.0 && this.partsecond < 1.0) {
                String string2 = new DecimalFormat("0.0###############").format(this.partsecond);
                stringBuffer.append(".");
                stringBuffer.append(string2.substring(2, string2.length()));
            }
            if (this.second != 0 || this.partsecond > 0.0 && this.partsecond < 1.0) {
                stringBuffer.append("S");
            }
        }
        return stringBuffer.toString();
    }

    public boolean booleanValue() {
        return true;
    }

    public void parse(String string2) {
        int n;
        int n2 = string2.indexOf("P");
        if (n2 < 0) {
            throw new StringParseException("P expected", 0);
        }
        this.bNegative = n2 > 0 && string2.substring(n2 - 1, n2).compareTo("-") == 0;
        int n3 = n = string2.indexOf("Y", n2 + 1);
        int n4 = string2.indexOf("T", n2 + 1);
        n3 = n4 > n3 ? n4 : n3;
        try {
            if (n > n2) {
                this.year = Integer.parseInt(string2.substring(n2 + 1, n));
                n2 = n;
            } else {
                this.year = 0;
            }
            n = string2.indexOf("M", n2 + 1);
            int n5 = n3 = n > n3 ? n : n3;
            if (n > n2 && (n4 == -1 || n < n4)) {
                this.month = Integer.parseInt(string2.substring(n2 + 1, n));
                n2 = n;
            } else {
                this.month = 0;
            }
            n = string2.indexOf("D", n2 + 1);
            int n6 = n3 = n > n3 ? n : n3;
            if (n > n2) {
                this.day = Integer.parseInt(string2.substring(n2 + 1, n));
                n2 = n;
            } else {
                this.day = 0;
            }
            if (n4 > -1) {
                n2 = n4;
                n = string2.indexOf("H", n2 + 1);
                int n7 = n3 = n > n3 ? n : n3;
                if (n > n2) {
                    this.hour = Integer.parseInt(string2.substring(n2 + 1, n));
                    n2 = n;
                } else {
                    this.hour = 0;
                }
                n = string2.indexOf("M", n2 + 1);
                int n8 = n3 = n > n3 ? n : n3;
                if (n > n2) {
                    this.minute = Integer.parseInt(string2.substring(n2 + 1, n));
                    n2 = n;
                } else {
                    this.minute = 0;
                }
                this.second = 0;
                this.partsecond = 0.0;
                int n9 = string2.indexOf(".", n2 + 1);
                n = string2.indexOf("S", n2 + 1);
                int n10 = n3 = n > n3 ? n : n3;
                if (n9 == -1 && n > n2) {
                    this.second = Integer.parseInt(string2.substring(n2 + 1, n));
                } else if (n9 > n2 && n > n9) {
                    this.second = Integer.parseInt(string2.substring(n2 + 1, n9));
                    this.partsecond = Double.parseDouble("0." + string2.substring(n9 + 1, n));
                }
            } else {
                n3 = n3 > -1 ? n3 : 0;
            }
        }
        catch (NumberFormatException numberFormatException) {
            throw new StringParseException("invalid duration format", 2);
        }
        if (n3 + 1 < string2.length()) {
            throw new StringParseException("Invalid characters after the duration string", 2);
        }
        if (this.year < 0 || this.month < 0 || this.day < 0 || this.hour < 0 || this.minute < 0 || this.second < 0 || this.partsecond < 0.0) {
            throw new StringParseException("no negative values allowed in parts. Use '-' before 'P'.", 3);
        }
        this.isempty = false;
    }

    public int calendarType() {
        return 0;
    }

    public SchemaDuration durationValue() {
        return new SchemaDuration(this);
    }

    public SchemaDateTime dateTimeValue() {
        throw new TypesIncompatibleException(this, new SchemaDateTime("2003-07-28T12:00:00"));
    }

    public SchemaDate dateValue() {
        throw new TypesIncompatibleException(this, new SchemaDate("2003-07-28"));
    }

    public SchemaTime timeValue() {
        throw new TypesIncompatibleException(this, new SchemaTime("12:00:00"));
    }
}

