/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaDecimal;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeNumber;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import com.jmex.model.collada.types.ValuesNotConvertableException;
import java.math.BigDecimal;
import java.math.BigInteger;

public class SchemaInteger
implements SchemaTypeNumber {
    private static final long serialVersionUID = 1L;
    protected BigInteger value;
    protected boolean isempty;
    protected boolean isnull;

    public SchemaInteger() {
        this.setEmpty();
    }

    public SchemaInteger(SchemaInteger schemaInteger) {
        this.value = schemaInteger.value;
        this.isempty = schemaInteger.isempty;
        this.isnull = schemaInteger.isnull;
    }

    public SchemaInteger(BigInteger bigInteger) {
        this.setValue(bigInteger);
    }

    public SchemaInteger(long l) {
        this.setValue(l);
    }

    public SchemaInteger(String string2) {
        this.parse(string2);
    }

    public SchemaInteger(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaInteger(SchemaTypeNumber schemaTypeNumber) {
        this.assign(schemaTypeNumber);
    }

    public BigInteger getValue() {
        return this.value;
    }

    public void setValue(BigInteger bigInteger) {
        if (bigInteger == null) {
            this.isempty = true;
            this.isnull = true;
            this.value = BigInteger.valueOf(0L);
            return;
        }
        this.value = bigInteger;
        this.isempty = false;
        this.isnull = false;
    }

    public void setValue(long l) {
        this.value = BigInteger.valueOf(l);
        this.isempty = false;
        this.isnull = false;
    }

    public void parse(String string2) {
        if (string2 == null) {
            this.setNull();
        } else if (string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.value = new BigInteger(string2);
                this.isempty = false;
                this.isnull = false;
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException(numberFormatException);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull()) {
            this.setNull();
        } else if (schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTypeNumber) {
            this.value = ((SchemaTypeNumber)schemaType).bigIntegerValue();
            this.isempty = false;
            this.isnull = false;
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public void setNull() {
        this.isnull = true;
        this.isempty = true;
        this.value = BigInteger.valueOf(0L);
    }

    public void setEmpty() {
        this.isnull = false;
        this.isempty = true;
        this.value = BigInteger.valueOf(0L);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof SchemaInteger)) {
            return false;
        }
        return this.value.equals(((SchemaInteger)object).value);
    }

    public Object clone() {
        return new SchemaInteger(this);
    }

    public String toString() {
        if (this.isempty || this.isnull) {
            return "";
        }
        return this.value.toString();
    }

    public int length() {
        return this.toString().length();
    }

    public boolean booleanValue() {
        return this.value.compareTo(BigInteger.valueOf(0L)) != 0;
    }

    public boolean isEmpty() {
        return this.isempty;
    }

    public boolean isNull() {
        return this.isnull;
    }

    public int compareTo(Object object) {
        return this.compareTo((SchemaInteger)object);
    }

    public int compareTo(SchemaInteger schemaInteger) {
        return this.value.compareTo(schemaInteger.value);
    }

    public int numericType() {
        return 3;
    }

    public int intValue() {
        return this.value.intValue();
    }

    public long longValue() {
        return this.value.longValue();
    }

    public BigInteger bigIntegerValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value.floatValue();
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public BigDecimal bigDecimalValue() {
        try {
            return new BigDecimal(this.value.toString());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ValuesNotConvertableException(this, new SchemaDecimal(0.0));
        }
    }
}

