/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.types;

import com.jmex.model.collada.types.SchemaCalendarBase;
import com.jmex.model.collada.types.SchemaDate;
import com.jmex.model.collada.types.SchemaDateTime;
import com.jmex.model.collada.types.SchemaString;
import com.jmex.model.collada.types.SchemaType;
import com.jmex.model.collada.types.SchemaTypeCalendar;
import com.jmex.model.collada.types.StringParseException;
import com.jmex.model.collada.types.TypesIncompatibleException;
import java.util.Calendar;
import java.util.SimpleTimeZone;

public class SchemaTime
extends SchemaCalendarBase {
    private static final long serialVersionUID = 1L;

    public SchemaTime() {
    }

    public SchemaTime(SchemaTime schemaTime) {
        this.setInternalValues(0, 0, 0, schemaTime.hour, schemaTime.minute, schemaTime.second, schemaTime.partsecond, schemaTime.hasTZ, schemaTime.offsetTZ);
        this.isempty = schemaTime.isempty;
    }

    public SchemaTime(SchemaDateTime schemaDateTime) {
        this.setInternalValues(0, 0, 0, schemaDateTime.hour, schemaDateTime.minute, schemaDateTime.second, schemaDateTime.partsecond, schemaDateTime.hasTZ, schemaDateTime.offsetTZ);
        this.isempty = schemaDateTime.isempty;
    }

    public SchemaTime(int n, int n2, int n3, double d, int n4) {
        this.setInternalValues(0, 0, 0, n, n2, n3, d, 2, n4);
        this.isempty = false;
    }

    public SchemaTime(int n, int n2, int n3, double d) {
        this.setInternalValues(0, 0, 0, n, n2, n3, d, 0, 0);
        this.isempty = false;
    }

    public SchemaTime(Calendar calendar) {
        this.setValue(calendar);
    }

    public SchemaTime(String string2) {
        this.parse(string2);
    }

    public SchemaTime(SchemaType schemaType) {
        this.assign(schemaType);
    }

    public SchemaTime(SchemaTypeCalendar schemaTypeCalendar) {
        this.assign(schemaTypeCalendar);
    }

    public int getHour() {
        return this.hour;
    }

    public int getMinute() {
        return this.minute;
    }

    public int getSecond() {
        return this.second;
    }

    public double getPartSecond() {
        return this.partsecond;
    }

    public int getMillisecond() {
        return (int)Math.round(this.partsecond * 1000.0);
    }

    public int hasTimezone() {
        return this.hasTZ;
    }

    public int getTimezoneOffset() {
        if (this.hasTZ != 2) {
            return 0;
        }
        return this.offsetTZ;
    }

    public Calendar getValue() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, this.hour);
        calendar.set(12, this.minute);
        calendar.set(13, this.second);
        calendar.set(14, this.getMillisecond());
        this.hasTZ = 2;
        calendar.setTimeZone(new SimpleTimeZone(this.offsetTZ * 60000, ""));
        return calendar;
    }

    public void setHour(int n) {
        this.hour = n;
        this.isempty = false;
    }

    public void setMinute(int n) {
        this.minute = n;
        this.isempty = false;
    }

    public void setSecond(int n) {
        this.second = n;
        this.isempty = false;
    }

    public void setPartSecond(double d) {
        this.partsecond = d;
        this.isempty = false;
    }

    public void setMillisecond(int n) {
        this.partsecond = (double)n / 1000.0;
        this.isempty = false;
    }

    public void setTimezone(int n, int n2) {
        this.hasTZ = n;
        this.offsetTZ = n2;
        this.isempty = false;
    }

    public void setValue(Calendar calendar) {
        if (calendar == null) {
            this.setNull();
        } else {
            this.hour = calendar.get(11);
            this.minute = calendar.get(12);
            this.second = calendar.get(13);
            this.setMillisecond(calendar.get(14));
            String string2 = calendar.getTimeZone().getID();
            this.hasTZ = 2;
            this.offsetTZ = calendar.get(15) / 60000;
            this.isempty = false;
        }
    }

    public void parse(String string2) {
        if (string2 == null || string2.length() == 0) {
            this.setEmpty();
        } else {
            try {
                this.parseTime(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new StringParseException("invalid time format", 2);
            }
        }
    }

    public void assign(SchemaType schemaType) {
        if (schemaType == null || schemaType.isNull() || schemaType.isEmpty()) {
            this.setEmpty();
        } else if (schemaType instanceof SchemaTime) {
            this.setInternalValues(0, 0, 0, ((SchemaTime)schemaType).hour, ((SchemaTime)schemaType).minute, ((SchemaTime)schemaType).second, ((SchemaTime)schemaType).partsecond, ((SchemaTime)schemaType).hasTZ, ((SchemaTime)schemaType).offsetTZ);
        } else if (schemaType instanceof SchemaDateTime) {
            this.setInternalValues(0, 0, 0, ((SchemaDateTime)schemaType).hour, ((SchemaDateTime)schemaType).minute, ((SchemaDateTime)schemaType).second, ((SchemaDateTime)schemaType).partsecond, ((SchemaDateTime)schemaType).hasTZ, ((SchemaDateTime)schemaType).offsetTZ);
        } else if (schemaType instanceof SchemaString) {
            this.parse(((Object)schemaType).toString());
        } else {
            throw new TypesIncompatibleException(schemaType, this);
        }
    }

    public Object clone() {
        return new SchemaTime(this);
    }

    public String toString() {
        if (this.isempty) {
            return "";
        }
        return this.toTimeString();
    }

    public static SchemaTime now() {
        return new SchemaTime(Calendar.getInstance());
    }

    public int calendarType() {
        return 3;
    }

    public SchemaDateTime dateTimeValue() {
        throw new TypesIncompatibleException(this, new SchemaDateTime("2003-07-28T12:00:00"));
    }

    public SchemaDate dateValue() {
        throw new TypesIncompatibleException(this, new SchemaDate("2003-07-28"));
    }

    public SchemaTime timeValue() {
        return new SchemaTime(this);
    }
}

