/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.model.collada.xml;

import com.jmex.model.collada.xml.Node;
import com.jmex.model.collada.xml.XmlException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.StringWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public abstract class Document
implements Serializable {
    protected static DocumentBuilderFactory factory = null;
    protected static DocumentBuilder builder = null;
    protected static boolean validation = false;
    protected org.w3c.dom.Document domDocument;
    protected String encoding = "UTF-8";
    protected String schemaLocation = null;
    protected String dtdLocation = null;

    public static void enableValidation(boolean bl) {
        validation = bl;
    }

    protected static synchronized DocumentBuilder getDomBuilder() {
        try {
            if (builder == null) {
                if (factory == null) {
                    factory = DocumentBuilderFactory.newInstance();
                    factory.setIgnoringElementContentWhitespace(true);
                    factory.setNamespaceAware(true);
                    if (validation) {
                        factory.setAttribute("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                        factory.setValidating(true);
                    }
                }
                builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException sAXParseException) {
                    }

                    public void error(SAXParseException sAXParseException) throws XmlException {
                        throw new XmlException(sAXParseException);
                    }

                    public void fatalError(SAXParseException sAXParseException) throws XmlException {
                        throw new XmlException(sAXParseException);
                    }
                });
            }
            return builder;
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new XmlException(parserConfigurationException);
        }
    }

    public synchronized org.w3c.dom.Document getDomDocument() {
        if (this.domDocument == null) {
            this.domDocument = Document.getDomBuilder().newDocument();
        }
        return this.domDocument;
    }

    public Element createRootElement(String string2, String string3) {
        Element element = null;
        if (this.dtdLocation != null && this.dtdLocation.length() != 0) {
            DocumentType documentType = Document.getDomBuilder().getDOMImplementation().createDocumentType(string3, null, this.dtdLocation);
            this.domDocument = Document.getDomBuilder().getDOMImplementation().createDocument(string2, string3, documentType);
            element = this.domDocument.getDocumentElement();
        } else {
            element = this.getDomDocument().createElementNS(string2, string3);
            this.domDocument.appendChild(element);
            element.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
            if (this.schemaLocation != null && this.schemaLocation.length() != 0) {
                if (string2 == null || string2.equals("")) {
                    element.setAttribute("xsi:noNamespaceSchemaLocation", this.schemaLocation);
                } else {
                    element.setAttribute("xsi:schemaLocation", string2 + " " + this.schemaLocation);
                }
            }
        }
        return element;
    }

    public void setEncoding(String string2) {
        this.encoding = string2;
    }

    public void setSchemaLocation(String string2) {
        this.schemaLocation = string2;
    }

    public void setDTDLocation(String string2) {
        this.dtdLocation = string2;
    }

    public org.w3c.dom.Node load(String string2) {
        try {
            return Document.getDomBuilder().parse(new File(string2)).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public org.w3c.dom.Node load(InputStream inputStream) {
        try {
            return Document.getDomBuilder().parse(inputStream).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public org.w3c.dom.Node loadFromString(String string2) {
        try {
            return Document.getDomBuilder().parse(new ByteArrayInputStream(string2.getBytes())).getDocumentElement();
        }
        catch (SAXException sAXException) {
            throw new XmlException(sAXException);
        }
        catch (IOException iOException) {
            throw new XmlException(iOException);
        }
    }

    public void save(String string2, Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        Document.internalSave(new StreamResult(new File(string2)), node.domNode.getOwnerDocument(), this.encoding);
    }

    public void save(OutputStream outputStream, Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        Document.internalSave(new StreamResult(outputStream), node.domNode.getOwnerDocument(), this.encoding);
    }

    public String saveToString(Node node) {
        Node.internalAdjustPrefix(node.domNode, true);
        node.adjustPrefix();
        StringWriter stringWriter = new StringWriter();
        Document.internalSave(new StreamResult(stringWriter), node.domNode.getOwnerDocument(), this.encoding);
        return stringWriter.toString();
    }

    protected static void internalSave(Result result, org.w3c.dom.Document document, String string2) {
        try {
            DOMSource dOMSource = new DOMSource(document);
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            if (string2 != null) {
                transformer.setOutputProperty("encoding", string2);
            }
            if (document.getDoctype() != null) {
                if (document.getDoctype().getPublicId() != null) {
                    transformer.setOutputProperty("doctype-public", document.getDoctype().getPublicId());
                }
                if (document.getDoctype().getSystemId() != null) {
                    transformer.setOutputProperty("doctype-system", document.getDoctype().getSystemId());
                }
            }
            transformer.transform(dOMSource, result);
        }
        catch (TransformerConfigurationException transformerConfigurationException) {
            throw new XmlException(transformerConfigurationException);
        }
        catch (TransformerException transformerException) {
            throw new XmlException(transformerException);
        }
    }

    public org.w3c.dom.Node transform(Node node, String string2) {
        try {
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer(new StreamSource(string2));
            DOMResult dOMResult = new DOMResult();
            transformer.transform(new DOMSource(node.domNode), dOMResult);
            return dOMResult.getNode();
        }
        catch (TransformerException transformerException) {
            throw new XmlException(transformerException);
        }
    }

    public abstract void declareNamespaces(Node var1);

    protected void declareNamespace(Node node, String string2, String string3) {
        node.declareNamespace(string2, string3);
    }
}

