/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.util.applet;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.lwjgl.LWJGLUtil;

public class LWJGLInstaller {
    private static boolean installed;
    private static final String MASTER_INSTALL_DIR = ".lwjglinstall";
    private static final String WATERMARK_FILE = ".lwjglinuse";
    private static final String NATIVES_PLATFORM_JAR;

    private LWJGLInstaller() {
    }

    public static synchronized void tempInstall() throws Exception {
        if (installed) {
            return;
        }
        try {
            HashMap files = (HashMap)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return LWJGLInstaller.validateCertificates();
                }
            });
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    LWJGLInstaller.uninstall();
                    return null;
                }
            });
            String user_temp_dir = LWJGLInstaller.getPriviledgedString("java.io.tmpdir");
            final String path = LWJGLInstaller.createTemporaryDir(user_temp_dir);
            LWJGLInstaller.writeFiles(files, path);
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    System.setProperty("org.lwjgl.librarypath", path);
                    System.setProperty("net.java.games.input.librarypath", path);
                    return null;
                }
            });
            installed = true;
        }
        catch (Exception e) {
            LWJGLUtil.log((String)("Failed extraction e = " + e.getMessage()));
            LWJGLInstaller.uninstall();
            throw e;
        }
    }

    private static HashMap validateCertificates() throws Exception {
        Certificate[] ownCerts = LWJGLInstaller.class.getProtectionDomain().getCodeSource().getCertificates();
        if (ownCerts == null || ownCerts.length == 0) {
            throw new Exception("Unable to get certificate chain for LWJGLInstaller");
        }
        InputStream is = LWJGLInstaller.class.getResourceAsStream(NATIVES_PLATFORM_JAR);
        if (is == null) {
            throw new Exception("Unable to open " + NATIVES_PLATFORM_JAR + ", which was expected to be on the classpath");
        }
        File tmp_jar_file = File.createTempFile("lwjgl", ".jar");
        LWJGLInstaller.copyFile(is, new FileOutputStream(tmp_jar_file));
        is.close();
        JarFile jar_file = new JarFile(tmp_jar_file);
        HashMap<String, byte[]> files = new HashMap<String, byte[]>();
        Enumeration<JarEntry> jar_entries = jar_file.entries();
        while (jar_entries.hasMoreElements()) {
            JarEntry native_entry = jar_entries.nextElement();
            if (native_entry.isDirectory() || native_entry.getName().indexOf(47) != -1) continue;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            InputStream jis = jar_file.getInputStream(native_entry);
            LWJGLInstaller.copyFile(jis, baos);
            files.put(native_entry.getName(), baos.toByteArray());
            LWJGLInstaller.validateCertificateChain(ownCerts, native_entry.getCertificates());
        }
        return files;
    }

    private static void validateCertificateChain(Certificate[] ownCerts, Certificate[] native_certs) throws Exception {
        if (native_certs == null) {
            throw new Exception("Unable to validate certificate chain. Native entry did not have a certificate chain at all");
        }
        if (ownCerts.length != native_certs.length) {
            throw new Exception("Unable to validate certificate chain. Chain differs in length [" + ownCerts.length + " vs " + native_certs.length + "]");
        }
        for (int i = 0; i < ownCerts.length; ++i) {
            if (ownCerts[i].equals(native_certs[i])) continue;
            throw new Exception("Certificate mismatch: " + ownCerts[i] + " != " + native_certs[i]);
        }
    }

    private static void writeFiles(final HashMap files, final String path) throws Exception {
        AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws IOException {
                Iterator i = files.keySet().iterator();
                while (i.hasNext()) {
                    String key = (String)i.next();
                    File out = new File(path + File.separator + key);
                    out.createNewFile();
                    ByteArrayInputStream is = new ByteArrayInputStream((byte[])files.get(key));
                    BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(out));
                    LWJGLInstaller.copyFile(is, os);
                    ((InputStream)is).close();
                }
                return null;
            }
        });
    }

    private static void copyFile(InputStream is, OutputStream os) throws IOException {
        int len;
        byte[] copy_buffer = new byte[4096];
        while ((len = is.read(copy_buffer)) > 0) {
            os.write(copy_buffer, 0, len);
        }
        os.close();
    }

    private static String createTemporaryDir(final String user_temp_dir) throws Exception {
        return (String)AccessController.doPrivileged(new PrivilegedExceptionAction(){

            public Object run() throws Exception {
                File tempDir = new File(user_temp_dir + File.separator + LWJGLInstaller.MASTER_INSTALL_DIR + File.separator + System.currentTimeMillis());
                if (!tempDir.mkdirs()) {
                    throw new IOException("Failed to create directory: " + tempDir);
                }
                File watermark = new File(tempDir.getAbsolutePath() + File.separator + LWJGLInstaller.WATERMARK_FILE);
                watermark.createNewFile();
                watermark.deleteOnExit();
                return tempDir.getAbsolutePath();
            }
        });
    }

    private static String getPriviledgedString(final String property) {
        return (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return System.getProperty(property);
            }
        });
    }

    private static void uninstall() {
        LWJGLUtil.log((String)"running LWJGL uninstaller");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String temp = System.getProperty("java.io.tmpdir");
                File tempDir = new File(temp + File.separator + LWJGLInstaller.MASTER_INSTALL_DIR);
                File[] files = tempDir.listFiles(new FileFilter(){

                    public boolean accept(File pathname) {
                        return this.isStale(pathname);
                    }

                    private boolean isStale(File directory) {
                        File installFile = new File(directory.getAbsolutePath() + File.separator + LWJGLInstaller.WATERMARK_FILE);
                        return !installFile.exists();
                    }
                });
                if (files != null) {
                    for (int i = 0; i < files.length; ++i) {
                        LWJGLInstaller.uninstall(files[i]);
                    }
                }
                return null;
            }
        });
    }

    private static void uninstall(File file) {
        File[] files = file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            files[i].delete();
        }
        file.delete();
    }

    static {
        NATIVES_PLATFORM_JAR = "/" + LWJGLUtil.getPlatformName() + "_natives.jar";
    }
}

