/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d;

import com.jme.math.Vector3f;
import com.jme.scene.TriMesh;
import com.jme.scene.batch.GeomBatch;
import com.jme.scene.state.AlphaState;
import com.jme.scene.state.MaterialState;
import com.jme.scene.state.RenderState;
import com.jme.scene.state.ZBufferState;
import com.jme.system.DisplaySystem;
import com.jmex.font3d.Glyph3D;
import com.jmex.font3d.Text3D;
import com.jmex.font3d.TextFactory;
import com.jmex.font3d.math.ClosedPolygon;
import java.awt.Font;
import java.awt.Shape;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.geom.FlatteningPathIterator;
import java.util.Hashtable;

public class Font3D
implements TextFactory {
    private static Hashtable<String, Font3D> loadedFonts = new Hashtable();
    TriMesh render_trimesh = new TriMesh();
    Glyph3D[] glyph3Ds = new Glyph3D[256];
    Font font;
    private double flatness;
    private boolean drawSides;
    private boolean drawFront;
    private boolean drawBack;
    private static AlphaState general_alphastate = null;
    private static MaterialState general_diffuse_material = null;
    boolean has_alpha_blending = false;
    boolean has_diffuse_material = false;

    public Font3D(Font font, double d, boolean bl, boolean bl2, boolean bl3) {
        if (font.getSize() != 1) {
            font = font.deriveFont(1.0f);
        }
        this.font = font;
        this.flatness = d;
        this.drawSides = bl;
        this.drawFront = bl2;
        this.drawBack = bl3;
        this.render_trimesh.clearBatches();
        for (int i = 0; i < 256; ++i) {
            try {
                GlyphVector glyphVector = font.layoutGlyphVector(new FontRenderContext(null, true, true), new char[]{(char)i}, 0, 1, 0);
                glyphVector.performDefaultLayout();
                ClosedPolygon closedPolygon = null;
                Glyph3D glyph3D = new Glyph3D((char)i);
                Shape shape = glyphVector.getGlyphOutline(0);
                FlatteningPathIterator flatteningPathIterator = new FlatteningPathIterator(shape.getPathIterator(new AffineTransform()), d);
                float[] fArray = new float[6];
                while (!flatteningPathIterator.isDone()) {
                    int n = flatteningPathIterator.currentSegment(fArray);
                    switch (n) {
                        case 0: {
                            closedPolygon = new ClosedPolygon();
                            closedPolygon.addPoint(new Vector3f(fArray[0], -fArray[1], 0.0f));
                            break;
                        }
                        case 1: {
                            closedPolygon.addPoint(new Vector3f(fArray[0], -fArray[1], 0.0f));
                            break;
                        }
                        case 4: {
                            closedPolygon.close();
                            glyph3D.addPolygon(closedPolygon);
                            closedPolygon = null;
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("unknown segment type " + n);
                        }
                    }
                    flatteningPathIterator.next();
                }
                glyph3D.setBounds(glyphVector.getGlyphLogicalBounds(0).getBounds2D());
                if (!glyph3D.isEmpty()) {
                    glyph3D.triangulate();
                    glyph3D.generateBatch(bl, bl2, bl3);
                    if (glyph3D.getBatch() != null) {
                        glyph3D.setBatchId(this.render_trimesh.getBatchCount());
                        this.render_trimesh.addBatch((GeomBatch)glyph3D.getBatch());
                    }
                }
                this.glyph3Ds[i] = glyph3D;
                continue;
            }
            catch (Exception exception) {
                System.out.println("\nERROR in char: (" + i + ":" + (char)i + "), the following is most likely due to glyphs constructed from other glyphs.... that does not work.");
                exception.printStackTrace();
            }
        }
        ZBufferState zBufferState = DisplaySystem.getDisplaySystem().getRenderer().createZBufferState();
        zBufferState.setFunction(1);
        zBufferState.setWritable(true);
        zBufferState.setEnabled(true);
        this.render_trimesh.setRenderState((RenderState)zBufferState);
        this.render_trimesh.lockMeshes();
    }

    public TriMesh getRenderTriMesh() {
        return this.render_trimesh;
    }

    public Text3D createText(String string, float f, int n) {
        Text3D text3D = new Text3D(this, string, f);
        return text3D;
    }

    public static void loadFont3D(String string, Font font, double d, boolean bl, boolean bl2, boolean bl3) {
        System.out.println("FontSize:  " + font.getSize());
        System.out.println("FontSize2D:" + font.getSize2D());
        Font3D font3D = new Font3D(font, d, bl, bl2, bl3);
        loadedFonts.put(string, font3D);
    }

    public static void unloadFont(String string) {
        loadedFonts.remove(string);
    }

    public static Text3D createText(String string, String string2, float f, int n) {
        Font3D font3D = loadedFonts.get(string);
        return font3D.createText(string2, f, n);
    }

    public Glyph3D getGlyph(char c) {
        return this.glyph3Ds[c];
    }

    public Font getFont() {
        return this.font;
    }

    public double getFlatness() {
        return this.flatness;
    }

    public boolean drawSides() {
        return this.drawSides;
    }

    public boolean drawFront() {
        return this.drawFront;
    }

    public boolean drawBack() {
        return this.drawBack;
    }

    public Glyph3D[] getGlyphs() {
        return this.glyph3Ds;
    }

    public boolean isMeshLocked() {
        return (this.render_trimesh.getLocks() & 2) != 0;
    }

    public void unlockMesh() {
        this.render_trimesh.unlockMeshes();
    }

    public void lockMesh() {
        this.render_trimesh.lockMeshes();
    }

    public void enableAlphaState() {
        if (this.has_alpha_blending) {
            return;
        }
        if (general_alphastate == null) {
            general_alphastate = DisplaySystem.getDisplaySystem().getRenderer().createAlphaState();
            general_alphastate.setBlendEnabled(true);
            general_alphastate.setSrcFunction(4);
            general_alphastate.setDstFunction(5);
            general_alphastate.setTestEnabled(true);
            general_alphastate.setTestFunction(7);
            general_alphastate.setEnabled(true);
        }
        this.render_trimesh.setRenderState((RenderState)general_alphastate);
        this.render_trimesh.setRenderQueueMode(3);
        this.has_alpha_blending = true;
        this.render_trimesh.updateRenderState();
    }

    public void enableDiffuseMaterial() {
        if (this.has_diffuse_material) {
            return;
        }
        if (general_diffuse_material == null) {
            general_diffuse_material = DisplaySystem.getDisplaySystem().getRenderer().createMaterialState();
            general_diffuse_material.setEnabled(true);
            general_diffuse_material.setColorMaterial(2);
        }
        this.render_trimesh.setRenderState((RenderState)general_diffuse_material);
        this.render_trimesh.updateRenderState();
    }
}

