/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.font3d.math;

import com.jme.math.Vector3f;
import com.jmex.font3d.math.GeometricException;
import com.jmex.font3d.math.PlanarEdge;
import com.jmex.font3d.math.PlanarVertex;
import com.jmex.font3d.math.TriangulationEdge;

public class TriangulationVertex
extends PlanarVertex {
    VertexType vert_type = VertexType.UNSET;
    public boolean is_left_chain = false;

    TriangulationVertex(int n, Vector3f vector3f) {
        super(n, vector3f);
    }

    boolean yLessThan(PlanarVertex planarVertex) {
        return this.point.y == planarVertex.point.y ? this.point.x > planarVertex.point.x : this.point.y < planarVertex.point.y;
    }

    VertexType getType() {
        if (this.vert_type == VertexType.UNSET) {
            System.out.println("PANIX !!! WE HAVE WRONG TYPE AND SUCH !");
        }
        return this.vert_type;
    }

    public String toString() {
        return "[indx:" + this.index + ",(" + this.point.x + "," + this.point.y + "),type:" + (Object)((Object)this.vert_type) + "]";
    }

    public void initializeType() {
        TriangulationEdge triangulationEdge = this.getOutGoingEdge();
        TriangulationEdge triangulationEdge2 = this.getInGoingEdge();
        TriangulationVertex triangulationVertex = (TriangulationVertex)triangulationEdge2.getOrigin();
        TriangulationVertex triangulationVertex2 = (TriangulationVertex)triangulationEdge.getTwin().getOrigin();
        if (triangulationVertex.yLessThan(this) && triangulationVertex2.yLessThan(this)) {
            Vector3f vector3f = triangulationVertex.point;
            Vector3f vector3f2 = this.point;
            Vector3f vector3f3 = triangulationVertex2.point;
            float f = (vector3f2.x - vector3f.x) * (vector3f3.y - vector3f.y) - (vector3f3.x - vector3f.x) * (vector3f2.y - vector3f.y);
            this.vert_type = f > 0.0f ? VertexType.START : VertexType.SPLIT;
        } else if (this.yLessThan(triangulationVertex) && this.yLessThan(triangulationVertex2)) {
            Vector3f vector3f = triangulationVertex.point;
            Vector3f vector3f4 = this.point;
            Vector3f vector3f5 = triangulationVertex2.point;
            float f = (vector3f4.x - vector3f.x) * (vector3f5.y - vector3f.y) - (vector3f5.x - vector3f.x) * (vector3f4.y - vector3f.y);
            this.vert_type = f > 0.0f ? VertexType.END : VertexType.MERGE;
        } else if (triangulationVertex.yLessThan(this)) {
            this.vert_type = VertexType.REGULAR_RIGHT;
        } else if (triangulationVertex2.yLessThan(this)) {
            this.vert_type = VertexType.REGULAR_LEFT;
        } else {
            System.out.println("PNIX: we are none of the above types !!!!");
            System.out.println("GetType: (prev:" + triangulationVertex + ",this:" + this + ",next:" + triangulationVertex2);
        }
    }

    public boolean checkAllEdges() {
        PlanarEdge planarEdge;
        int n = 10000;
        int n2 = 0;
        PlanarEdge planarEdge2 = this.getFirstEdge();
        float f = 0.0f;
        float f2 = 6.283186f;
        n2 = 0;
        if (planarEdge2 != null) {
            n = 10000;
            do {
                if (planarEdge2.getOrigin() != this) {
                    throw new GeometricException("edge " + planarEdge2 + " does not have a correct origin");
                }
                planarEdge = planarEdge2;
                do {
                    if (planarEdge.isRealEdge() != planarEdge.getPrev().isRealEdge()) {
                        System.out.println("Edge1:" + planarEdge);
                        System.out.println("Edge2:" + planarEdge.getPrev());
                        throw new GeometricException("Bound two edges, one real one unreal, that is not possible in a closed polygon");
                    }
                    planarEdge = planarEdge.getPrev();
                    if (n-- > 0) continue;
                    throw new GeometricException("Sanity check !");
                } while (planarEdge != planarEdge2);
                f += planarEdge2.getTwin().getNext().angleCounterClockWise(planarEdge2);
                ++n2;
                if (!(f > f2)) continue;
                System.out.println("HERE ARE MY EDGES");
                this.printEdges();
                throw new GeometricException("The sum of angles between edges exceeded 2 PI (" + f + " > " + f2 + ") on this vert: " + this);
            } while ((planarEdge2 = planarEdge2.getTwin().getNext()) != this.getFirstEdge());
        }
        planarEdge2 = this.getFirstEdge();
        f = 0.0f;
        n2 = 0;
        if (planarEdge2 != null) {
            n = 10000;
            n2 = 0;
            do {
                if (planarEdge2.getOrigin() != this) {
                    throw new GeometricException("edge " + planarEdge2 + " does not have a correct origin");
                }
                planarEdge = planarEdge2;
                do {
                    if (planarEdge.isRealEdge() != planarEdge.getNext().isRealEdge()) {
                        System.out.println("VERT: " + planarEdge.getOrigin());
                        System.out.println("Edge1:" + planarEdge);
                        System.out.println("Edge2:" + planarEdge.getNext());
                        throw new GeometricException("Bound two edges, one real one unreal, that is not possible in a closed polygon");
                    }
                    planarEdge = planarEdge.getNext();
                    if (n-- > 0) continue;
                    throw new GeometricException("Sanity check !");
                } while (planarEdge != planarEdge2);
                f += planarEdge2.angleCounterClockWise(planarEdge2.getPrev().getTwin());
                ++n2;
                if (!(f > f2)) continue;
                throw new GeometricException("The sum of angles between edges exceeded 2 PI (" + f + " > " + f2 + ") on this vert: " + this);
            } while ((planarEdge2 = planarEdge2.getPrev().getTwin()) != this.getFirstEdge());
        }
        return true;
    }

    public TriangulationEdge getOutGoingEdge() {
        if (this.getFirstEdge() == null) {
            return null;
        }
        TriangulationEdge triangulationEdge = (TriangulationEdge)this.getFirstEdge();
        do {
            if (!triangulationEdge.isRealEdge()) continue;
            return triangulationEdge;
        } while ((triangulationEdge = (TriangulationEdge)triangulationEdge.getTwin().getNext()) != this.getFirstEdge());
        return null;
    }

    public TriangulationEdge getInGoingEdge() {
        if (this.getFirstEdge() == null) {
            return null;
        }
        TriangulationEdge triangulationEdge = (TriangulationEdge)this.getFirstEdge();
        do {
            if (!triangulationEdge.getTwin().isRealEdge()) continue;
            return (TriangulationEdge)triangulationEdge.getTwin();
        } while ((triangulationEdge = (TriangulationEdge)triangulationEdge.getTwin().getNext()) != this.getFirstEdge());
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum VertexType {
        START,
        END,
        SPLIT,
        MERGE,
        REGULAR_RIGHT,
        REGULAR_LEFT,
        UNSET;

    }
}

