/*
 * Decompiled with CFR 0.152.
 */
package com.jmex.game;

import com.jme.app.AbstractGame;
import com.jme.input.InputSystem;
import com.jme.input.MouseInput;
import com.jme.input.joystick.JoystickInput;
import com.jme.math.Vector3f;
import com.jme.renderer.Camera;
import com.jme.renderer.ColorRGBA;
import com.jme.system.DisplaySystem;
import com.jme.system.GameSettings;
import com.jme.system.PreferencesGameSettings;
import com.jme.system.dummy.DummyDisplaySystem;
import com.jme.util.GameTaskQueueManager;
import com.jme.util.LoggingSystem;
import com.jme.util.NanoTimer;
import com.jme.util.Timer;
import com.jmex.game.DefaultUncaughtExceptionHandler;
import com.jmex.game.state.GameStateManager;
import com.jmex.sound.openAL.SoundSystem;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.prefs.Preferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardGame
extends AbstractGame
implements Runnable {
    private Thread gameThread;
    private String gameName;
    private GameType type;
    private GameSettings settings;
    private boolean started;
    private Timer timer;
    private Camera camera;
    private ColorRGBA backgroundColor;
    private Thread.UncaughtExceptionHandler exceptionHandler;
    private Lock updateLock;

    public StandardGame(String string) {
        this(string, GameType.GRAPHICAL, null);
    }

    public StandardGame(String string, GameType gameType) {
        this(string, gameType, null);
    }

    public StandardGame(String string, GameType gameType, GameSettings gameSettings) {
        this(string, gameType, gameSettings, null);
    }

    public StandardGame(String string, GameType gameType, GameSettings gameSettings, Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.gameName = string;
        this.type = gameType;
        this.settings = gameSettings;
        this.exceptionHandler = uncaughtExceptionHandler;
        this.backgroundColor = ColorRGBA.black;
        if (this.settings == null) {
            this.settings = new PreferencesGameSettings(Preferences.userRoot().node(string));
        }
        this.updateLock = new ReentrantLock(true);
    }

    public void start() {
        this.gameThread = new Thread(this);
        if (this.exceptionHandler == null) {
            this.exceptionHandler = new DefaultUncaughtExceptionHandler(this);
        }
        this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
        this.gameThread.start();
        try {
            while (!this.isStarted()) {
                Thread.sleep(1L);
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
    }

    @Override
    public void run() {
        this.lock();
        this.initSystem();
        if (this.type != GameType.HEADLESS) {
            this.assertDisplayCreated();
            MouseInput.get().setCursorVisible(false);
        }
        this.initGame();
        if (this.type == GameType.GRAPHICAL) {
            this.timer = Timer.getTimer();
        } else if (this.type == GameType.HEADLESS) {
            this.timer = new NanoTimer();
        }
        int n = this.settings.getFramerate();
        long l = -1L;
        long l2 = -1L;
        long l3 = 0L;
        long l4 = -1L;
        if (n >= 0) {
            l = Math.round((float)this.timer.getResolution() / (float)n);
        }
        this.started = true;
        while (!this.finished && !this.display.isClosing()) {
            if (l >= 0L) {
                l2 = this.timer.getTime();
            }
            this.timer.update();
            float f = this.timer.getTimePerFrame();
            if (this.type == GameType.GRAPHICAL) {
                InputSystem.update();
            }
            this.update(f);
            this.render(f);
            this.display.getRenderer().displayBackBuffer();
            if (l >= 0L) {
                ++l3;
                l4 = this.timer.getTime() - l2;
                while (l4 < l) {
                    long l5 = (l - l4) * 1000L / this.timer.getResolution();
                    try {
                        Thread.sleep(l5);
                    }
                    catch (InterruptedException interruptedException) {
                        LoggingSystem.getLogger().log(Level.SEVERE, "Interrupted while sleeping in fixed-framerate", interruptedException);
                    }
                    l4 = this.timer.getTime() - l2;
                }
                if (l3 == Long.MAX_VALUE) {
                    l3 = 0L;
                }
            }
            Thread.yield();
        }
        this.started = false;
        this.cleanup();
        this.quit();
    }

    protected void initSystem() {
        if (this.type == GameType.GRAPHICAL) {
            JoystickInput.setProvider((String)"LWJGL");
            this.display = DisplaySystem.getDisplaySystem((String)this.settings.getRenderer());
            this.displayMins();
            this.display.createWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
            this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
            this.display.getRenderer().setBackgroundColor(this.backgroundColor);
            this.display.setVSyncEnabled(this.settings.isVerticalSync());
            this.cameraPerspective();
            this.cameraFrame();
            this.camera.update();
            this.display.getRenderer().setCamera(this.camera);
            this.display.setTitle(this.gameName);
            if (this.settings.isMusic() || this.settings.isSFX()) {
                SoundSystem.init((Camera)this.camera, (int)0);
            }
        } else {
            this.display = new DummyDisplaySystem();
        }
    }

    private void displayMins() {
        this.display.setMinDepthBits(this.settings.getDepthBits());
        this.display.setMinStencilBits(this.settings.getStencilBits());
        this.display.setMinAlphaBits(this.settings.getAlphaBits());
        this.display.setMinSamples(this.settings.getSamples());
    }

    private void cameraPerspective() {
        this.camera.setFrustumPerspective(45.0f, (float)this.display.getWidth() / (float)this.display.getHeight(), 1.0f, 1000.0f);
        this.camera.setParallelProjection(false);
        this.camera.update();
    }

    private void cameraFrame() {
        Vector3f vector3f = new Vector3f(0.0f, 0.0f, 25.0f);
        Vector3f vector3f2 = new Vector3f(-1.0f, 0.0f, 0.0f);
        Vector3f vector3f3 = new Vector3f(0.0f, 1.0f, 0.0f);
        Vector3f vector3f4 = new Vector3f(0.0f, 0.0f, -1.0f);
        this.camera.setFrame(vector3f, vector3f2, vector3f3, vector3f4);
    }

    public void resetCamera() {
        this.cameraFrame();
    }

    protected void initGame() {
        GameStateManager.create();
    }

    protected void update(float f) {
        this.unlock();
        this.lock();
        GameTaskQueueManager.getManager().getQueue("update").execute();
        GameStateManager.getInstance().update(f);
        if (this.type == GameType.GRAPHICAL && (this.settings.isMusic() || this.settings.isSFX())) {
            SoundSystem.update((float)f);
        }
    }

    protected void render(float f) {
        this.display.getRenderer().clearStatistics();
        this.display.getRenderer().clearBuffers();
        GameTaskQueueManager.getManager().getQueue("render").execute();
        GameStateManager.getInstance().render(f);
    }

    protected void reinit() {
        this.displayMins();
        SoundSystem.stopAllSamples();
        this.display.recreateWindow(this.settings.getWidth(), this.settings.getHeight(), this.settings.getDepth(), this.settings.getFrequency(), this.settings.isFullscreen());
        this.camera = this.display.getRenderer().createCamera(this.display.getWidth(), this.display.getHeight());
        this.display.getRenderer().setBackgroundColor(this.backgroundColor);
        if (this.settings.isMusic() || this.settings.isSFX()) {
            SoundSystem.init((Camera)this.camera, (int)0);
        }
    }

    public void recreateGraphicalContext() {
        GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                StandardGame.this.reinit();
                return null;
            }
        });
    }

    protected void cleanup() {
        GameStateManager.getInstance().cleanup();
    }

    protected void quit() {
        if (this.display != null) {
            this.display.reset();
            this.display.close();
        }
    }

    public DisplaySystem getDisplay() {
        return this.display;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public GameSettings getSettings() {
        return this.settings;
    }

    public void setBackgroundColor(ColorRGBA colorRGBA) {
        this.backgroundColor = colorRGBA;
    }

    public void shutdown() {
        JoystickInput.destroyIfInitalized();
        this.finish();
    }

    public boolean isStarted() {
        return this.started;
    }

    public void setUncaughtExceptionHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        this.exceptionHandler = uncaughtExceptionHandler;
        this.gameThread.setUncaughtExceptionHandler(this.exceptionHandler);
    }

    public void delayForUpdate() throws InterruptedException, ExecutionException {
        Future future = GameTaskQueueManager.getManager().update((Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return null;
            }
        });
        future.get();
    }

    public boolean inGLThread() {
        return Thread.currentThread() == this.gameThread;
    }

    public <T> T executeInGL(Callable<T> callable) throws Exception {
        if (this.inGLThread()) {
            return callable.call();
        }
        Future future = GameTaskQueueManager.getManager().update(callable);
        return (T)future.get();
    }

    public void lock() {
        this.updateLock.lock();
    }

    public void unlock() {
        this.updateLock.unlock();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GameType {
        GRAPHICAL,
        HEADLESS;

    }
}

